/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.util;

import com.softlabs.warlords4.util.Files;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public final class StreamUtil {
    public static final int INITIAL_BUFFER_SIZE = 1024;

    private StreamUtil() {
    }

    public static byte[] toByteArray(InputStream input) {
        try {
            byte[] result;
            int blockSize;
            if (input.available() > 1024) {
                for (blockSize = 1024; blockSize < input.available(); blockSize <<= 1) {
                }
            }
            int status = 0;
            int totalBytesRead = 0;
            int blockCount = 1;
            boolean endOfStream = false;
            int bytesRead = 0;
            byte[] buffer = new byte[blockSize];
            byte[] dynamicBuffer = new byte[input.available()];
            while (!endOfStream) {
                bytesRead = 0;
                if (input.available() != 0) {
                    status = input.read(buffer);
                    boolean bl = endOfStream = status == -1;
                    if (!endOfStream) {
                        bytesRead = status;
                    }
                } else {
                    status = input.read();
                    endOfStream = status == -1;
                    buffer[0] = (byte)status;
                    if (!endOfStream) {
                        bytesRead = 1;
                    }
                }
                if (endOfStream) continue;
                if (totalBytesRead + bytesRead > dynamicBuffer.length) {
                    byte[] newBuffer = new byte[blockSize * ++blockCount];
                    System.arraycopy(dynamicBuffer, 0, newBuffer, 0, totalBytesRead);
                    dynamicBuffer = newBuffer;
                }
                System.arraycopy(buffer, 0, dynamicBuffer, totalBytesRead, bytesRead);
                totalBytesRead += bytesRead;
            }
            if (totalBytesRead == dynamicBuffer.length) {
                result = dynamicBuffer;
            } else {
                result = new byte[totalBytesRead];
                if (totalBytesRead != 0) {
                    System.arraycopy(dynamicBuffer, 0, result, 0, totalBytesRead);
                }
            }
            return result;
        }
        catch (Throwable e) {
            return new byte[0];
        }
    }

    public static InputStream getInputStream(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        InputStream in = null;
        try {
            in = StreamUtil.class.getResourceAsStream(name);
        }
        catch (Throwable exception) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = StreamUtil.class.getResourceAsStream("/" + name);
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        if (in == null) {
            try {
                URL url = new URL(name);
                in = url.openStream();
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        if (in == null) {
            try {
                in = new BufferedInputStream(new FileInputStream(name), 1024);
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        if (in == null) {
            if (!(name = name.replace('\\', '/')).startsWith("/")) {
                name = '/' + name;
            }
            try {
                in = StreamUtil.class.getResourceAsStream(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return in;
    }

    public static final OutputStream getOutputStream(String path, boolean append) {
        boolean isHTTP;
        OutputStream stream = null;
        String parent = Files.getPath(path);
        boolean bl = isHTTP = path.indexOf(58) > 1;
        if (isHTTP) {
            try {
                URL url = new URL(path);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                stream = conn.getOutputStream();
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        if (stream == null) {
            try {
                Files.mkdirs(parent);
                stream = new FileOutputStream(path, append);
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        return stream;
    }
}

