/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.util;

import java.io.IOException;
import java.io.Reader;

public class ReaderTokenizer {
    private static final int NEED_CHAR = Integer.MAX_VALUE;
    private static final int SKIP_LF = 0x7FFFFFFE;
    private static final byte CT_WHITESPACE = 1;
    private static final byte CT_DIGIT = 2;
    private static final byte CT_ALPHA = 4;
    private static final byte CT_QUOTE = 8;
    private static final byte CT_COMMENT = 16;
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    public static final int TT_NOTHING = -4;
    public static final int TT_CHAR = -5;
    private Reader reader;
    private boolean pushedBack;
    private boolean forceLower;
    private int lineno = 1;
    private boolean eolIsSignificant;
    private boolean slashSlashComments;
    private boolean slashStarComments;
    private int peekc = Integer.MAX_VALUE;
    public int ttype = -4;
    public char cval = '\u0000';
    public String sval = null;
    public double nval = 0.0;
    private byte[] ctype = new byte[256];
    private char[] buf = new char[20];

    protected ReaderTokenizer() {
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.commentChar(47);
        this.quoteChar(34);
        this.quoteChar(39);
        this.parseNumbers();
    }

    public ReaderTokenizer(Reader r) {
        this();
        if (r == null) {
            throw new NullPointerException();
        }
        this.reader = r;
    }

    public String toString() {
        String ret;
        switch (this.ttype) {
            case -1: {
                ret = "EOF";
                break;
            }
            case 10: {
                ret = "EOL";
                break;
            }
            case -3: {
                ret = this.sval;
                break;
            }
            case -5: {
                ret = "'" + this.cval + "'";
                break;
            }
            case -2: {
                ret = "n=" + this.nval;
                break;
            }
            default: {
                ret = "NOTHING";
            }
        }
        return "Token[" + ret + "], line " + this.lineno;
    }

    public void resetSyntax() {
        for (int i = 0; i < this.ctype.length; ++i) {
            this.ctype[i] = 0;
        }
    }

    public void wordChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            int n = low++;
            this.ctype[n] = (byte)(this.ctype[n] | 4);
        }
    }

    public void whitespaceChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            this.ctype[low++] = 1;
        }
    }

    public void ordinaryChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            this.ctype[low++] = 0;
        }
    }

    public void ordinaryChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 0;
        }
    }

    public void commentChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 16;
        }
    }

    public void quoteChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 8;
        }
    }

    public void parseNumbers() {
        int i = 48;
        while (i <= 57) {
            int n = i++;
            this.ctype[n] = (byte)(this.ctype[n] | 2);
        }
        this.ctype[46] = (byte)(this.ctype[46] | 2);
        this.ctype[45] = (byte)(this.ctype[45] | 2);
    }

    public void eolIsSignificant(boolean flag) {
        this.eolIsSignificant = flag;
    }

    public void slashStarComments(boolean flag) {
        this.slashStarComments = flag;
    }

    public void slashSlashComments(boolean flag) {
        this.slashSlashComments = flag;
    }

    public void lowerCaseMode(boolean fl) {
        this.forceLower = fl;
    }

    public void pushBack() {
        if (this.ttype != -4) {
            this.pushedBack = true;
        }
    }

    public int lineno() {
        return this.lineno;
    }

    public int nextToken() throws IOException {
        int curtype;
        if (this.pushedBack) {
            this.pushedBack = false;
            return this.ttype;
        }
        this.sval = null;
        this.cval = '\u0000';
        this.nval = Double.NaN;
        int c = this.peekc;
        if (c < 0) {
            c = Integer.MAX_VALUE;
        }
        if (c == 0x7FFFFFFE) {
            c = this.reader.read();
            if (c < 0) {
                this.ttype = -1;
                return -1;
            }
            if (c == 10) {
                c = Integer.MAX_VALUE;
            }
        }
        if (c == Integer.MAX_VALUE && (c = this.reader.read()) < 0) {
            this.ttype = -1;
            return -1;
        }
        this.peekc = Integer.MAX_VALUE;
        int n = curtype = c < 256 ? this.ctype[c] : 4;
        while ((curtype & 1) != 0) {
            if (c == 13) {
                ++this.lineno;
                if (this.eolIsSignificant) {
                    this.peekc = 0x7FFFFFFE;
                    this.ttype = 10;
                    return 10;
                }
                c = this.reader.read();
                if (c == 10) {
                    c = this.reader.read();
                }
            } else {
                if (c == 10) {
                    ++this.lineno;
                    if (this.eolIsSignificant) {
                        this.ttype = 10;
                        return 10;
                    }
                }
                c = this.reader.read();
            }
            if (c < 0) {
                this.ttype = -1;
                return -1;
            }
            curtype = c < 256 ? this.ctype[c] : 4;
        }
        if ((curtype & 2) != 0) {
            boolean neg = false;
            if (c == 45) {
                c = this.reader.read();
                if (c != 46 && (c < 48 || c > 57)) {
                    this.peekc = c;
                    this.cval = (char)c;
                    this.ttype = -5;
                    return -5;
                }
                neg = true;
            }
            double v = 0.0;
            int decexp = 0;
            int seendot = 0;
            while (true) {
                if (c == 46 && seendot == 0) {
                    seendot = 1;
                } else {
                    if (48 > c || c > 57) break;
                    v = v * 10.0 + (double)(c - 48);
                    decexp += seendot;
                }
                c = this.reader.read();
            }
            this.peekc = c;
            if (decexp != 0) {
                double denom = 10.0;
                --decexp;
                while (decexp > 0) {
                    denom *= 10.0;
                    --decexp;
                }
                v /= denom;
            }
            this.nval = neg ? -v : v;
            this.ttype = -2;
            return -2;
        }
        if ((curtype & 4) != 0) {
            int i = 0;
            do {
                if (i >= this.buf.length) {
                    char[] nb = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                    this.buf = nb;
                }
                this.buf[i++] = (char)c;
            } while (((curtype = (c = this.reader.read()) < 0 ? 1 : (c < 256 ? this.ctype[c] : 4)) & 6) != 0);
            this.peekc = c;
            this.sval = String.copyValueOf(this.buf, 0, i);
            if (this.forceLower) {
                this.sval = this.sval.toLowerCase();
            }
            this.ttype = -3;
            return -3;
        }
        if ((curtype & 8) != 0) {
            this.ttype = c;
            int i = 0;
            int d = this.reader.read();
            while (d >= 0 && d != this.ttype) {
                if (d == 92) {
                    int first = c = this.reader.read();
                    if (c >= 48 && c <= 55) {
                        c -= 48;
                        int c2 = this.reader.read();
                        if (48 <= c2 && c2 <= 55) {
                            c = (c << 3) + (c2 - 48);
                            c2 = this.reader.read();
                            if (48 <= c2 && c2 <= 55 && first <= 51) {
                                c = (c << 3) + (c2 - 48);
                                d = this.reader.read();
                            } else {
                                d = c2;
                            }
                        } else {
                            d = c2;
                        }
                    } else {
                        switch (c) {
                            case 97: {
                                c = 7;
                                break;
                            }
                            case 98: {
                                c = 8;
                                break;
                            }
                            case 102: {
                                c = 12;
                                break;
                            }
                            case 110: {
                                c = 10;
                                break;
                            }
                            case 114: {
                                c = 13;
                                break;
                            }
                            case 116: {
                                c = 9;
                                break;
                            }
                            case 118: {
                                c = 11;
                            }
                        }
                        d = this.reader.read();
                    }
                } else {
                    c = d;
                    d = this.reader.read();
                }
                if (i >= this.buf.length) {
                    char[] nb = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
                    this.buf = nb;
                }
                this.buf[i++] = (char)c;
                if (c != 10) continue;
                ++this.lineno;
            }
            this.peekc = d == this.ttype ? Integer.MAX_VALUE : d;
            this.sval = String.copyValueOf(this.buf, 0, i);
            this.ttype = -3;
            return -3;
        }
        if (c == 47 && (this.slashSlashComments || this.slashStarComments)) {
            c = this.reader.read();
            if (c == 42 && this.slashStarComments) {
                int prevc = 0;
                while ((c = this.reader.read()) != 47 || prevc != 42) {
                    if (c == 13) {
                        ++this.lineno;
                        c = this.reader.read();
                        if (c == 10) {
                            c = this.reader.read();
                        }
                    } else if (c == 10) {
                        ++this.lineno;
                        c = this.reader.read();
                    }
                    if (c < 0) {
                        this.ttype = -1;
                        return -1;
                    }
                    prevc = c;
                }
                return this.nextToken();
            }
            if (c == 47 && this.slashSlashComments) {
                while ((c = this.reader.read()) != 10 && c != 13 && c >= 0) {
                }
                this.peekc = c;
                return this.nextToken();
            }
            if ((this.ctype[47] & 0x10) != 0) {
                while ((c = this.reader.read()) != 10 && c != 13 && c >= 0) {
                }
                this.peekc = c;
                return this.nextToken();
            }
            this.peekc = c;
            this.cval = (char)c;
            this.ttype = -5;
            return -5;
        }
        if ((curtype & 0x10) != 0) {
            while ((c = this.reader.read()) != 10 && c != 13 && c >= 0) {
            }
            this.peekc = c;
            return this.nextToken();
        }
        this.cval = (char)c;
        this.ttype = -5;
        return -5;
    }
}

