/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.util;

import com.softlabs.warlords4.util.StreamUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Locale;

public final class Files {
    public static final String FILE_PROTOCOL = "file:///";
    public static final String HTTP_PROTOCOL = "http://";
    public static final String HTTPS_PROTOCOL = "https://";
    public static final String FTP_PROTOCOL = "ftp://";

    private Files() {
    }

    public static final String setExtension(String path, String extension, boolean force) {
        String curExt = Files.getExtension(path);
        String newPath = path;
        if (curExt == null) {
            newPath = path + "." + extension;
        } else if (extension != null && curExt.compareTo(extension) != 0 && force) {
            newPath = path.substring(0, path.length() - curExt.length()) + extension;
        }
        return newPath;
    }

    public static final String getSystemBase() {
        String base = null;
        try {
            base = System.getProperty("user.dir");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return base;
    }

    public static final String getNameExtension(String path) {
        String nameExt = null;
        if (path != null) {
            int indexOfSlash = path.lastIndexOf(47);
            int indexOfBackSlash = path.lastIndexOf(92);
            nameExt = indexOfSlash != -1 ? (indexOfBackSlash > indexOfSlash ? path.substring(indexOfBackSlash + 1) : path.substring(indexOfSlash + 1)) : path.substring(indexOfBackSlash + 1);
        }
        return nameExt;
    }

    public static final String getName(String path) {
        String ext;
        String name = Files.getNameExtension(path);
        if (name != null && (ext = Files.getExtension(name)) != null) {
            name = name.substring(0, name.length() - ext.length() - 1);
        }
        return name;
    }

    public static final String getExtension(String path) {
        String ext = Files.getNameExtension(path);
        if (ext != null) {
            int extensionIndex = ext.lastIndexOf(46);
            ext = extensionIndex >= 0 ? ext.substring(extensionIndex + 1).toLowerCase(Locale.getDefault()) : null;
        }
        return ext;
    }

    public static final String getExtension(File file) {
        return file == null ? null : Files.getExtension(file.toString());
    }

    public static final String getPath(String path) {
        String nameExt = Files.getNameExtension(path);
        if (nameExt != null) {
            path = path.substring(0, path.length() - nameExt.length());
        }
        if (path.endsWith(File.separator) || path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static final boolean exists(String path) {
        boolean exists = false;
        if (path != null && path.length() > 0) {
            try {
                InputStream in = StreamUtil.getInputStream(path);
                boolean bl = exists = in != null;
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return exists;
    }

    public static final boolean mkdirs(String path) {
        boolean ok = false;
        if (path != null) {
            File dirs;
            if (path.startsWith(FILE_PROTOCOL)) {
                path = path.substring(FILE_PROTOCOL.length());
            } else if (path.startsWith(FTP_PROTOCOL)) {
                path = path.substring(FTP_PROTOCOL.length());
            } else if (path.startsWith(HTTP_PROTOCOL)) {
                path = path.substring(HTTP_PROTOCOL.length());
            } else if (path.startsWith(HTTPS_PROTOCOL)) {
                path = path.substring(HTTPS_PROTOCOL.length());
            }
            if (path.length() > 0 && !(dirs = new File(path)).exists()) {
                ok = dirs.mkdirs();
            }
        }
        return ok;
    }
}

