/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.io;

import com.softlabs.warlords4.util.StreamUtil;
import java.io.IOException;
import java.io.OutputStream;

public class WarlordOutputStream
extends OutputStream {
    private OutputStream output;
    private int checkSum;

    public WarlordOutputStream(String target) throws IOException {
        this(StreamUtil.getOutputStream(target, false));
    }

    public WarlordOutputStream(OutputStream output) throws IOException {
        this.output = output;
        if (this.output == null) {
            throw new IOException("Impossible to save into a null stream!");
        }
    }

    public void writeInteger(int i) throws IOException {
        this.write(i >>> 0 & 0xFF);
        this.write(i >>> 8 & 0xFF);
        this.write(i >>> 16 & 0xFF);
        this.write(i >>> 24 & 0xFF);
    }

    public void writeBoolean(boolean b) throws IOException {
        this.writeInteger(b ? 1 : 0);
    }

    public void writeString(String string, int size) throws IOException {
        int max = string != null ? string.length() : 0;
        for (int i = 0; i < size; ++i) {
            if (string != null && i < max) {
                this.write((byte)string.charAt(i));
                continue;
            }
            this.write(0);
        }
        this.write(0);
    }

    public void writeShort(int s) throws IOException {
        this.write(s >>> 0 & 0xFF);
        this.write(s >>> 8 & 0xFF);
    }

    @Override
    public void write(int b) throws IOException {
        this.output.write(255 - b & 0xFF);
        this.checkSum ^= b;
    }

    public void checksum() throws IOException {
        this.output.write(this.checkSum);
        this.output.write(0);
        this.output.write(0);
        this.output.write(0);
    }

    @Override
    public void close() throws IOException {
        this.output.flush();
        this.output.close();
    }
}

