/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.io;

import com.softlabs.warlords4.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;

public class WarlordInputStream
extends InputStream {
    private InputStream in;

    public WarlordInputStream(String target) {
        this(StreamUtil.getInputStream(target));
    }

    public WarlordInputStream(InputStream input) {
        this.in = input;
        if (this.in == null) {
            throw new NullPointerException("Input stream cannot be null!");
        }
    }

    public final boolean readBoolean() throws IOException {
        return this.readInteger() != 0;
    }

    public int readShort() throws IOException {
        return this.read() | this.read() << 8;
    }

    public int readInteger() throws IOException {
        return this.read() | this.read() << 8 | this.read() << 16 | this.read() << 24;
    }

    public String readString(int size) throws IOException {
        char c;
        int i;
        StringBuffer buffer = new StringBuffer(size);
        for (i = 0; i < size && (c = (char)this.read()) >= ' '; ++i) {
            buffer.append(c);
        }
        while (i < size) {
            this.read();
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public int read() throws IOException {
        int value = this.in.read();
        if (value < 0) {
            return value;
        }
        return 255 - value;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }
}

