/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.io;

import com.softlabs.warlords4.data.Ability;
import com.softlabs.warlords4.data.Item;
import com.softlabs.warlords4.data.LabeledIcon;
import com.softlabs.warlords4.data.PBEMWarlord;
import com.softlabs.warlords4.data.Unit;
import com.softlabs.warlords4.data.Warlord;
import com.softlabs.warlords4.gui.UnitEditionPanel;
import com.softlabs.warlords4.io.WarlordInputStream;
import com.softlabs.warlords4.io.WarlordOutputStream;
import com.softlabs.warlords4.util.Files;
import com.softlabs.warlords4.util.StreamUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WarlordFactory {
    private WarlordFactory() {
    }

    private static final String readString(InputStream in, int size) throws IOException {
        int i;
        StringBuffer buffer = new StringBuffer(size);
        for (i = 0; i < size; ++i) {
            char c = (char)in.read();
            if (c < ' ') {
                ++i;
                break;
            }
            buffer.append(c);
        }
        while (i < size) {
            in.read();
            ++i;
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    public static final PBEMWarlord loadPBEM(String target) {
        PBEMWarlord pbemWarlord = new PBEMWarlord();
        try {
            int i;
            InputStream in = StreamUtil.getInputStream(target);
            pbemWarlord.setEmail(WarlordFactory.readString(in, 48));
            for (i = 0; i < 22; ++i) {
                in.read();
            }
            pbemWarlord.setNickname(WarlordFactory.readString(in, 31));
            for (i = 0; i < 39; ++i) {
                in.read();
            }
            pbemWarlord.setMessage(WarlordFactory.readString(in, 48));
            for (i = 0; i < 24; ++i) {
                in.read();
            }
            WarlordInputStream warStream = new WarlordInputStream(in);
            Warlord warlord = WarlordFactory.readWarlord(warStream);
            warStream.readInteger();
            pbemWarlord.setWarlord(warlord);
            for (int i2 = 0; i2 < 0; ++i2) {
                in.read();
            }
            pbemWarlord.setPassword(WarlordFactory.readString(in, 10));
            in.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            pbemWarlord = null;
        }
        return pbemWarlord;
    }

    public static final Warlord load(String target) {
        Warlord warlord = null;
        WarlordInputStream input = null;
        try {
            input = new WarlordInputStream(target);
            warlord = WarlordFactory.readWarlord(input);
        }
        catch (Throwable throwable) {
            warlord = null;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return warlord;
    }

    public static final Warlord loadPreMade(String target) {
        Warlord warlord = null;
        try {
            InputStream input = StreamUtil.getInputStream(target);
            input.read();
            input.read();
            input.read();
            input.read();
            input.read();
            input.read();
            input.read();
            input.read();
            input.read();
            input.read();
            input.read();
            input.read();
            WarlordInputStream in = new WarlordInputStream(input);
            warlord = WarlordFactory.readWarlord(in);
            input.close();
        }
        catch (Throwable throwable) {
            warlord = null;
        }
        return warlord;
    }

    private static final Warlord readWarlord(WarlordInputStream in) throws IOException {
        int i;
        Warlord warlord = new Warlord();
        warlord.setName(in.readString(31));
        warlord.setCapital(in.readString(31));
        warlord.setAvatar(in.readInteger());
        warlord.setMajorAbility(in.readInteger());
        warlord.setMinorAbility(in.readInteger());
        warlord.setRace(in.readInteger());
        warlord.setBattles(in.readInteger());
        warlord.setVictories(in.readInteger());
        warlord.setLevel(in.readInteger());
        warlord.setProvincesMask(in.readInteger());
        warlord.setClassType(in.readInteger());
        warlord.setExperience(in.readInteger());
        for (i = 0; i < 17; ++i) {
            warlord.setSkillLevel(i, in.readInteger());
        }
        for (i = 0; i < 23; ++i) {
            warlord.setCityUpgraded(i, in.readBoolean());
        }
        for (i = 0; i < 72; ++i) {
            in.read();
        }
        for (i = 0; i < 32; ++i) {
            warlord.setProvinceWon(i, in.readBoolean());
        }
        for (i = 0; i < 36; ++i) {
            in.read();
        }
        for (i = 0; i < 3; ++i) {
            warlord.setRetinue(i, WarlordFactory.readUnit(in));
        }
        in.readInteger();
        in.readInteger();
        return warlord;
    }

    public static final Unit readUnit(WarlordInputStream in) throws IOException {
        int count = 0;
        Unit unit = new Unit();
        try {
            ++count;
            unit.setRace(in.read());
            ++count;
            unit.setType(in.read());
            ++count;
            unit.setLife(in.read());
            ++count;
            unit.setCombat(in.read());
            ++count;
            unit.setUpgrade(in.read());
            ++count;
            in.read();
            ++count;
            unit.setUpkeep(in.read());
            ++count;
            unit.setMajorAbility(Ability.createAbility(in.read()));
            ++count;
            unit.setMajorLevel(in.read());
            ++count;
            unit.setMinorAbility(Ability.createAbility(in.read()));
            ++count;
            unit.setMinorLevel(in.read());
            ++count;
            in.read();
            count += 2;
            unit.setExperience(in.readShort());
            count += 2;
            unit.setLevel(in.readShort());
            count += 32;
            unit.setName(in.readString(31));
            ++count;
            unit.setHeadItem(Item.createItem(in.read()));
            ++count;
            unit.setWeaponItem(Item.createItem(in.read()));
            ++count;
            unit.setArmorItem(Item.createItem(in.read()));
            ++count;
            unit.setAccessoryItem(Item.createItem(in.read()));
            count += 4;
            unit.setID(in.readInteger());
        }
        catch (Throwable throwable) {
            unit = null;
        }
        for (int i = count; i < 56; ++i) {
            in.read();
        }
        return unit;
    }

    private static final void writeString(OutputStream out, String string, int size) throws IOException {
        int max = string != null ? string.length() : 0;
        for (int i = 0; i < size; ++i) {
            if (string != null && i < max) {
                out.write(string.charAt(i));
                continue;
            }
            out.write(0);
        }
    }

    public static final void savePBEM(String target, PBEMWarlord pbemWarlord) {
        try {
            int i;
            int i2;
            OutputStream output = StreamUtil.getOutputStream(target, false);
            WarlordFactory.writeString(output, pbemWarlord.getEmail(), 48);
            for (i2 = 0; i2 < 22; ++i2) {
                output.write(0);
            }
            WarlordFactory.writeString(output, pbemWarlord.getNickname(), 31);
            for (i2 = 0; i2 < 39; ++i2) {
                output.write(0);
            }
            WarlordFactory.writeString(output, pbemWarlord.getMessage(), 48);
            for (i2 = 0; i2 < 24; ++i2) {
                output.write(0);
            }
            WarlordOutputStream warStream = new WarlordOutputStream(output);
            WarlordFactory.writeWarlord(warStream, pbemWarlord.getWarlord());
            warStream.writeInteger(0);
            for (i = 0; i < 0; ++i) {
                output.write(0);
            }
            WarlordFactory.writeString(output, pbemWarlord.getPassword(), 10);
            for (i = 0; i < 2; ++i) {
                output.write(0);
            }
            output.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static final void savePreMade(String target, Warlord warlord) {
        try {
            int i;
            OutputStream output = StreamUtil.getOutputStream(target, false);
            output.write(1);
            output.write(0);
            output.write(0);
            output.write(0);
            output.write(0);
            output.write(0);
            output.write(0);
            output.write(0);
            int index = target.lastIndexOf("Assets");
            String path = index >= 0 ? target.substring(index) : target;
            String name = warlord.getName();
            int hash = 0;
            for (i = 0; i < path.length(); ++i) {
                hash += path.charAt(i);
            }
            for (i = 0; i < name.length(); ++i) {
                hash += name.charAt(i);
            }
            output.write(hash >>> 0 & 0xFF);
            output.write(hash >>> 8 & 0xFF);
            output.write(hash >>> 16 & 0xFF);
            output.write(hash >>> 24 & 0xFF);
            WarlordOutputStream warStream = new WarlordOutputStream(output);
            WarlordFactory.writeWarlord(warStream, warlord);
            output.write(254);
            output.write(0);
            output.write(0);
            output.write(0);
            output.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static final boolean save(String target, Warlord warlord, boolean backup) {
        boolean ok = false;
        try {
            if (backup) {
                String backupName = Files.setExtension(target, "bak", true);
                File wFile = new File(target);
                File bakFile = new File(backupName);
                if (Files.exists(backupName) && bakFile.delete()) {
                    System.err.println("Backup file \"" + bakFile + "\" cannot be deleted!");
                }
                if (wFile.renameTo(bakFile)) {
                    System.err.println("Backup file \"" + wFile + "\" cannot be renamed!");
                }
            }
            WarlordOutputStream out = new WarlordOutputStream(target);
            WarlordFactory.writeWarlord(out, warlord);
            out.writeInteger(0);
            out.checksum();
            out.close();
            ok = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return ok;
    }

    private static final void writeWarlord(WarlordOutputStream out, Warlord warlord) throws IOException {
        int i;
        out.writeString(warlord.getName(), 31);
        out.writeString(warlord.getCapital(), 31);
        out.writeInteger(warlord.getAvatar());
        out.writeInteger(warlord.getMajorAbility());
        out.writeInteger(warlord.getMinorAbility());
        out.writeInteger(warlord.getRace());
        out.writeInteger(warlord.getBattles());
        out.writeInteger(warlord.getVictories());
        out.writeInteger(warlord.getLevel());
        out.writeInteger(warlord.getProvincesMask());
        out.writeInteger(warlord.getClassType());
        out.writeInteger(warlord.getExperience());
        for (i = 0; i < 17; ++i) {
            out.writeInteger(warlord.getSkillLevel(i));
        }
        for (i = 0; i < 23; ++i) {
            out.writeBoolean(warlord.isCityUpgraded(i));
        }
        for (i = 0; i < 72; ++i) {
            out.write(0);
        }
        for (i = 0; i < 32; ++i) {
            out.writeBoolean(warlord.isProvinceWon(i));
        }
        for (i = 0; i < 36; ++i) {
            out.write(0);
        }
        int cnt = 1;
        for (int i2 = 0; i2 < 3; ++i2) {
            WarlordFactory.writeUnit(out, warlord.getRetinue(i2), cnt++);
        }
        out.writeInteger(0);
        out.writeInteger(0);
    }

    public static final void writeUnit(WarlordOutputStream out, Unit unit, int index) throws IOException {
        if (unit == null) {
            for (int i = 0; i < 56; ++i) {
                out.write(0);
            }
        } else {
            out.write(unit.getRace());
            out.write(unit.getType());
            out.write(unit.getLife());
            out.write(unit.getCombat());
            out.write(unit.getUpgrade());
            out.write(index);
            out.write(unit.getUpkeep());
            Ability ability = unit.getMajorAbility();
            out.write(ability == null ? 0 : ability.getID());
            out.write(unit.getMajorLevel());
            ability = unit.getMinorAbility();
            out.write(ability == null ? 0 : ability.getID());
            out.write(unit.getMinorLevel());
            out.write(0);
            out.writeShort(unit.getExperience());
            out.writeShort(unit.getLevel());
            String name = unit.getName();
            if (name == null) {
                LabeledIcon unitType = UnitEditionPanel.getUnitName(unit.getRace(), unit.getType());
                name = unitType.getLabel();
                name = name.substring(0, name.indexOf(40)).trim();
            }
            out.writeString(name, 31);
            Item item = unit.getHeadItem();
            out.write(item == null ? 0 : item.getID());
            item = unit.getWeaponItem();
            out.write(item == null ? 0 : item.getID());
            item = unit.getArmorItem();
            out.write(item == null ? 0 : item.getID());
            item = unit.getAccessoryItem();
            out.write(item == null ? 0 : item.getID());
            out.writeInteger(unit.getID());
        }
    }
}

