/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.image;

import com.softlabs.warlords4.image.ImageFactory;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.swing.Icon;

public class ResourceIcon
implements Icon {
    private String path;
    Image image;
    private ImageObserver imageObserver;
    private String description;
    private int width = -1;
    private int height = -1;
    private boolean loaded;

    public ResourceIcon() {
        this(null);
    }

    public ResourceIcon(String path) {
        this(path, false);
    }

    public ResourceIcon(String path, boolean load) {
        this.path = path;
        if (load) {
            this.loadResource();
        }
    }

    public ImageObserver getImageObserver() {
        return this.imageObserver;
    }

    public String getDescription() {
        return this.description;
    }

    public Image getImage() {
        this.loadResource();
        return this.image;
    }

    public void setImageObserver(ImageObserver observer) {
        this.imageObserver = observer;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        if (this.description != null) {
            return this.description;
        }
        if (this.path != null) {
            return this.path;
        }
        return super.toString();
    }

    public void loadResource() {
        if (!this.loaded && this.image == null && this.path != null) {
            this.image = ImageFactory.getImage(this.path);
            if (this.image != null) {
                this.width = this.image.getWidth(this.imageObserver);
                this.height = this.image.getHeight(this.imageObserver);
            }
        }
        this.loaded = true;
    }

    public void flushResource() {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
            this.loaded = false;
        }
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        this.loadResource();
        if (this.image != null) {
            if (this.imageObserver == null) {
                g.drawImage(this.image, x, y, c);
            } else {
                g.drawImage(this.image, x, y, this.imageObserver);
            }
        }
    }

    @Override
    public int getIconWidth() {
        this.loadResource();
        return this.width;
    }

    @Override
    public int getIconHeight() {
        this.loadResource();
        return this.height;
    }
}

