/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.image;

import com.softlabs.warlords4.util.StreamUtil;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageFactory {
    private static final Container OBSERVER = new Container();
    private static final MediaTracker TRACKER = new MediaTracker(OBSERVER);
    private static Map<String, ImageIcon> imageCache = new Hashtable<String, ImageIcon>(8);
    private static boolean enableCaching;
    private static int mediaTrackerID;
    private static final String JPEG2000_EXT = "jpeg2000";
    private static final String JP2 = "jp2";
    private static List<String> SUPPORTED_EXTENSIONS;
    private static final Map<String, String> SUPPORTED_DESCRIPTIONS;

    private ImageFactory() {
    }

    public static void setCachingEnabled(boolean enableCaching) {
        ImageFactory.enableCaching = enableCaching;
    }

    public static boolean isCachingEnabled() {
        return enableCaching;
    }

    public static void clearCache() {
        imageCache.clear();
    }

    private static void cacheImage(String key, ImageIcon image) {
        if (ImageFactory.isCachingEnabled() && key != null) {
            imageCache.put(key, image);
        }
    }

    private static ImageIcon getCachedImage(String key) {
        if (!ImageFactory.isCachingEnabled() || key == null) {
            return null;
        }
        return imageCache.get(key);
    }

    public static BufferedImage getBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        if (image == null) {
            return null;
        }
        OBSERVER.prepareImage(image, null);
        int width = image.getWidth(OBSERVER);
        int height = image.getHeight(OBSERVER);
        BufferedImage bImage = new BufferedImage(width, height, 2);
        Graphics g = bImage.getGraphics();
        g.drawImage(image, 0, 0, OBSERVER);
        return bImage;
    }

    public static BufferedImage getBufferedImage(InputStream in) {
        return ImageFactory.getBufferedImage(null, in);
    }

    public static BufferedImage getBufferedImage(String path) {
        ImageIcon imageIcon = ImageFactory.getCachedImage(path);
        BufferedImage bImage = null;
        if (imageIcon == null) {
            try {
                InputStream in = StreamUtil.getInputStream(path);
                bImage = ImageFactory.getBufferedImage(path, in);
                in.close();
            }
            catch (Throwable throwable) {}
        } else {
            bImage = ImageFactory.getBufferedImage(imageIcon.getImage());
        }
        return bImage;
    }

    private static BufferedImage getBufferedImage(String key, InputStream in) {
        BufferedImage bImage = null;
        try {
            bImage = ImageIO.read(in);
            if (bImage != null) {
                ImageIcon imageIcon = new ImageIcon(bImage);
                imageIcon.setDescription(key);
                ImageFactory.cacheImage(key, imageIcon);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bImage;
    }

    private static ImageIcon getImageIcon(String key, InputStream in) {
        ImageIcon imageIcon = null;
        try {
            byte[] buffer = StreamUtil.toByteArray(in);
            imageIcon = new ImageIcon(buffer);
            if (imageIcon.getIconHeight() <= 0) {
                ByteArrayInputStream bin = new ByteArrayInputStream(buffer);
                BufferedImage image = ImageIO.read(bin);
                if (image != null) {
                    imageIcon.setImage(image);
                } else {
                    imageIcon = null;
                }
            }
            if (imageIcon != null) {
                imageIcon.setDescription(key);
                ImageFactory.cacheImage(key, imageIcon);
            }
        }
        catch (Throwable exception) {
            imageIcon = null;
        }
        return imageIcon;
    }

    public static Image getImage(InputStream in) {
        ImageIcon imageIcon = ImageFactory.getImageIcon(null, in);
        return imageIcon == null ? null : imageIcon.getImage();
    }

    public static Image getImage(String path) {
        ImageIcon imageIcon = ImageFactory.getCachedImage(path);
        if (imageIcon == null) {
            try {
                InputStream in = StreamUtil.getInputStream(path);
                imageIcon = ImageFactory.getImageIcon(path, in);
                in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return imageIcon == null ? null : imageIcon.getImage();
    }

    public static ImageIcon getIcon(InputStream in) {
        return ImageFactory.getImageIcon(null, in);
    }

    public static ImageIcon getIcon(String path) {
        ImageIcon icon = ImageFactory.getCachedImage(path);
        if (icon == null) {
            try {
                InputStream in = StreamUtil.getInputStream(path);
                icon = ImageFactory.getImageIcon(path, in);
                in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void loadImage(Image image) {
        MediaTracker mediaTracker = TRACKER;
        synchronized (mediaTracker) {
            image.getProperty("comment", OBSERVER);
            int id = ImageFactory.getNextID();
            TRACKER.addImage(image, id);
            try {
                TRACKER.waitForID(id, 0L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            TRACKER.removeImage(image, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNextID() {
        MediaTracker mediaTracker = TRACKER;
        synchronized (mediaTracker) {
            return ++mediaTrackerID;
        }
    }

    public static synchronized List<String> getSupportedFileExtensions(boolean force) {
        if (SUPPORTED_EXTENSIONS == null || force) {
            String[] extensions = ImageIO.getReaderFormatNames();
            TreeSet<String> list = new TreeSet<String>();
            for (int i = 0; i < extensions.length; ++i) {
                extensions[i] = extensions[i].toLowerCase(Locale.getDefault());
                String ext = null;
                if (extensions[i].length() <= 4) {
                    ext = extensions[i];
                } else if (extensions[i].equals(JPEG2000_EXT)) {
                    ext = JP2;
                }
                if (ext == null || list.contains(ext)) continue;
                list.add(ext);
            }
            int size = list.size();
            Iterator iterator = list.iterator();
            SUPPORTED_EXTENSIONS = new ArrayList<String>(size);
            while (iterator.hasNext()) {
                SUPPORTED_EXTENSIONS.add((String)iterator.next());
            }
        }
        return SUPPORTED_EXTENSIONS;
    }

    public static String getDescription(String extension) {
        return SUPPORTED_DESCRIPTIONS.get(extension);
    }

    static {
        SUPPORTED_EXTENSIONS = null;
        SUPPORTED_DESCRIPTIONS = new Hashtable<String, String>();
        SUPPORTED_DESCRIPTIONS.put("bmp", "Windows or OS/2 Bitmap");
        SUPPORTED_DESCRIPTIONS.put("gif", "CompuServe Graphics Interchange");
        SUPPORTED_DESCRIPTIONS.put("jfif", "JPEG File Interchange Format");
        SUPPORTED_DESCRIPTIONS.put(JP2, "JPEG 2000 Image");
        SUPPORTED_DESCRIPTIONS.put("jpeg", "Joint Photographic Expert Group Image");
        SUPPORTED_DESCRIPTIONS.put("jpg", "Joint Photographic Expert Group Image");
        SUPPORTED_DESCRIPTIONS.put("png", "Portable Network Graphics");
        SUPPORTED_DESCRIPTIONS.put("pnm", "Portable aNy Map Image");
        SUPPORTED_DESCRIPTIONS.put("raw", "Raw Image File");
        SUPPORTED_DESCRIPTIONS.put("tif", "Tagged Image File Format");
        SUPPORTED_DESCRIPTIONS.put("tiff", "Tagged Image File Format");
        SUPPORTED_DESCRIPTIONS.put("wbmp", "Wireless Bitmap Image");
    }
}

