/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.image;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;

public class IconMap {
    Image texture;
    private Map<Integer, Rectangle> map = new HashMap<Integer, Rectangle>(256);
    private int columns = -1;
    private int rows = -1;

    public IconMap() {
    }

    public IconMap(Image texture, Dimension size) {
        this();
        this.setTexture(texture);
        this.generateMap(size);
    }

    public Image getTexture() {
        return this.texture;
    }

    public Icon getIcon(int id) {
        TextureIcon icon = null;
        Rectangle clip = this.map.get(new Integer(id));
        if (clip != null) {
            icon = new TextureIcon(clip, this);
        }
        return icon;
    }

    public Icon getIcon(int column, int row) {
        int id = -1;
        if (this.columns > 0 && row < this.rows) {
            id = row * this.columns + column;
        }
        return this.getIcon(id);
    }

    public List<Icon> getIcons() {
        ArrayList<Icon> list = new ArrayList<Icon>(this.map.size());
        Iterator<Integer> keys = new TreeSet<Integer>(this.map.keySet()).iterator();
        while (keys.hasNext()) {
            list.add(this.getIcon(keys.next()));
        }
        return list;
    }

    public void setTexture(Image texture) {
        this.texture = texture;
    }

    public void addMap(int id, Rectangle clip) {
        if (clip != null) {
            this.map.put(new Integer(id), clip);
        } else {
            this.map.remove(new Integer(id));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Icon Map:\n");
        for (Integer key : new TreeSet<Integer>(this.map.keySet())) {
            buffer.append("\tIcon #").append(key).append('=').append(this.map.get(key)).append('\n');
        }
        return buffer.toString();
    }

    public void generateMap(Dimension size) {
        this.map.clear();
        Image texture = this.getTexture();
        if (texture != null) {
            int id = 0;
            int width = texture.getWidth(null);
            int height = texture.getHeight(null);
            this.columns = width / size.width;
            this.rows = height / size.height;
            for (int j = 0; j < height; j += size.height) {
                for (int i = 0; i < width; i += size.width) {
                    this.addMap(id++, new Rectangle(i, j, size.width, size.height));
                }
            }
        }
    }

    private static final class TextureIcon
    implements Icon {
        private final Rectangle clip;
        private final IconMap map;

        public TextureIcon(Rectangle clip, IconMap map) {
            this.clip = clip;
            this.map = map;
        }

        @Override
        public int getIconHeight() {
            return this.clip.height;
        }

        @Override
        public int getIconWidth() {
            return this.clip.width;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int x, int y) {
            Image texture = this.map.texture;
            if (texture != null) {
                Shape clipping = graphics.getClip();
                graphics.translate(x, y);
                graphics.setClip(new Rectangle(this.clip.width, this.clip.height));
                graphics.drawImage(texture, -this.clip.x, -this.clip.y, texture.getWidth(component), texture.getHeight(component), component);
                graphics.setClip(clipping);
                graphics.translate(-x, -y);
            }
        }
    }
}

