/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.image;

import com.softlabs.warlords4.image.ImageFactory;
import com.softlabs.warlords4.image.ResourceIcon;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import javax.swing.GrayFilter;

public class FilteredResourceIcon
extends ResourceIcon {
    public static final ImageFilter DEFAULT_FILTER = new GrayFilter(true, 50);
    private ImageFilter filter;

    public FilteredResourceIcon() {
        this(null, null);
    }

    public FilteredResourceIcon(String path) {
        this(path, null);
    }

    public FilteredResourceIcon(String path, ImageFilter filter) {
        super(path, false);
        this.setImageFilter(filter);
    }

    public ImageFilter getImageFilter() {
        return this.filter;
    }

    public void setImageFilter(ImageFilter filter) {
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadResource() {
        Image oldImage = this.image;
        super.loadResource();
        if (oldImage != this.image) {
            FilteredResourceIcon filteredResourceIcon = this;
            synchronized (filteredResourceIcon) {
                ImageFilter filter = this.getImageFilter();
                if (filter == null) {
                    filter = DEFAULT_FILTER;
                }
                FilteredImageSource producer = new FilteredImageSource(this.image.getSource(), filter);
                this.image = Toolkit.getDefaultToolkit().createImage(producer);
                ImageFactory.loadImage(this.image);
            }
        }
    }
}

