/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui.plaf;

import java.awt.Frame;
import java.awt.Window;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class LookAndFeelManager {
    public static final void initialize() {
        UIDefaults setup = UIManager.getDefaults();
        setup.put("swing.boldMetal", Boolean.FALSE);
        LookAndFeelManager.customize();
    }

    public static final void customize() {
    }

    public static final void setLookAndFeel(String laf, boolean pack) {
        if (laf != null) {
            try {
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                if (!lookAndFeel.getClass().getName().equals(laf)) {
                    UIManager.setLookAndFeel(laf);
                    LookAndFeelManager.customize();
                    LookAndFeelManager.updateLookAndFeel(pack);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void updateLookAndFeel(boolean pack) {
        Frame[] frames = Frame.getFrames();
        if (frames != null) {
            for (int i = 0; i < frames.length; ++i) {
                Window[] windows;
                SwingUtilities.updateComponentTreeUI(frames[i]);
                if (pack) {
                    frames[i].pack();
                }
                if ((windows = frames[i].getOwnedWindows()) == null) continue;
                for (int j = 0; j < windows.length; ++j) {
                    SwingUtilities.updateComponentTreeUI(windows[j]);
                    if (!pack) continue;
                    windows[j].pack();
                }
            }
        }
    }
}

