/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui.filechooser;

import com.softlabs.warlords4.util.Files;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public class StandardFileSystemView
extends FileSystemView {
    private static final FileSystemView SYSTEM_FSV = FileSystemView.getFileSystemView();
    private static final FileSystemView DEFAULT_FSV = new StandardFileSystemView();
    private Hashtable<Comparable<?>, Icon> icons = new Hashtable(1);
    private Hashtable<File, String> fileDescriptions = new Hashtable(1);
    private Hashtable<Comparable<?>, String> typeDescriptions = new Hashtable(1);
    private FileSystemView fsv;

    public StandardFileSystemView() {
        this(SYSTEM_FSV);
    }

    protected StandardFileSystemView(FileSystemView fsv) {
        this.fsv = fsv == null ? SYSTEM_FSV : fsv;
    }

    public void addDescription(File f, String fileDescription) {
        if (fileDescription != null) {
            this.fileDescriptions.put(f, fileDescription);
        }
    }

    public void removeDescription(File f) {
        this.fileDescriptions.remove(f);
    }

    public void addTypeDescription(String extension, String typeDescription) {
        if (typeDescription != null) {
            this.typeDescriptions.put((Comparable<?>)((Object)extension), typeDescription);
        }
    }

    public void addTypeDescription(File f, String typeDescription) {
        if (typeDescription != null) {
            this.typeDescriptions.put(f, typeDescription);
        }
    }

    public void removeTypeDescription(String extension) {
        this.typeDescriptions.remove(extension);
    }

    public void removeTypeDescription(File f) {
        this.typeDescriptions.remove(f);
    }

    public void addIcon(String extension, Icon icon) {
        if (icon != null) {
            this.icons.put((Comparable<?>)((Object)extension), icon);
        }
    }

    public void addIcon(File f, Icon icon) {
        if (icon != null) {
            this.icons.put(f, icon);
        }
    }

    public void removeIcon(String extension) {
        this.icons.remove(extension);
    }

    public void removeIcon(File f) {
        this.removeIcon(Files.getExtension(f));
    }

    public String getDescription(File file) {
        return this.fileDescriptions.get(file);
    }

    public static FileSystemView getFileSystemView() {
        return DEFAULT_FSV;
    }

    @Override
    public boolean isRoot(File file) {
        return this.fsv.isRoot(file);
    }

    @Override
    public Boolean isTraversable(File file) {
        return this.fsv.isTraversable(file);
    }

    @Override
    public String getSystemDisplayName(File file) {
        return this.fsv.getSystemDisplayName(file);
    }

    @Override
    public String getSystemTypeDescription(File file) {
        String ext;
        String type = this.typeDescriptions.get(file);
        if (type == null && (ext = Files.getExtension(file)) != null) {
            type = this.typeDescriptions.get(ext);
        }
        if (type == null) {
            type = this.fsv.getSystemTypeDescription(file);
        }
        return type;
    }

    @Override
    public Icon getSystemIcon(File file) {
        String ext;
        Icon ico = this.icons.get(file);
        if (ico == null && (ext = Files.getExtension(file)) != null) {
            ico = this.icons.get(ext);
        }
        if (ico == null) {
            ico = this.fsv.getSystemIcon(file);
        }
        return ico;
    }

    @Override
    public boolean isParent(File folder, File file) {
        return this.fsv.isParent(folder, file);
    }

    @Override
    public File getChild(File parent, String fileName) {
        return this.fsv.getChild(parent, fileName);
    }

    @Override
    public boolean isFileSystem(File file) {
        return this.fsv.isFileSystem(file);
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        return this.fsv.createNewFolder(containingDir);
    }

    @Override
    public boolean isHiddenFile(File file) {
        return this.fsv.isHiddenFile(file);
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        return this.fsv.isFileSystemRoot(dir);
    }

    @Override
    public boolean isDrive(File dir) {
        return this.fsv.isDrive(dir);
    }

    @Override
    public boolean isFloppyDrive(File dir) {
        return this.fsv.isFloppyDrive(dir);
    }

    @Override
    public boolean isComputerNode(File dir) {
        return this.fsv.isComputerNode(dir);
    }

    @Override
    public File[] getRoots() {
        return this.fsv.getRoots();
    }

    @Override
    public File getHomeDirectory() {
        return this.fsv.getHomeDirectory();
    }

    @Override
    public File getDefaultDirectory() {
        return this.fsv.getDefaultDirectory();
    }

    @Override
    public File createFileObject(File dir, String filename) {
        return this.fsv.createFileObject(dir, filename);
    }

    @Override
    public File createFileObject(String path) {
        return this.fsv.createFileObject(path);
    }

    @Override
    public File[] getFiles(File dir, boolean useFileHiding) {
        return this.fsv.getFiles(dir, useFileHiding);
    }

    @Override
    public File getParentDirectory(File dir) {
        return this.fsv.getParentDirectory(dir);
    }
}

