/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui.filechooser;

import com.softlabs.warlords4.util.Files;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class StandardFileFilter
extends FileFilter
implements Cloneable {
    private Hashtable<String, StandardFileFilter> filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public StandardFileFilter() {
    }

    public StandardFileFilter(String extension) {
        this();
        this.addExtension(extension);
    }

    public StandardFileFilter(String extension, String description) {
        this();
        this.addExtension(extension);
        this.setDescription(description);
    }

    public StandardFileFilter(String[] extensions, String description) {
        this();
        this.addExtensions(extensions);
        this.setDescription(description);
    }

    public StandardFileFilter(String[] extensions) {
        this();
        this.addExtensions(extensions);
    }

    public void addExtensions(Enumeration<?> extensions) {
        while (extensions.hasMoreElements()) {
            this.addExtension((String)extensions.nextElement());
        }
    }

    public void addExtension(String extension) {
        if (extension == null) {
            return;
        }
        int idx = extension.lastIndexOf(46);
        if (idx != -1) {
            extension = extension.substring(idx);
        }
        this.filters.put(extension.toLowerCase(Locale.getDefault()), this);
        this.fullDescription = null;
    }

    public void addExtensions(String[] extensions) {
        if (extensions == null) {
            return;
        }
        for (int i = 0; i < extensions.length; ++i) {
            this.addExtension(extensions[i]);
        }
    }

    public void removeExtension(String extension) {
        if (extension == null) {
            return;
        }
        int idx = extension.lastIndexOf(46);
        if (idx != -1) {
            extension = extension.substring(idx);
        }
        this.filters.remove(extension);
        this.fullDescription = null;
    }

    public void setDescription(String description) {
        if (description == null) {
            return;
        }
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean enable) {
        this.useExtensionsInDescription = enable;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            StringBuffer buffer = new StringBuffer();
            if (this.description == null || this.isExtensionListInDescription()) {
                if (this.description == null) {
                    buffer.append("(");
                } else {
                    buffer.append(this.description);
                    buffer.append(" (");
                }
                Enumeration<String> extensions = this.filters.keys();
                if (extensions != null) {
                    buffer.append("*.");
                    buffer.append(extensions.nextElement());
                    while (extensions.hasMoreElements()) {
                        buffer.append(", *.");
                        buffer.append(extensions.nextElement());
                    }
                }
                buffer.append(")");
            } else {
                buffer.append(this.description);
            }
            this.fullDescription = buffer.toString();
        }
        return this.fullDescription;
    }

    public Enumeration<String> getExtensions() {
        return this.filters.keys();
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public String toString() {
        String str = this.getDescription();
        if (str == null) {
            str = super.toString();
        }
        return str;
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = Files.getExtension(f);
            if (extension != null && this.filters.get(extension) != null) {
                return true;
            }
        }
        return false;
    }
}

