/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.data.Ability;
import com.softlabs.warlords4.data.CityNameGenerator;
import com.softlabs.warlords4.data.LabeledIcon;
import com.softlabs.warlords4.data.LimitedPlainDocument;
import com.softlabs.warlords4.data.Unit;
import com.softlabs.warlords4.data.UnitNameGenerator;
import com.softlabs.warlords4.data.Warlord;
import com.softlabs.warlords4.event.ChangeTrackerAdapter;
import com.softlabs.warlords4.gui.CityUpgradesPanel;
import com.softlabs.warlords4.gui.Filler;
import com.softlabs.warlords4.gui.GenericListCellRenderer;
import com.softlabs.warlords4.gui.ProvincesPanel;
import com.softlabs.warlords4.gui.SequenceButtonPanel;
import com.softlabs.warlords4.gui.SkillsPanel;
import com.softlabs.warlords4.gui.UnitEditionPanel;
import com.softlabs.warlords4.gui.UnitWizardDialog;
import com.softlabs.warlords4.gui.WarlordEditionPanel;
import com.softlabs.warlords4.gui.WizardTitle;
import com.softlabs.warlords4.image.ResourceIcon;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WarlordWizardPanel
extends JPanel
implements ActionListener,
DocumentListener {
    public static final String TITLE = "Warlord Creation Wizard";
    private static final String MAIN_PANEL = "Main";
    private static final String SKILLS_PANEL = "Skills";
    private static final String RETINUES_PANEL = "Retinues";
    private static final String[] LEVEL_XP_LABELS = new String[]{"Level:", "Experience:"};
    static final int[][] CLASS_ABILITIES = new int[][]{{0, 0}, {0, 1}, {0, 2}, {0, 3}, {0, 4}, {0, 5}, {1, 0}, {1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {2, 5}, {3, 0}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {3, 5}, {4, 0}, {4, 1}, {4, 2}, {4, 3}, {4, 4}, {4, 5}, {5, 0}, {5, 1}, {5, 2}, {5, 3}, {5, 4}, {5, 5}};
    private SequenceButtonPanel buttons;
    private CardLayout cardLayout;
    private String cardState = "Main";
    private JPanel editor;
    private transient Warlord warlord;
    JTextField name;
    JTextField capital;
    private JComboBox avatar;
    JComboBox race;
    private int battles;
    private int victories;
    JComboBox classType;
    JComboBox targetType;
    JSpinner levelAndXP;
    SpinnerNumberModel levelAndXPModel;
    JLabel majorSkill;
    JLabel minorSkill;
    JLabel majorAbility;
    JLabel minorAbility;
    SkillsPanel skills;
    private CityUpgradesPanel cityUpgrades;
    private ProvincesPanel provinces;
    private JLabel remainingLabel;
    private JLabel remaining;
    transient Unit[] retinues = new Unit[3];
    JCheckBox[] retinuesCheck;
    private JButton[] retinuesButton;
    UnitWizardDialog unitWizardDialog;

    public WarlordWizardPanel() {
        this.setName("Usage");
        WizardTitle header = new WizardTitle(TITLE, "com/softlabs/warlords4/rsc/warlordWizard.png");
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.bottom = 5;
        this.cardLayout = new CardLayout();
        this.editor = new JPanel(this.cardLayout);
        JPanel warlordMain = new JPanel(new GridBagLayout());
        warlordMain.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.editor.add((Component)warlordMain, MAIN_PANEL);
        JPanel generalPanel = new JPanel(new GridBagLayout());
        generalPanel.setBorder(BorderFactory.createTitledBorder("General"));
        generalPanel.setName("WCharacter");
        warlordMain.add((Component)generalPanel, gbConstraints);
        this.avatar = new JComboBox<ResourceIcon>(WarlordEditionPanel.AVATARS_ICONS);
        this.avatar.setToolTipText("Avatar: Select any Image.");
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 2;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        generalPanel.add((Component)this.avatar, gbConstraints);
        gbConstraints.gridheight = 1;
        gbConstraints.weighty = 1.0;
        JLabel nameLabel = new JLabel("Name:");
        nameLabel.setToolTipText("Name: Maximum 31 characters.");
        nameLabel.setDisplayedMnemonic('N');
        ++gbConstraints.gridx;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 0;
        generalPanel.add((Component)nameLabel, gbConstraints);
        this.name = new JTextField(31);
        this.name.setDocument(new LimitedPlainDocument(31, false, null));
        this.name.setToolTipText(nameLabel.getToolTipText());
        this.name.getDocument().addDocumentListener(this);
        nameLabel.setLabelFor(this.name);
        ++gbConstraints.gridx;
        gbConstraints.insets.right = 11;
        gbConstraints.weightx = 1.0;
        generalPanel.add((Component)this.name, gbConstraints);
        JButton generateName = new JButton("Generate");
        generateName.addActionListener(new GenerateWarlordNameAction(this));
        generateName.setToolTipText("Generate a warlord name.");
        ++gbConstraints.gridx;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.right = 5;
        generalPanel.add((Component)generateName, gbConstraints);
        gbConstraints.insets.top = 6;
        JLabel capitalLabel = new JLabel("Capital:");
        capitalLabel.setToolTipText("Capital: Maximum 31 characters.");
        capitalLabel.setDisplayedMnemonic('a');
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 1;
        gbConstraints.insets.right = 11;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        generalPanel.add((Component)capitalLabel, gbConstraints);
        this.capital = new JTextField(31);
        this.capital.setDocument(new LimitedPlainDocument(31, false, null));
        this.capital.setToolTipText(capitalLabel.getToolTipText());
        this.capital.getDocument().addDocumentListener(this);
        capitalLabel.setLabelFor(this.capital);
        ++gbConstraints.gridx;
        gbConstraints.weightx = 1.0;
        gbConstraints.insets.right = 11;
        generalPanel.add((Component)this.capital, gbConstraints);
        JButton generateCity = new JButton("Generate");
        generateCity.addActionListener(new GenerateCapitalNameAction(this));
        generateCity.setToolTipText("Generate a city name.");
        ++gbConstraints.gridx;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 5;
        gbConstraints.gridwidth = 0;
        generalPanel.add((Component)generateCity, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.gridx = -1;
        gbConstraints.gridy = -1;
        gbConstraints.weighty = 0.0;
        gbConstraints.insets.top = 5;
        JLabel raceLabel = new JLabel("Favored Race:");
        raceLabel.setToolTipText("Favored Race: Hirelings will be most probably from this race.");
        raceLabel.setDisplayedMnemonic('F');
        raceLabel.setName("WStatistics");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        generalPanel.add((Component)raceLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.race = new JComboBox<Object>(UnitEditionPanel.RACE_NAMES.toArray());
        this.race.setRenderer(new GenericListCellRenderer());
        this.race.setToolTipText(raceLabel.getToolTipText());
        this.race.setName("WStatistics");
        raceLabel.setLabelFor(this.race);
        gbConstraints.insets.right = 5;
        generalPanel.add((Component)this.race, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.insets.top = 0;
        gbConstraints.insets.bottom = 5;
        this.targetType = new JComboBox<String>(LEVEL_XP_LABELS);
        this.targetType.setName("WStatistics");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        generalPanel.add((Component)this.targetType, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.levelAndXPModel = new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1);
        this.levelAndXP = new JSpinner(this.levelAndXPModel);
        this.levelAndXP.setName("WStatistics");
        gbConstraints.insets.right = 5;
        generalPanel.add((Component)this.levelAndXP, gbConstraints);
        gbConstraints.insets.right = 0;
        ActionListener targetTypeChange = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int curValue = 1;
                try {
                    Object object = WarlordWizardPanel.this.levelAndXP.getValue();
                    curValue = object instanceof Number ? ((Number)object).intValue() : Integer.parseInt(object.toString());
                }
                catch (Throwable exception) {
                    // empty catch block
                }
                int target = WarlordWizardPanel.this.targetType.getSelectedIndex();
                if (target == 0) {
                    curValue /= 10;
                    ++curValue;
                    WarlordWizardPanel.this.levelAndXPModel.setMinimum(new Integer(1));
                } else {
                    curValue = (curValue - 1) * 10;
                    WarlordWizardPanel.this.levelAndXPModel.setMinimum(new Integer(0));
                }
                WarlordWizardPanel.this.levelAndXP.setValue(new Integer(curValue));
            }
        };
        this.targetType.addActionListener(targetTypeChange);
        JPanel classPanel = new JPanel(new GridBagLayout());
        classPanel.setBorder(BorderFactory.createTitledBorder("Class"));
        classPanel.setName("WCharacter");
        warlordMain.add((Component)classPanel, gbConstraints);
        JLabel classTypeLabel = new JLabel("Type:");
        classTypeLabel.setToolTipText("Class: Get help to cross-check with the abilities.");
        classTypeLabel.setDisplayedMnemonic('T');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        classPanel.add((Component)classTypeLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.classType = new JComboBox<Object>(WarlordEditionPanel.CLASS_NAMES.toArray());
        this.classType.setRenderer(new GenericListCellRenderer());
        this.classType.setToolTipText(classTypeLabel.getToolTipText());
        classTypeLabel.setLabelFor(this.classType);
        gbConstraints.insets.right = 5;
        classPanel.add((Component)this.classType, gbConstraints);
        gbConstraints.insets.right = 0;
        ActionListener classTypeChange = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int classType = WarlordWizardPanel.this.classType.getSelectedIndex();
                WarlordWizardPanel.this.majorAbility.setText(WarlordEditionPanel.ABILITY_NAMES.get(CLASS_ABILITIES[classType][0]).getLabel());
                WarlordWizardPanel.this.majorAbility.setIcon(WarlordEditionPanel.ABILITY_NAMES.get(CLASS_ABILITIES[classType][0]).getIcon());
                WarlordWizardPanel.this.minorAbility.setText(WarlordEditionPanel.ABILITY_NAMES.get(CLASS_ABILITIES[classType][1]).getLabel());
                WarlordWizardPanel.this.minorAbility.setIcon(WarlordEditionPanel.ABILITY_NAMES.get(CLASS_ABILITIES[classType][1]).getIcon());
                WarlordWizardPanel.this.skills.setClassType(classType);
                WarlordWizardPanel.this.setLabels();
                Ability ability = Ability.createAbility(WarlordEditionPanel.UNIT_SKILLS[classType][0]);
                WarlordWizardPanel.this.majorSkill.setText(ability.getLabel());
                WarlordWizardPanel.this.majorSkill.setIcon(ability.getIcon());
                WarlordWizardPanel.this.majorSkill.setToolTipText(ability.getDescription());
                ability = Ability.createAbility(WarlordEditionPanel.UNIT_SKILLS[classType][1]);
                WarlordWizardPanel.this.minorSkill.setText(ability.getLabel());
                WarlordWizardPanel.this.minorSkill.setIcon(ability.getIcon());
                WarlordWizardPanel.this.minorSkill.setToolTipText(ability.getDescription());
            }
        };
        this.classType.addActionListener(classTypeChange);
        JLabel majorAbilityLabel = new JLabel("Major:");
        majorAbilityLabel.setToolTipText("Major Ability: Get help to cross-check with the class.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        classPanel.add((Component)majorAbilityLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        LabeledIcon ability = WarlordEditionPanel.ABILITY_NAMES.get(CLASS_ABILITIES[0][0]);
        this.majorAbility = new JLabel(ability.getLabel(), ability.getIcon(), 10);
        this.majorAbility.setToolTipText(majorAbilityLabel.getToolTipText());
        this.majorAbility.setBorder(BorderFactory.createTitledBorder((String)null));
        majorAbilityLabel.setLabelFor(this.majorAbility);
        classPanel.add((Component)this.majorAbility, gbConstraints);
        JLabel minorAbilityLabel = new JLabel("Minor:");
        minorAbilityLabel.setToolTipText("Minor Ability: Get help to cross-check with the class.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        classPanel.add((Component)minorAbilityLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        ability = WarlordEditionPanel.ABILITY_NAMES.get(CLASS_ABILITIES[0][1]);
        this.minorAbility = new JLabel(ability.getLabel(), ability.getIcon(), 10);
        this.minorAbility.setToolTipText(minorAbilityLabel.getToolTipText());
        this.minorAbility.setBorder(BorderFactory.createTitledBorder((String)null));
        minorAbilityLabel.setLabelFor(this.minorAbility);
        gbConstraints.insets.right = 5;
        classPanel.add((Component)this.minorAbility, gbConstraints);
        gbConstraints.insets.right = 0;
        Dimension maxSize = this.majorAbility.getPreferredSize();
        this.majorAbility.setPreferredSize(maxSize);
        this.minorAbility.setPreferredSize(maxSize);
        JPanel skillsPanel = new JPanel(new GridBagLayout());
        skillsPanel.setBorder(BorderFactory.createTitledBorder(SKILLS_PANEL));
        skillsPanel.setName("WCharacter");
        warlordMain.add((Component)skillsPanel, gbConstraints);
        JLabel majorSkillLabel = new JLabel("Major:");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        skillsPanel.add((Component)majorSkillLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        Ability skill = Ability.createAbility(WarlordEditionPanel.UNIT_SKILLS[0][0]);
        this.majorSkill = new JLabel(skill.getLabel(), skill.getIcon(), 10);
        this.majorSkill.setToolTipText(skill.getDescription());
        this.majorSkill.setBorder(BorderFactory.createTitledBorder((String)null));
        majorSkillLabel.setLabelFor(this.majorSkill);
        skillsPanel.add((Component)this.majorSkill, gbConstraints);
        JLabel minorSkillLabel = new JLabel("Minor:");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        skillsPanel.add((Component)minorSkillLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        skill = Ability.createAbility(WarlordEditionPanel.UNIT_SKILLS[0][1]);
        this.minorSkill = new JLabel(skill.getLabel(), skill.getIcon(), 10);
        this.minorSkill.setToolTipText(skill.getDescription());
        this.minorSkill.setBorder(BorderFactory.createTitledBorder((String)null));
        minorSkillLabel.setLabelFor(this.minorSkill);
        gbConstraints.insets.right = 5;
        skillsPanel.add((Component)this.minorSkill, gbConstraints);
        gbConstraints.insets.right = 0;
        maxSize = this.majorAbility.getPreferredSize();
        this.majorSkill.setPreferredSize(maxSize);
        this.minorSkill.setPreferredSize(maxSize);
        gbConstraints.weighty = 1.0;
        warlordMain.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        JPanel warlordSkills = new JPanel(new GridBagLayout());
        this.editor.add((Component)warlordSkills, SKILLS_PANEL);
        JTabbedPane pane = new JTabbedPane();
        pane.setTabLayoutPolicy(1);
        gbConstraints.weighty = 1.0;
        warlordSkills.add((Component)pane, gbConstraints);
        gbConstraints.weighty = 0.0;
        this.skills = new SkillsPanel();
        this.skills.setLimited(true);
        pane.addTab(SKILLS_PANEL, WarlordEditionPanel.ICON_SKILLS, this.skills);
        this.cityUpgrades = new CityUpgradesPanel();
        this.cityUpgrades.setLimited(true);
        pane.addTab("City Upgrades", WarlordEditionPanel.ICON_CITY_UPGRADES, this.cityUpgrades);
        this.provinces = new ProvincesPanel();
        pane.addTab("Provinces", WarlordEditionPanel.ICON_PROVINCES, this.provinces);
        this.remainingLabel = new JLabel("Remaining development points:");
        this.remainingLabel.setToolTipText("To go to the next stage you must have a positive amount!");
        gbConstraints.gridwidth = 1;
        gbConstraints.insets.right = 11;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.left = 5;
        warlordSkills.add((Component)this.remainingLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        this.remaining = new JLabel();
        this.remaining.setToolTipText(this.remainingLabel.getToolTipText());
        this.remaining.setHorizontalAlignment(2);
        gbConstraints.weightx = 1.0;
        gbConstraints.insets.right = 5;
        warlordSkills.add((Component)this.remaining, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 0;
        Font baseFont = UIManager.getFont("Label.font").deriveFont(1);
        this.remainingLabel.setFont(baseFont);
        this.remaining.setFont(baseFont);
        JButton adjust = new JButton("Adjust");
        adjust.setToolTipText("Adjust the Warlords' level to the necessary development points.");
        adjust.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                WarlordWizardPanel.this.adjustLevel();
            }
        });
        gbConstraints.insets.right = 3;
        warlordSkills.add((Component)adjust, gbConstraints);
        gbConstraints.insets.right = 0;
        ChangeTrackerAdapter changeTracker = new ChangeTrackerAdapter(){

            @Override
            public void stateChanged(ChangeEvent event) {
                WarlordWizardPanel.this.setDevelopmentPoints();
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                WarlordWizardPanel.this.setDevelopmentPoints();
            }
        };
        this.skills.addChangeTracker(changeTracker);
        this.cityUpgrades.addChangeTracker(changeTracker);
        JPanel warlordRetinues = new JPanel(new GridBagLayout());
        warlordRetinues.setName(RETINUES_PANEL);
        this.editor.add((Component)warlordRetinues, RETINUES_PANEL);
        ActionListener retinuesAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getSource() instanceof JCheckBox) {
                    WarlordWizardPanel.this.setRetinues();
                } else if (event.getSource() instanceof JButton) {
                    try {
                        int index = Integer.parseInt(event.getActionCommand());
                        if (WarlordWizardPanel.this.unitWizardDialog == null) {
                            Window owner = SwingUtilities.getWindowAncestor(WarlordWizardPanel.this);
                            WarlordWizardPanel.this.unitWizardDialog = owner instanceof JFrame ? new UnitWizardDialog((JFrame)owner) : new UnitWizardDialog((JDialog)owner);
                        }
                        WarlordWizardPanel.this.unitWizardDialog.loadUnit(WarlordWizardPanel.this.retinues[index]);
                        WarlordWizardPanel.this.unitWizardDialog.setVisible(true);
                        Unit unit = WarlordWizardPanel.this.unitWizardDialog.getUnit();
                        if (unit != null) {
                            WarlordWizardPanel.this.retinues[index] = unit;
                            WarlordWizardPanel.this.retinuesCheck[index].setText(UnitEditionPanel.getUnitLabel(unit));
                        }
                        WarlordWizardPanel.this.setRetinues();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
        this.retinuesCheck = new JCheckBox[3];
        this.retinuesButton = new JButton[3];
        for (int i = 0; i < 3; ++i) {
            this.retinuesCheck[i] = new JCheckBox();
            this.retinuesCheck[i].addActionListener(retinuesAction);
            this.retinuesCheck[i].setActionCommand(Integer.toString(i));
            this.retinuesCheck[i].setToolTipText("Retinue #" + (i + 1) + ": Will help you in your conquest of the Etheria.");
            this.retinuesCheck[i].setMnemonic(Integer.toString(i + 1).charAt(0));
            gbConstraints.gridwidth = 1;
            gbConstraints.insets.top = i == 0 ? 5 : 0;
            warlordRetinues.add((Component)this.retinuesCheck[i], gbConstraints);
            gbConstraints.gridwidth = 0;
            this.retinuesButton[i] = new JButton();
            this.retinuesButton[i].addActionListener(retinuesAction);
            this.retinuesButton[i].setActionCommand(Integer.toString(i));
            this.retinuesButton[i].setEnabled(false);
            gbConstraints.weightx = 0.0;
            warlordRetinues.add((Component)this.retinuesButton[i], gbConstraints);
            gbConstraints.weightx = 1.0;
        }
        this.setRetinues();
        gbConstraints.weighty = 1.0;
        warlordRetinues.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        JPanel footer = new JPanel(new BorderLayout());
        footer.add((Component)new JSeparator(), "North");
        this.buttons = new SequenceButtonPanel();
        this.buttons.setBackEnabled(false);
        this.buttons.addActionListener(this);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        footer.add((Component)this.buttons, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)header, "North");
        this.add((Component)this.editor, "Center");
        this.add((Component)footer, "South");
        this.buttons.installDefaultButton();
        this.setLabels();
    }

    private int getDevelopementPoints() {
        int target = this.targetType.getSelectedIndex();
        int curValue = 1;
        try {
            Object object = this.levelAndXP.getValue();
            curValue = object instanceof Number ? ((Number)object).intValue() : Integer.parseInt(object.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (target == 1) {
            curValue /= 10;
            ++curValue;
        }
        return curValue;
    }

    public Warlord getWarlord() {
        return this.warlord;
    }

    void setLabels() {
        int classType = this.classType.getSelectedIndex();
        this.cityUpgrades.setLabels(CLASS_ABILITIES[classType][0]);
    }

    void setDevelopmentPoints() {
        int skillsCount = this.skills.getDevelopmentPoints();
        int cityUpgradesCount = this.cityUpgrades.getDevelopmentPoints();
        int devPoints = this.getDevelopementPoints() - 1;
        int rest = devPoints - skillsCount - cityUpgradesCount;
        this.remaining.setText(Integer.toString(rest));
        if (rest == 0) {
            this.remaining.setForeground(Color.BLUE);
        } else if (rest > 0) {
            this.remaining.setForeground(Color.GREEN);
        } else {
            this.remaining.setForeground(Color.RED);
        }
        this.stateChanged();
    }

    void setRetinues() {
        for (int i = 0; i < 3; ++i) {
            this.retinuesButton[i].setEnabled(this.retinuesCheck[i].isSelected());
            if (i > 0) {
                this.retinuesCheck[i].setEnabled(this.retinuesCheck[i - 1].isSelected() && this.retinues[i - 1] != null);
                this.retinuesCheck[i].setSelected(this.retinuesCheck[i].isEnabled() && this.retinuesCheck[i].isSelected());
                this.retinuesButton[i].setEnabled(this.retinuesCheck[i].isSelected());
            }
            if (this.retinues[i] == null) {
                this.retinuesCheck[i].setText("Retinue #" + (i + 1));
                this.retinuesButton[i].setText("Create");
                this.retinuesButton[i].setToolTipText("Create a new Retinue.");
                continue;
            }
            this.retinuesButton[i].setText("Edit");
            this.retinuesButton[i].setToolTipText("Edit the Retinue.");
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.isVisible()) {
            this.warlord = null;
            this.cardState = MAIN_PANEL;
            this.cardLayout.show(this.editor, this.cardState);
            this.stateChanged();
        }
        super.setVisible(visible);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.remainingLabel != null) {
            Font baseFont = UIManager.getFont("Label.font");
            baseFont = baseFont.deriveFont(1);
            this.remainingLabel.setFont(baseFont);
            this.remaining.setFont(baseFont);
        }
    }

    private void close() {
        Window root = SwingUtilities.getWindowAncestor(this);
        if (root != null) {
            root.setVisible(false);
        }
    }

    public void reset() {
        this.warlord = null;
        this.cardState = MAIN_PANEL;
        this.cardLayout.show(this.editor, this.cardState);
        this.stateChanged();
    }

    void adjustLevel() {
        int skillsCount = this.skills.getDevelopmentPoints();
        int cityUpgradesCount = this.cityUpgrades.getDevelopmentPoints();
        int devPointsNeeded = skillsCount + cityUpgradesCount + 1;
        this.targetType.setSelectedItem(LEVEL_XP_LABELS[0]);
        this.levelAndXP.setValue(new Integer(devPointsNeeded));
        this.setDevelopmentPoints();
    }

    private void stateChanged() {
        if (this.cardState.equals(MAIN_PANEL)) {
            this.buttons.setBackEnabled(false);
            this.buttons.setNextEnabled(this.name.getText().length() > 0 && this.capital.getText().length() > 0);
            this.buttons.setCustomizeNextButton(null, null, -1);
        } else if (this.cardState.equals(SKILLS_PANEL)) {
            this.buttons.setBackEnabled(true);
            int remainder = Integer.parseInt(this.remaining.getText());
            this.buttons.setNextEnabled(remainder >= 0);
            this.buttons.setCustomizeNextButton(null, null, -1);
            this.skills.setHighLevel(this.cityUpgrades.areAllUpgradesSelected());
        } else if (this.cardState.equals(RETINUES_PANEL)) {
            this.buttons.setBackEnabled(true);
            this.buttons.setCustomizeNextButton("Finish", "Finish and Return to editor", 70);
        }
    }

    private void buildWarlord() {
        int i;
        int experience;
        int level;
        Warlord warlord = new Warlord();
        warlord.setName(this.name.getText());
        warlord.setCapital(this.capital.getText());
        warlord.setAvatar(this.avatar.getSelectedIndex());
        int classType = this.classType.getSelectedIndex();
        warlord.setClassType(classType);
        warlord.setMajorAbility(CLASS_ABILITIES[classType][0]);
        warlord.setMinorAbility(CLASS_ABILITIES[classType][1]);
        warlord.setRace(this.race.getSelectedIndex());
        int curValue = 1;
        try {
            Object object = this.levelAndXP.getValue();
            curValue = object instanceof Number ? ((Number)object).intValue() : Integer.parseInt(object.toString());
        }
        catch (Throwable exception) {
            // empty catch block
        }
        if (this.targetType.getSelectedIndex() == 0) {
            level = curValue;
            experience = (curValue - 1) * 10;
        } else {
            level = curValue / 10 + 1;
            experience = curValue;
        }
        warlord.setExperience(experience);
        warlord.setLevel(level);
        warlord.setBattles(this.battles);
        warlord.setVictories(this.victories);
        for (i = 0; i < 17; ++i) {
            warlord.setSkillLevel(i, this.skills.getSkillLevel(i));
        }
        for (i = 0; i < 23; ++i) {
            warlord.setCityUpgraded(i, this.cityUpgrades.isSelected(i));
        }
        for (i = 0; i < 32; ++i) {
            warlord.setProvinceWon(i, this.provinces.isSelected(i));
        }
        for (i = 0; i < 3; ++i) {
            if (this.retinues[i] == null) continue;
            warlord.setRetinue(i, this.retinues[i]);
        }
        this.warlord = warlord;
    }

    public void loadWarlord(Warlord warlord) {
        if (warlord != null) {
            int i;
            this.name.setText(warlord.getName());
            this.capital.setText(warlord.getCapital());
            this.avatar.setSelectedIndex(warlord.getAvatar());
            int classType = warlord.getClassType();
            this.classType.setSelectedIndex(classType);
            this.battles = warlord.getBattles();
            this.victories = warlord.getVictories();
            this.race.setSelectedIndex(warlord.getRace());
            int level = warlord.getLevel();
            int experience = warlord.getExperience();
            if (experience > (level - 1) * 10) {
                this.targetType.setSelectedIndex(1);
                this.levelAndXP.setValue(new Integer(experience));
            } else {
                this.targetType.setSelectedIndex(0);
                this.levelAndXP.setValue(new Integer(level));
            }
            for (i = 0; i < 17; ++i) {
                this.skills.setSkillLevel(i, warlord.getSkillLevel(i));
            }
            this.skills.ensureLimited();
            for (i = 0; i < 23; ++i) {
                this.cityUpgrades.setSelected(i, warlord.isCityUpgraded(i));
            }
            this.cityUpgrades.setState();
            for (i = 0; i < 32; ++i) {
                this.provinces.setSelected(i, warlord.isProvinceWon(i));
            }
            this.provinces.setState();
            for (i = 0; i < 3; ++i) {
                this.retinues[i] = warlord.getRetinue(i);
                this.retinuesCheck[i].setSelected(this.retinues[i] != null);
                this.retinuesCheck[i].setText(UnitEditionPanel.getUnitLabel(this.retinues[i]));
            }
            this.setRetinues();
        } else {
            this.battles = 0;
            this.victories = 0;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("SB@Cancel".equals(command)) {
            this.close();
        } else if ("SB@Back".equals(command)) {
            if (this.buttons.isBackEnabled()) {
                if (this.cardState.equals(SKILLS_PANEL)) {
                    this.cardState = MAIN_PANEL;
                } else if (this.cardState.equals(RETINUES_PANEL)) {
                    this.cardState = SKILLS_PANEL;
                }
            }
            this.cardLayout.show(this.editor, this.cardState);
        } else if ("SB@Next".equals(command)) {
            if (this.buttons.isNextEnabled()) {
                if (this.cardState.equals(MAIN_PANEL)) {
                    this.cardState = SKILLS_PANEL;
                } else if (this.cardState.equals(SKILLS_PANEL)) {
                    this.cardState = RETINUES_PANEL;
                } else if (this.cardState.equals(RETINUES_PANEL)) {
                    this.buildWarlord();
                    this.close();
                }
            }
            this.cardLayout.show(this.editor, this.cardState);
        }
        this.setDevelopmentPoints();
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.stateChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.stateChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.stateChanged();
    }

    private static final class GenerateCapitalNameAction
    implements ActionListener {
        private final WarlordWizardPanel panel;

        public GenerateCapitalNameAction(WarlordWizardPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int race = this.panel.race.getSelectedIndex();
            String name = CityNameGenerator.generateName(race);
            this.panel.capital.setText(name);
        }
    }

    private static final class GenerateWarlordNameAction
    implements ActionListener {
        private final WarlordWizardPanel panel;

        public GenerateWarlordNameAction(WarlordWizardPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int race = this.panel.race.getSelectedIndex();
            String name = UnitNameGenerator.generateName(race);
            this.panel.name.setText(name);
        }
    }
}

