/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.data.Ability;
import com.softlabs.warlords4.data.ApplicationPreferences;
import com.softlabs.warlords4.data.CityNameGenerator;
import com.softlabs.warlords4.data.LabeledIcon;
import com.softlabs.warlords4.data.LimitedPlainDocument;
import com.softlabs.warlords4.data.Unit;
import com.softlabs.warlords4.data.UnitNameGenerator;
import com.softlabs.warlords4.data.Warlord;
import com.softlabs.warlords4.event.ChangeTracker;
import com.softlabs.warlords4.gui.CityUpgradesPanel;
import com.softlabs.warlords4.gui.FileChooserDialog;
import com.softlabs.warlords4.gui.Filler;
import com.softlabs.warlords4.gui.GenericListCellRenderer;
import com.softlabs.warlords4.gui.ProvincesPanel;
import com.softlabs.warlords4.gui.SkillsPanel;
import com.softlabs.warlords4.gui.UnitEditionDialog;
import com.softlabs.warlords4.gui.UnitEditionPanel;
import com.softlabs.warlords4.gui.UnitWizardDialog;
import com.softlabs.warlords4.gui.WarlordWizardPanel;
import com.softlabs.warlords4.image.ResourceIcon;
import com.softlabs.warlords4.io.WarlordFactory;
import com.softlabs.warlords4.io.WarlordInputStream;
import com.softlabs.warlords4.io.WarlordOutputStream;
import com.softlabs.warlords4.util.Files;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class WarlordEditionPanel
extends JPanel {
    public static final List<LabeledIcon> CLASS_NAMES = new ArrayList<LabeledIcon>(38);
    static final List<LabeledIcon> ABILITY_NAMES;
    private static final int AVATARS_ICON_COUNT = 33;
    public static final Vector<ResourceIcon> AVATARS_ICONS;
    private static final Icon ICON_CHARACTER;
    private static final Icon ICON_STATISTICS;
    public static final Icon ICON_SKILLS;
    public static final Icon ICON_CITY_UPGRADES;
    public static final Icon ICON_PROVINCES;
    private static final Icon ICON_RETINUES;
    static final int[][] UNIT_SKILLS;
    private static final String RETINUES_FOLDER = "Retinues";
    private static final String ACTION_MAJOR_ABILITY = "ACT:MA";
    private static final String ACTION_CLASS_TYPE = "ACT:CT";
    JTextField name;
    JTextField capital;
    private JComboBox avatar;
    JComboBox classType;
    JComboBox majorAbility;
    JComboBox minorAbility;
    JComboBox race;
    private JSpinner battles;
    private JSpinner victories;
    private JSpinner experience;
    private JSpinner level;
    JLabel majorSkill;
    JLabel minorSkill;
    SkillsPanel skills;
    private CityUpgradesPanel cityUpgrades;
    UnitEditionDialog retinueDialog;
    private ProvincesPanel provinces;
    JCheckBox[] retinuesCheck;
    private JButton[] retinuesEditButton;
    private JButton[] retinuesExportButton;
    private JButton[] retinuesImportButton;
    private JButton[] retinuesWizardButton;
    transient Unit[] retinues;
    String[] retinuesPath;
    UnitWizardDialog unitWizardDialog;
    private transient Warlord warlord;
    FileChooserDialog chooser = FileChooserDialog.DEFAULT_CHOOSER;
    ChangeTracker tracker;

    public WarlordEditionPanel() {
        super(new BorderLayout());
        this.setName("Usage");
        UIHandler uiHandler = new UIHandler(this);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.bottom = 5;
        JTabbedPane pane = new JTabbedPane();
        pane.setTabLayoutPolicy(1);
        this.add((Component)pane, "Center");
        JPanel character = new JPanel(new GridBagLayout());
        character.setName("WCharacter");
        pane.addTab("Character", ICON_CHARACTER, character);
        JPanel characterGeneral = new JPanel(new GridBagLayout());
        characterGeneral.setBorder(BorderFactory.createTitledBorder("General"));
        character.add((Component)characterGeneral, gbConstraints);
        this.avatar = new JComboBox<ResourceIcon>(AVATARS_ICONS);
        this.avatar.setToolTipText("Avatar: Select any Image.");
        this.avatar.setRenderer(new GenericListCellRenderer());
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 2;
        gbConstraints.insets.right = 5;
        gbConstraints.insets.left = 5;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        characterGeneral.add((Component)this.avatar, gbConstraints);
        gbConstraints.gridheight = 1;
        gbConstraints.weighty = 1.0;
        JLabel nameLabel = new JLabel("Name:");
        nameLabel.setToolTipText("Name: Maximum 31 characters.");
        nameLabel.setDisplayedMnemonic('N');
        ++gbConstraints.gridx;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 0;
        characterGeneral.add((Component)nameLabel, gbConstraints);
        this.name = new JTextField(31);
        this.name.setDocument(new LimitedPlainDocument(31, false, null));
        this.name.setToolTipText(nameLabel.getToolTipText());
        nameLabel.setLabelFor(this.name);
        ++gbConstraints.gridx;
        gbConstraints.insets.right = 11;
        gbConstraints.weightx = 1.0;
        characterGeneral.add((Component)this.name, gbConstraints);
        JButton generateName = new JButton("Generate");
        generateName.addActionListener(new GenerateWarlordNameAction(this));
        generateName.setToolTipText("Generate a warlord name.");
        ++gbConstraints.gridx;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 5;
        gbConstraints.gridwidth = 0;
        characterGeneral.add((Component)generateName, gbConstraints);
        gbConstraints.insets.top = 6;
        JLabel capitalLabel = new JLabel("Capital:");
        capitalLabel.setToolTipText("Capital: Maximum 31 characters.");
        capitalLabel.setDisplayedMnemonic('a');
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 1;
        gbConstraints.insets.right = 11;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        characterGeneral.add((Component)capitalLabel, gbConstraints);
        this.capital = new JTextField(31);
        this.capital.setDocument(new LimitedPlainDocument(31, false, null));
        this.capital.setToolTipText(capitalLabel.getToolTipText());
        capitalLabel.setLabelFor(this.capital);
        ++gbConstraints.gridx;
        gbConstraints.weightx = 1.0;
        gbConstraints.insets.right = 11;
        characterGeneral.add((Component)this.capital, gbConstraints);
        JButton generateCity = new JButton("Generate");
        generateCity.addActionListener(new GenerateCapitalNameAction(this));
        generateCity.setToolTipText("Generate a city name.");
        ++gbConstraints.gridx;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.right = 5;
        characterGeneral.add((Component)generateCity, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.gridx = -1;
        gbConstraints.gridy = -1;
        gbConstraints.weighty = 0.0;
        gbConstraints.insets.top = 0;
        JPanel characterClass = new JPanel(new GridBagLayout());
        characterClass.setBorder(BorderFactory.createTitledBorder("Class"));
        character.add((Component)characterClass, gbConstraints);
        JLabel classTypeLabel = new JLabel("Type:");
        classTypeLabel.setToolTipText("Type: Get help to cross-check with the abilities.");
        classTypeLabel.setDisplayedMnemonic('T');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        characterClass.add((Component)classTypeLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.classType = new JComboBox<Object>(CLASS_NAMES.toArray());
        this.classType.setRenderer(new GenericListCellRenderer());
        this.classType.setToolTipText(classTypeLabel.getToolTipText());
        this.classType.setActionCommand(ACTION_CLASS_TYPE);
        this.classType.addActionListener(uiHandler);
        classTypeLabel.setLabelFor(this.classType);
        gbConstraints.insets.right = 5;
        characterClass.add((Component)this.classType, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel majorAbilityLabel = new JLabel("Major:");
        majorAbilityLabel.setToolTipText("Major Ability: Get help to cross-check with the class.");
        majorAbilityLabel.setDisplayedMnemonic('M');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        characterClass.add((Component)majorAbilityLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        this.majorAbility = new JComboBox<Object>(ABILITY_NAMES.toArray());
        this.majorAbility.setRenderer(new GenericListCellRenderer());
        this.majorAbility.setToolTipText(majorAbilityLabel.getToolTipText());
        this.majorAbility.setActionCommand(ACTION_MAJOR_ABILITY);
        this.majorAbility.addActionListener(uiHandler);
        majorAbilityLabel.setLabelFor(this.majorAbility);
        characterClass.add((Component)this.majorAbility, gbConstraints);
        JLabel minorAbilityLabel = new JLabel("Minor:");
        minorAbilityLabel.setToolTipText("Minor Ability: Get help to cross-check with the class.");
        minorAbilityLabel.setDisplayedMnemonic('i');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        characterClass.add((Component)minorAbilityLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.minorAbility = new JComboBox<Object>(ABILITY_NAMES.toArray());
        this.minorAbility.setRenderer(new GenericListCellRenderer());
        this.minorAbility.setToolTipText(minorAbilityLabel.getToolTipText());
        minorAbilityLabel.setLabelFor(this.minorAbility);
        gbConstraints.insets.right = 5;
        characterClass.add((Component)this.minorAbility, gbConstraints);
        gbConstraints.insets.right = 0;
        JPanel characterSkills = new JPanel(new GridBagLayout());
        characterSkills.setBorder(BorderFactory.createTitledBorder("Skills"));
        character.add((Component)characterSkills, gbConstraints);
        JLabel majorSkillLabel = new JLabel("Major:");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        characterSkills.add((Component)majorSkillLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        Ability ability = Ability.createAbility(UNIT_SKILLS[0][0]);
        this.majorSkill = new JLabel(ability.getLabel(), ability.getIcon(), 10);
        this.majorSkill.setToolTipText(ability.getDescription());
        this.majorSkill.setBorder(BorderFactory.createTitledBorder((String)null));
        majorSkillLabel.setLabelFor(this.majorSkill);
        characterSkills.add((Component)this.majorSkill, gbConstraints);
        JLabel minorSkillLabel = new JLabel("Minor:");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        characterSkills.add((Component)minorSkillLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        ability = Ability.createAbility(UNIT_SKILLS[0][1]);
        this.minorSkill = new JLabel(ability.getLabel(), ability.getIcon(), 10);
        this.minorSkill.setToolTipText(ability.getDescription());
        this.minorSkill.setBorder(this.majorSkill.getBorder());
        minorSkillLabel.setLabelFor(this.minorSkill);
        gbConstraints.insets.right = 5;
        characterSkills.add((Component)this.minorSkill, gbConstraints);
        gbConstraints.insets.right = 0;
        Dimension maxSize = new Dimension();
        maxSize.width = 0;
        maxSize.height = 0;
        Dimension size = classTypeLabel.getPreferredSize();
        if (size.width > maxSize.width) {
            maxSize.width = size.width;
        }
        if (size.height > maxSize.height) {
            maxSize.height = size.height;
        }
        size = majorAbilityLabel.getPreferredSize();
        if (size.width > maxSize.width) {
            maxSize.width = size.width;
        }
        if (size.height > maxSize.height) {
            maxSize.height = size.height;
        }
        size = minorAbilityLabel.getPreferredSize();
        if (size.width > maxSize.width) {
            maxSize.width = size.width;
        }
        if (size.height > maxSize.height) {
            maxSize.height = size.height;
        }
        size = majorSkillLabel.getPreferredSize();
        if (size.width > maxSize.width) {
            maxSize.width = size.width;
        }
        if (size.height > maxSize.height) {
            maxSize.height = size.height;
        }
        size = minorSkillLabel.getPreferredSize();
        if (size.width > maxSize.width) {
            maxSize.width = size.width;
        }
        if (size.height > maxSize.height) {
            maxSize.height = size.height;
        }
        classTypeLabel.setPreferredSize(maxSize);
        majorAbilityLabel.setPreferredSize(maxSize);
        minorAbilityLabel.setPreferredSize(maxSize);
        majorSkillLabel.setPreferredSize(maxSize);
        minorSkillLabel.setPreferredSize(maxSize);
        maxSize = this.majorAbility.getPreferredSize();
        maxSize.height = this.majorSkill.getPreferredSize().height;
        this.majorSkill.setPreferredSize(maxSize);
        this.minorSkill.setPreferredSize(maxSize);
        gbConstraints.weighty = 1.0;
        character.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        JPanel statistics = new JPanel(new GridBagLayout());
        statistics.setName("WStatistics");
        pane.addTab("Statistics", ICON_STATISTICS, statistics);
        JPanel statisticsRace = new JPanel(new GridBagLayout());
        statisticsRace.setBorder(BorderFactory.createTitledBorder("Race"));
        statistics.add((Component)statisticsRace, gbConstraints);
        JLabel raceLabel = new JLabel("Favored Race:");
        raceLabel.setToolTipText("Favored Race: Hirelings will be most probably from this race.");
        raceLabel.setDisplayedMnemonic('a');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        statisticsRace.add((Component)raceLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.race = new JComboBox<Object>(UnitEditionPanel.RACE_NAMES.toArray());
        this.race.setRenderer(new GenericListCellRenderer());
        this.race.setToolTipText(raceLabel.getToolTipText());
        raceLabel.setLabelFor(this.race);
        gbConstraints.insets.right = 5;
        statisticsRace.add((Component)this.race, gbConstraints);
        gbConstraints.insets.right = 0;
        JPanel statisticsCombat = new JPanel(new GridBagLayout());
        statisticsCombat.setBorder(BorderFactory.createTitledBorder("Combat"));
        statistics.add((Component)statisticsCombat, gbConstraints);
        JLabel experienceLabel = new JLabel("Experience:");
        experienceLabel.setToolTipText("Experience: Each 10 points equals a level.");
        experienceLabel.setDisplayedMnemonic('E');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        statisticsCombat.add((Component)experienceLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.experience = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this.experience.setToolTipText(experienceLabel.getToolTipText());
        experienceLabel.setLabelFor(this.experience);
        gbConstraints.insets.right = 5;
        statisticsCombat.add((Component)this.experience, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel levelLabel = new JLabel("Level:");
        levelLabel.setToolTipText("Level: Each 10 points equals a level.");
        levelLabel.setDisplayedMnemonic('L');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        statisticsCombat.add((Component)levelLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.level = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.level.setToolTipText(levelLabel.getToolTipText());
        levelLabel.setLabelFor(this.level);
        gbConstraints.insets.right = 5;
        statisticsCombat.add((Component)this.level, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel battlesLabel = new JLabel("Battles:");
        battlesLabel.setToolTipText("Battles: Number of games played.");
        battlesLabel.setDisplayedMnemonic('B');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        statisticsCombat.add((Component)battlesLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.battles = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this.battles.setToolTipText(battlesLabel.getToolTipText());
        battlesLabel.setLabelFor(this.battles);
        gbConstraints.insets.right = 5;
        statisticsCombat.add((Component)this.battles, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel victoriesLabel = new JLabel("Victories:");
        victoriesLabel.setToolTipText("Victories: Number of victorious games.");
        victoriesLabel.setDisplayedMnemonic('V');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        statisticsCombat.add((Component)victoriesLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.victories = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this.victories.setToolTipText(victoriesLabel.getToolTipText());
        victoriesLabel.setLabelFor(this.victories);
        gbConstraints.insets.right = 5;
        statisticsCombat.add((Component)this.victories, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.weighty = 1.0;
        statistics.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        maxSize = new Dimension();
        size = raceLabel.getPreferredSize();
        if (size.width > maxSize.width) {
            maxSize.width = size.width;
        }
        if (size.height > maxSize.height) {
            maxSize.height = size.height;
        }
        size = experienceLabel.getPreferredSize();
        if (size.width > maxSize.width) {
            maxSize.width = size.width;
        }
        if (size.height > maxSize.height) {
            maxSize.height = size.height;
        }
        size = levelLabel.getPreferredSize();
        if (size.width > maxSize.width) {
            maxSize.width = size.width;
        }
        if (size.height > maxSize.height) {
            maxSize.height = size.height;
        }
        size = battlesLabel.getPreferredSize();
        if (size.width > maxSize.width) {
            maxSize.width = size.width;
        }
        if (size.height > maxSize.height) {
            maxSize.height = size.height;
        }
        size = victoriesLabel.getPreferredSize();
        if (size.width > maxSize.width) {
            maxSize.width = size.width;
        }
        if (size.height > maxSize.height) {
            maxSize.height = size.height;
        }
        raceLabel.setPreferredSize(maxSize);
        experienceLabel.setPreferredSize(maxSize);
        levelLabel.setPreferredSize(maxSize);
        battlesLabel.setPreferredSize(maxSize);
        victoriesLabel.setPreferredSize(maxSize);
        this.skills = new SkillsPanel();
        pane.addTab("Skills", ICON_SKILLS, this.skills);
        this.cityUpgrades = new CityUpgradesPanel();
        pane.addTab("City Upgrades", ICON_CITY_UPGRADES, this.cityUpgrades);
        this.provinces = new ProvincesPanel();
        pane.addTab("Provinces", ICON_PROVINCES, this.provinces);
        JPanel ritnues = new JPanel(new GridBagLayout());
        ritnues.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ritnues.setName(RETINUES_FOLDER);
        pane.addTab(RETINUES_FOLDER, ICON_RETINUES, ritnues);
        RetinuesEditAction retinuesEditAction = new RetinuesEditAction(this);
        RetinuesWizardAction retinuesWizardAction = new RetinuesWizardAction(this);
        RetinuesExportAction retinuesExportAction = new RetinuesExportAction(this);
        RetinuesImportAction retinuesImportAction = new RetinuesImportAction(this);
        this.retinuesCheck = new JCheckBox[3];
        this.retinuesEditButton = new JButton[3];
        this.retinuesExportButton = new JButton[3];
        this.retinuesImportButton = new JButton[3];
        this.retinuesWizardButton = new JButton[3];
        this.retinues = new Unit[3];
        this.retinuesPath = new String[3];
        for (int i = 0; i < 3; ++i) {
            this.retinuesCheck[i] = new JCheckBox(UnitEditionPanel.getUnitLabel(null) + "#" + (i + 1));
            this.retinuesCheck[i].addActionListener(retinuesEditAction);
            this.retinuesCheck[i].setActionCommand(Integer.toString(i));
            this.retinuesCheck[i].setToolTipText("Retinue #" + (i + 1) + ": Will help you in your conquest of the Etheria.");
            this.retinuesCheck[i].setMnemonic(Integer.toString(i + 1).charAt(0));
            gbConstraints.gridwidth = 1;
            gbConstraints.insets.right = 5;
            ritnues.add((Component)this.retinuesCheck[i], gbConstraints);
            gbConstraints.weightx = 0.0;
            this.retinuesEditButton[i] = new JButton("Create");
            this.retinuesEditButton[i].addActionListener(retinuesEditAction);
            this.retinuesEditButton[i].setActionCommand(Integer.toString(i));
            this.retinuesEditButton[i].setEnabled(false);
            this.retinuesEditButton[i].setToolTipText("Create a retinue.");
            ritnues.add((Component)this.retinuesEditButton[i], gbConstraints);
            this.retinuesWizardButton[i] = new JButton("Wizard");
            this.retinuesWizardButton[i].addActionListener(retinuesWizardAction);
            this.retinuesWizardButton[i].setActionCommand(Integer.toString(i));
            this.retinuesWizardButton[i].setEnabled(false);
            this.retinuesWizardButton[i].setToolTipText("Create a legit retinue.");
            ritnues.add((Component)this.retinuesWizardButton[i], gbConstraints);
            this.retinuesExportButton[i] = new JButton("Export");
            this.retinuesExportButton[i].addActionListener(retinuesExportAction);
            this.retinuesExportButton[i].setActionCommand(Integer.toString(i));
            this.retinuesExportButton[i].setEnabled(false);
            this.retinuesExportButton[i].setToolTipText("Export this retinue in a separate file.");
            ritnues.add((Component)this.retinuesExportButton[i], gbConstraints);
            this.retinuesImportButton[i] = new JButton("Import");
            this.retinuesImportButton[i].addActionListener(retinuesImportAction);
            this.retinuesImportButton[i].setActionCommand(Integer.toString(i));
            this.retinuesImportButton[i].setEnabled(false);
            this.retinuesImportButton[i].setToolTipText("Import this retinue from a separate file.");
            gbConstraints.gridwidth = 0;
            gbConstraints.insets.right = 0;
            ritnues.add((Component)this.retinuesImportButton[i], gbConstraints);
            gbConstraints.weightx = 1.0;
        }
        gbConstraints.weighty = 1.0;
        ritnues.add((Component)new Filler(), gbConstraints);
    }

    public Warlord getWarlord() {
        return this.warlord;
    }

    public void setWarlord(Warlord warlord) {
        this.warlord = warlord;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.majorAbility != null) {
            Dimension size = this.majorAbility.getPreferredSize();
            this.majorSkill.setPreferredSize(null);
            size.height = this.majorSkill.getPreferredSize().height;
            this.majorSkill.setPreferredSize(size);
            this.minorSkill.setPreferredSize(size);
        }
    }

    void importRetinue(int index) {
        String target = this.retinuesPath[index];
        if (target != null) {
            WarlordInputStream input = null;
            try {
                Unit unit;
                input = new WarlordInputStream(target);
                this.retinues[index] = unit = WarlordFactory.readUnit(input);
                this.retinuesCheck[index].setText(this.retinues[index].toString());
                this.setRetinues();
                this.tracker.stateChanged(new ChangeEvent(this));
            }
            catch (Throwable exception) {
                // empty catch block
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable exception) {
                    // empty catch block
                }
            }
        }
    }

    void exportRetinue(int index) {
        String target = this.retinuesPath[index];
        if (target != null && this.retinues[index] != null) {
            WarlordOutputStream output = null;
            try {
                output = new WarlordOutputStream(target);
                WarlordFactory.writeUnit(output, this.retinues[index], index);
            }
            catch (IOException exception) {
                // empty catch block
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    void setLabels() {
        this.cityUpgrades.setLabels(this.majorAbility.getSelectedIndex());
    }

    void setRetinues() {
        for (int i = 0; i < 3; ++i) {
            if (this.retinues[i] != null) {
                this.retinuesEditButton[i].setText("Edit");
                this.retinuesEditButton[i].setToolTipText("Edit this retinue.");
            } else {
                this.retinuesEditButton[i].setText("Create");
                this.retinuesEditButton[i].setToolTipText("Create a retinue.");
            }
            if (i > 0) {
                this.retinuesCheck[i].setEnabled(this.retinuesCheck[i - 1].isSelected() && this.retinues[i - 1] != null);
                this.retinuesCheck[i].setSelected(this.retinuesCheck[i].isEnabled() && this.retinuesCheck[i].isSelected());
                this.retinuesEditButton[i].setEnabled(this.retinuesCheck[i].isSelected());
                this.retinuesWizardButton[i].setEnabled(this.retinuesCheck[i].isSelected());
                this.retinuesExportButton[i].setEnabled(this.retinuesCheck[i].isSelected() && this.retinues[i] != null);
                this.retinuesImportButton[i].setEnabled(this.retinuesCheck[i].isSelected());
                continue;
            }
            this.retinuesEditButton[i].setEnabled(this.retinuesCheck[i].isSelected());
            this.retinuesWizardButton[i].setEnabled(this.retinuesCheck[i].isSelected());
            this.retinuesExportButton[i].setEnabled(this.retinuesCheck[i].isSelected() && this.retinues[i] != null);
            this.retinuesImportButton[i].setEnabled(this.retinuesCheck[i].isSelected());
        }
    }

    public void load() {
        Warlord warlord = this.getWarlord();
        if (warlord != null) {
            int i;
            this.name.setText(warlord.getName());
            this.capital.setText(warlord.getCapital());
            this.avatar.setSelectedIndex(warlord.getAvatar());
            this.classType.setSelectedIndex(warlord.getClassType());
            this.majorAbility.setSelectedIndex(warlord.getMajorAbility());
            this.minorAbility.setSelectedIndex(warlord.getMinorAbility());
            this.race.setSelectedIndex(warlord.getRace());
            this.experience.setValue(new Integer(warlord.getExperience()));
            this.level.setValue(new Integer(warlord.getLevel()));
            this.battles.setValue(new Integer(warlord.getBattles()));
            this.victories.setValue(new Integer(warlord.getVictories()));
            for (i = 0; i < 17; ++i) {
                this.skills.setSkillLevel(i, warlord.getSkillLevel(i));
            }
            this.skills.setClassType(warlord.getClassType());
            this.skills.ensureLimited();
            for (i = 0; i < 23; ++i) {
                this.cityUpgrades.setSelected(i, warlord.isCityUpgraded(i));
            }
            for (i = 0; i < 32; ++i) {
                this.provinces.setSelected(i, warlord.isProvinceWon(i));
            }
            for (i = 0; i < 3; ++i) {
                this.retinues[i] = warlord.getRetinue(i);
                this.retinuesPath[i] = null;
                this.retinuesCheck[i].setSelected(this.retinues[i] != null);
                if (this.retinues[i] != null) {
                    this.retinuesCheck[i].setText(UnitEditionPanel.getUnitLabel(this.retinues[i]));
                    continue;
                }
                this.retinuesCheck[i].setText("retinue #" + (i + 1));
            }
        } else {
            int i;
            this.name.setText(null);
            this.capital.setText(null);
            this.avatar.setSelectedIndex(0);
            this.classType.setSelectedIndex(0);
            this.majorAbility.setSelectedIndex(0);
            this.minorAbility.setSelectedIndex(0);
            this.race.setSelectedIndex(0);
            this.experience.setValue(new Integer(0));
            this.level.setValue(new Integer(1));
            this.battles.setValue(new Integer(0));
            this.victories.setValue(new Integer(0));
            for (i = 0; i < 17; ++i) {
                this.skills.setSkillLevel(i, 0);
            }
            this.skills.setClassType(0);
            this.skills.ensureLimited();
            for (i = 0; i < 23; ++i) {
                this.cityUpgrades.setSelected(i, false);
            }
            for (i = 0; i < 32; ++i) {
                this.provinces.setSelected(i, false);
            }
            for (i = 0; i < 3; ++i) {
                this.retinuesCheck[i].setSelected(false);
            }
        }
        this.cityUpgrades.setState();
        this.setLabels();
        this.setRetinues();
    }

    public void save(Warlord warlord) {
        if (warlord != null) {
            int i;
            int i2;
            warlord.setName(this.name.getText());
            warlord.setCapital(this.capital.getText());
            warlord.setAvatar(this.avatar.getSelectedIndex());
            warlord.setClassType(this.classType.getSelectedIndex());
            warlord.setMajorAbility(this.majorAbility.getSelectedIndex());
            warlord.setMinorAbility(this.minorAbility.getSelectedIndex());
            warlord.setRace(this.race.getSelectedIndex());
            warlord.setExperience(((Number)this.experience.getValue()).intValue());
            warlord.setLevel(((Number)this.level.getValue()).intValue());
            warlord.setBattles(((Number)this.battles.getValue()).intValue());
            warlord.setVictories(((Number)this.victories.getValue()).intValue());
            for (i2 = 0; i2 < 17; ++i2) {
                warlord.setSkillLevel(i2, this.skills.getSkillLevel(i2));
            }
            for (i2 = 0; i2 < 23; ++i2) {
                warlord.setCityUpgraded(i2, this.cityUpgrades.isSelected(i2));
            }
            for (i2 = 0; i2 < 32; ++i2) {
                warlord.setProvinceWon(i2, this.provinces.isSelected(i2));
            }
            int retinuesCount = 0;
            for (i = 0; i < 3; ++i) {
                if (!this.retinuesCheck[i].isSelected() || this.retinues[i] == null) continue;
                warlord.setRetinue(retinuesCount++, this.retinues[i]);
            }
            for (i = retinuesCount; i < 3; ++i) {
                warlord.setRetinue(i, null);
            }
        }
    }

    public void save() {
        this.save(this.getWarlord());
    }

    public void addChangeTracker(ChangeTracker tracker) {
        this.name.getDocument().addDocumentListener(tracker);
        this.capital.getDocument().addDocumentListener(tracker);
        this.avatar.addActionListener(tracker);
        this.classType.addActionListener(tracker);
        this.majorAbility.addActionListener(tracker);
        this.minorAbility.addActionListener(tracker);
        this.race.addActionListener(tracker);
        this.experience.addChangeListener(tracker);
        this.level.addChangeListener(tracker);
        this.battles.addChangeListener(tracker);
        this.victories.addChangeListener(tracker);
        this.skills.addChangeTracker(tracker);
        this.cityUpgrades.addChangeTracker(tracker);
        this.provinces.addChangeTracker(tracker);
        for (int i = 0; i < 3; ++i) {
            this.retinuesCheck[i].addActionListener(tracker);
        }
        this.tracker = tracker;
    }

    static {
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Warrior.png"), "Warrior"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Templar.png"), "Templar"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Barbarian.png"), "Barbarian"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Ranger.png"), "Ranger"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Flameknight.png"), "Flameknight"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Blackguard.png"), "Blackguard"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Paladin.png"), "Paladin"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Priest.png"), "Priest"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Cleric.png"), "Cleric"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Monk.png"), "Monk"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Heretic.png"), "Heretic"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Deathpriest.png"), "Deathpriest"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Runelord.png"), "Runelord"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Runepriest.png"), "Runepriest"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Runemaster.png"), "Runemaster"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Runesmith.png"), "Runesmith"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Seer.png"), "Seer"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Gorgon.png"), "Gorgon"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Beastmaster.png"), "Beastmaster"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Heirophant.png"), "Heirophant"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Alchemist.png"), "Alchemist"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Druid.png"), "Druid"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Shaman.png"), "Shaman"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-BlackDruid.png"), "Black Druid"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Battlemage.png"), "Battlemage"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Mystic.png"), "Mystic"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Conjuror.png"), "Conjuror"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Elementalist.png"), "Elementalist"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Summoner.png"), "Summoner"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Sorceror.png"), "Sorceror"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-DeathKnight.png"), "Death Knight"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-PlaguePriest.png"), "Plague Priest"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Cabalist.png"), "Cabalist"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Warlock.png"), "Warlock"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Ghoul.png"), "Ghoul"));
        CLASS_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/class-Necromancer.png"), "Necromancer"));
        ABILITY_NAMES = new ArrayList<LabeledIcon>(8);
        ABILITY_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/ability-combat.png"), "Combat"));
        ABILITY_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/ability-divine.png"), "Divine Magic"));
        ABILITY_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/ability-rune.png"), "Rune Magic"));
        ABILITY_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/ability-nature.png"), "Nature Magic"));
        ABILITY_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/ability-summoning.png"), "Summoning"));
        ABILITY_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/ability-necromancy.png"), "Necromancy"));
        AVATARS_ICONS = new Vector(64);
        for (int i = 0; i < 33; ++i) {
            if (i < 10) {
                AVATARS_ICONS.add(new ResourceIcon("com/softlabs/warlords4/rsc/Portrait0" + i + ".png"));
                continue;
            }
            AVATARS_ICONS.add(new ResourceIcon("com/softlabs/warlords4/rsc/Portrait" + i + ".png"));
        }
        ICON_CHARACTER = new ResourceIcon("com/softlabs/warlords4/rsc/character.png");
        ICON_STATISTICS = new ResourceIcon("com/softlabs/warlords4/rsc/statistics.png");
        ICON_SKILLS = new ResourceIcon("com/softlabs/warlords4/rsc/skills.png");
        ICON_CITY_UPGRADES = new ResourceIcon("com/softlabs/warlords4/rsc/cityUpgrades.png");
        ICON_PROVINCES = new ResourceIcon("com/softlabs/warlords4/rsc/Provinces.png");
        ICON_RETINUES = new ResourceIcon("com/softlabs/warlords4/rsc/retinues.png");
        UNIT_SKILLS = new int[][]{{2, 5}, {2, 38}, {2, 23}, {2, 25}, {2, 9}, {2, 36}, {4, 5}, {4, 38}, {4, 23}, {4, 25}, {4, 9}, {4, 36}, {7, 5}, {7, 38}, {7, 23}, {7, 25}, {7, 9}, {7, 36}, {17, 5}, {17, 38}, {17, 23}, {17, 25}, {17, 9}, {17, 36}, {16, 5}, {16, 38}, {16, 23}, {16, 25}, {16, 9}, {16, 36}, {8, 5}, {8, 38}, {8, 23}, {8, 25}, {8, 9}, {8, 36}};
    }

    private static final class GenerateCapitalNameAction
    implements ActionListener {
        private final WarlordEditionPanel panel;

        public GenerateCapitalNameAction(WarlordEditionPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int race = this.panel.race.getSelectedIndex();
            String name = CityNameGenerator.generateName(race);
            this.panel.capital.setText(name);
        }
    }

    private static final class GenerateWarlordNameAction
    implements ActionListener {
        private final WarlordEditionPanel panel;

        public GenerateWarlordNameAction(WarlordEditionPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int race = this.panel.race.getSelectedIndex();
            String name = UnitNameGenerator.generateName(race);
            this.panel.name.setText(name);
        }
    }

    private static final class RetinuesImportAction
    implements ActionListener {
        private final WarlordEditionPanel panel;

        public RetinuesImportAction(WarlordEditionPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int index = -1;
            try {
                index = Integer.parseInt(event.getActionCommand());
            }
            catch (Throwable exception) {
                // empty catch block
            }
            if (index == -1) {
                return;
            }
            ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
            String basePath = ((Preferences)preferences).get("gameRoot", ApplicationPreferences.DEFAULT_GAME_ROOT);
            File base = new File(basePath, WarlordEditionPanel.RETINUES_FOLDER);
            if (!base.exists()) {
                Files.mkdirs(base.toString());
            }
            this.panel.chooser.setSelectedFile(null);
            this.panel.chooser.setCurrentDirectory(null);
            this.panel.chooser.setCurrentDirectory(base);
            if (this.panel.retinuesPath[index] != null) {
                this.panel.chooser.setSelectedFile(new File(this.panel.retinuesPath[index]));
            }
            this.panel.chooser.setAcceptAllFileFilterUsed(false);
            this.panel.chooser.addChoosableFileFilter(Unit.DEFAULT_FILTER);
            this.panel.chooser.setFileSelectionMode(0);
            if (this.panel.chooser.showDialog(0) == 0) {
                this.panel.retinuesPath[index] = this.panel.chooser.getSelectedFile().getAbsolutePath();
                this.panel.importRetinue(index);
            }
        }
    }

    private static final class RetinuesExportAction
    implements ActionListener {
        private final WarlordEditionPanel panel;

        public RetinuesExportAction(WarlordEditionPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Unit unit = null;
            int index = -1;
            try {
                index = Integer.parseInt(event.getActionCommand());
                unit = this.panel.retinues[index];
            }
            catch (Throwable exception) {
                // empty catch block
            }
            if (unit == null) {
                return;
            }
            ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
            String basePath = ((Preferences)preferences).get("gameRoot", ApplicationPreferences.DEFAULT_GAME_ROOT);
            File base = new File(basePath, WarlordEditionPanel.RETINUES_FOLDER);
            if (!base.exists()) {
                Files.mkdirs(base.toString());
            }
            if (this.panel.retinuesPath[index] == null) {
                String name = unit.getName();
                if (name == null || name.length() == 0) {
                    LabeledIcon unitType = UnitEditionPanel.getUnitName(unit.getRace(), unit.getType());
                    name = unitType.getLabel();
                    name = name.substring(0, name.indexOf(40)).trim();
                }
                this.panel.retinuesPath[index] = new File(base, name + '.' + "rit").getAbsolutePath();
            }
            this.panel.chooser.setAcceptAllFileFilterUsed(false);
            this.panel.chooser.addChoosableFileFilter(Unit.DEFAULT_FILTER);
            this.panel.chooser.setFileSelectionMode(0);
            this.panel.chooser.setSelectedFile(null);
            this.panel.chooser.setCurrentDirectory(null);
            this.panel.chooser.setCurrentDirectory(base);
            if (this.panel.retinuesPath[index] != null) {
                this.panel.chooser.setSelectedFile(new File(this.panel.retinuesPath[index]));
            }
            if (this.panel.chooser.showDialog(1) == 0) {
                this.panel.retinuesPath[index] = Files.setExtension(this.panel.chooser.getSelectedFile().getAbsolutePath(), "rit", true);
                this.panel.exportRetinue(index);
            }
        }
    }

    private static final class RetinuesWizardAction
    implements ActionListener {
        private final WarlordEditionPanel panel;

        public RetinuesWizardAction(WarlordEditionPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                int index = Integer.parseInt(event.getActionCommand());
                if (this.panel.unitWizardDialog == null) {
                    this.panel.unitWizardDialog = new UnitWizardDialog((JFrame)SwingUtilities.getWindowAncestor(this.panel));
                }
                this.panel.unitWizardDialog.loadUnit(this.panel.retinues[index]);
                this.panel.unitWizardDialog.setVisible(true);
                Unit unit = this.panel.unitWizardDialog.getUnit();
                if (unit != null) {
                    this.panel.retinues[index] = unit;
                    this.panel.retinuesCheck[index].setText(UnitEditionPanel.getUnitLabel(unit));
                }
                this.panel.setRetinues();
                if (unit != null) {
                    this.panel.tracker.stateChanged(new ChangeEvent(this));
                }
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
        }
    }

    private static final class RetinuesEditAction
    implements ActionListener {
        private final WarlordEditionPanel panel;

        public RetinuesEditAction(WarlordEditionPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() instanceof JCheckBox) {
                this.panel.setRetinues();
            } else if (event.getSource() instanceof JButton) {
                try {
                    int index = Integer.parseInt(event.getActionCommand());
                    if (this.panel.retinues[index] == null) {
                        this.panel.retinues[index] = new Unit();
                    }
                    if (this.panel.retinueDialog == null) {
                        this.panel.retinueDialog = new UnitEditionDialog((JFrame)SwingUtilities.getWindowAncestor(this.panel));
                    }
                    this.panel.retinueDialog.setUnit(this.panel.retinues[index]);
                    this.panel.retinueDialog.setTitle("retinue #" + (index + 1));
                    boolean changed = this.panel.retinueDialog.edit();
                    this.panel.retinuesCheck[index].setText(UnitEditionPanel.getUnitLabel(this.panel.retinues[index]));
                    this.panel.setRetinues();
                    if (changed) {
                        this.panel.tracker.stateChanged(new ChangeEvent(this));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static final class UIHandler
    implements ActionListener {
        private final WarlordEditionPanel panel;

        public UIHandler(WarlordEditionPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (WarlordEditionPanel.ACTION_MAJOR_ABILITY.equals(command)) {
                this.panel.setLabels();
            } else if (WarlordEditionPanel.ACTION_CLASS_TYPE.equals(command)) {
                int classType = this.panel.classType.getSelectedIndex();
                this.panel.majorAbility.setSelectedIndex(WarlordWizardPanel.CLASS_ABILITIES[classType][0]);
                this.panel.minorAbility.setSelectedIndex(WarlordWizardPanel.CLASS_ABILITIES[classType][1]);
                Ability ability = Ability.createAbility(UNIT_SKILLS[classType][0]);
                this.panel.majorSkill.setText(ability.getLabel());
                this.panel.majorSkill.setIcon(ability.getIcon());
                this.panel.majorSkill.setToolTipText(ability.getDescription());
                ability = Ability.createAbility(UNIT_SKILLS[classType][1]);
                this.panel.minorSkill.setText(ability.getLabel());
                this.panel.minorSkill.setIcon(ability.getIcon());
                this.panel.minorSkill.setToolTipText(ability.getDescription());
                this.panel.skills.setClassType(classType);
                this.panel.skills.resetAll(false);
            }
        }
    }
}

