/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.Version;
import com.softlabs.warlords4.data.ApplicationPreferences;
import com.softlabs.warlords4.data.PBEMWarlord;
import com.softlabs.warlords4.data.Warlord;
import com.softlabs.warlords4.event.DefaultChangeTracker;
import com.softlabs.warlords4.gui.AboutDialog;
import com.softlabs.warlords4.gui.ApplicationFrame;
import com.softlabs.warlords4.gui.ApplyResetPanel;
import com.softlabs.warlords4.gui.ExitDialog;
import com.softlabs.warlords4.gui.FileChooserDialog;
import com.softlabs.warlords4.gui.HelpKeyEventDispatcher;
import com.softlabs.warlords4.gui.HelpViewer;
import com.softlabs.warlords4.gui.MessageDialog;
import com.softlabs.warlords4.gui.PBEMWarlordEditionDialog;
import com.softlabs.warlords4.gui.PreferencesDialog;
import com.softlabs.warlords4.gui.Splash;
import com.softlabs.warlords4.gui.UpdateManager;
import com.softlabs.warlords4.gui.WarlordEditionPanel;
import com.softlabs.warlords4.gui.WarlordWizardDialog;
import com.softlabs.warlords4.gui.filechooser.StandardFileView;
import com.softlabs.warlords4.image.DisabledResourceIcon;
import com.softlabs.warlords4.image.ResourceIcon;
import com.softlabs.warlords4.io.WarlordFactory;
import com.softlabs.warlords4.util.BrowserLauncher;
import com.softlabs.warlords4.util.Files;
import com.softlabs.warlords4.util.StreamUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WarlordEditionFrame
extends ApplicationFrame
implements ActionListener,
WindowListener,
ChangeListener,
HelpViewer {
    private static final String MENUITEM_NEW = "New Warlord";
    private static final String MENUITEM_SAVE = "Save Warlord";
    private static final String MENUITEM_SAVEAS = "Save Warlord as...";
    private static final String MENUITEM_LOAD = "Load Warlord...";
    private static final String MENUITEM_IMPORT_PBEM = "Import PBEM Warlord...";
    private static final String MENUITEM_EXPORT_PBEM = "Export PBEM Warlord...";
    private static final String MENUITEM_IMPORT_PREMADE = "Import Pre-made Warlord...";
    private static final String MENUITEM_EXPORT_PREMADE = "Export Pre-made Warlord...";
    private static final String MENUITEM_WIZARD = "Creation Wizard...";
    private static final String MENUITEM_PLAY = "Play Warlords IV";
    private static final String MENUITEM_PREFERENCES = "Preferences...";
    private static final String MENUITEM_EXIT = "Exit";
    private static final String MENUITEM_ABOUT = "About...";
    private static final String MENUITEM_HELP = "Editor's Help...";
    private static final String MENUITEM_RECENT = "entry";
    private static final String MENU_ONLINE = "Online Help";
    private static final String MENUITEM_HOMEPAGE = "Editor's Home Page";
    private static final String MENUITEM_ONLINE_HELP = "Online Help";
    private static final String MENUITEM_UPDATES = "Check for Updates";
    private static final String MENUITEM_EMAIL_SUPPORT = "Email Feedback/Support";
    private static final String MENU_FORUMS = "Forums";
    private static final String FORUM_TAG = "F@";
    private static final String MENUITEM_FORUM_UBISOFT = "Ubisoft";
    private static final String MENUITEM_FORUM_BATTLEFIELD = "The BattleField";
    private static final String MENUITEM_FORUM_WARLORDERS = "Warlorders";
    private static final String MENUITEM_FORUM_INFINITE_INTERACTIVE = "Inifinite Interactive";
    private static final String MENU_HOME_PAGES = "Home Pages";
    private static final String HOME_PAGE_TAG = "HP@";
    private static final String MENUITEM_PORTAILSMM = "Warlords IV Editor";
    private static final String MENUITEM_UBISOFT = "Ubisoft";
    private static final String MENUITEM_WARLORDERS = "Warlorders";
    private static final String MENUITEM_BATTLEFIELD = "The BattleField";
    private static final String MENUITEM_INFINITE_INTERACTIVE = "Inifinite Interactive";
    private static final String MENUITEM_NIVISEC = "Nivisec's Warlords IV";
    private static final Icon PBEM_WARLORD_ICON = new ResourceIcon("com/softlabs/warlords4/rsc/PBEM-Icon.png");
    private static final Icon PBEM_WARLORD_IMPORT_ICON = new ResourceIcon("com/softlabs/warlords4/rsc/PBEM-Import-Icon.png");
    private static final Icon PBEM_WARLORD_EXPORT_ICON = new ResourceIcon("com/softlabs/warlords4/rsc/PBEM-Export-Icon.png");
    private static final Icon PREMADE_WARLORD_IMPORT_ICON = new ResourceIcon("com/softlabs/warlords4/rsc/PM-Import-Icon.png");
    private static final Icon PREMADE_WARLORD_EXPORT_ICON = new ResourceIcon("com/softlabs/warlords4/rsc/PM-Export-Icon.png");
    private static final Icon PREMADE_WARLORD_EXPORT_ICON_DISABLED = new DisabledResourceIcon("com/softlabs/warlords4/rsc/PM-Export-Icon.png");
    private static final Icon WARLORD_ICON_SMALL = new ResourceIcon("com/softlabs/warlords4/rsc/WAR-Icon-s.png");
    private static final Icon WARLORD_ICON_DISABLED_SMALL = new DisabledResourceIcon("com/softlabs/warlords4/rsc/WAR-Icon-s.png");
    public static final Icon WARLORD_ICON_BIG = new ResourceIcon("com/softlabs/warlords4/rsc/WAR-Icon.png");
    public static final Image WARLORD_IMAGE = ((ResourceIcon)WARLORD_ICON_BIG).getImage();
    private static final Icon UNIT_ICON_SMALL = new ResourceIcon("com/softlabs/warlords4/rsc/RIT-Icon-s.png");
    private static final Icon WARLORD_ICON_LOAD = new ResourceIcon("com/softlabs/warlords4/rsc/WAR-Icon-load.png");
    private static final Icon WARLORD_ICON_SAVE = new ResourceIcon("com/softlabs/warlords4/rsc/WAR-Icon-save.png");
    private static final Icon WARLORD_ICON_SAVEAS = new ResourceIcon("com/softlabs/warlords4/rsc/WAR-Icon-saveas.png");
    private static final Icon WARLORD_ICON_NEW = new ResourceIcon("com/softlabs/warlords4/rsc/WAR-Icon-new.png");
    private static final Icon WARLORD_WIZARD = new ResourceIcon("com/softlabs/warlords4/rsc/WAR-Icon-wizard.png");
    private static final Icon ICON_EXIT = new ResourceIcon("com/softlabs/warlords4/rsc/icon-exit.png");
    private static final Icon ICON_PREFERENCES = new ResourceIcon("com/softlabs/warlords4/rsc/icon-preferences.png");
    private static final Icon ICON_ABOUT = new ResourceIcon("com/softlabs/warlords4/rsc/icon-about-s.png");
    private static final Icon ICON_HELP = new ResourceIcon("com/softlabs/warlords4/rsc/icon-help.png");
    private static final Icon ICON_FORUMS = new ResourceIcon("com/softlabs/warlords4/rsc/icon-homepage-s.png");
    private static final Icon ICON_FORUM_UBISOFT = new ResourceIcon("com/softlabs/warlords4/rsc/icon-forum-ubisoft-s.png");
    private static final Icon ICON_FORUM_BATTLEFIELD = new ResourceIcon("com/softlabs/warlords4/rsc/icon-forum-battlefield-s.png");
    private static final Icon ICON_FORUM_WARLORDERS = new ResourceIcon("com/softlabs/warlords4/rsc/icon-forum-warlorders-s.png");
    private static final Icon ICON_FORUM_INFINITE_INTERACTIVE = new ResourceIcon("com/softlabs/warlords4/rsc/icon-home-infinite-s.png");
    private static final Icon ICON_HOME_PAGES = new ResourceIcon("com/softlabs/warlords4/rsc/icon-home-s.png");
    private static final Icon ICON_HOME_PAGE_PORTAILSMM = new ResourceIcon("com/softlabs/warlords4/rsc/icon-home-portailsmm-s.png");
    private static final Icon ICON_HOME_PAGE_UBISOFT = new ResourceIcon("com/softlabs/warlords4/rsc/icon-home-ubisoft-s.png");
    private static final Icon ICON_HOME_PAGE_BATTLEFIELD = new ResourceIcon("com/softlabs/warlords4/rsc/icon-home-battlefield-s.png");
    private static final Icon ICON_HOME_PAGE_WARLORDERS = new ResourceIcon("com/softlabs/warlords4/rsc/icon-home-warlorders-s.png");
    private static final Icon ICON_HOME_PAGE_INFINITE_INTERACTIVE = new ResourceIcon("com/softlabs/warlords4/rsc/icon-home-infinite-s.png");
    private static final Icon ICON_HOME_PAGE_NIVISEC = new ResourceIcon("com/softlabs/warlords4/rsc/icon-home-nivisec-s.png");
    private static final Icon ICON_HOMEPAGE = ICON_HOME_PAGE_PORTAILSMM;
    private static final Icon ICON_ONLINE_HELP = new ResourceIcon("com/softlabs/warlords4/rsc/icon-onlinehelp-s.png");
    private static final Icon ICON_UPDATES = new ResourceIcon("com/softlabs/warlords4/rsc/icon-updates-s.png");
    private static final Icon ICON_EMAIL_SUPPORT = new ResourceIcon("com/softlabs/warlords4/rsc/icon-email-s.png");
    private static final Icon ICON_ONLINE = new ResourceIcon("com/softlabs/warlords4/rsc/icon-online-s.png");
    private static final String WARLORDS_FOLDER = "Warlords";
    private static final String PBEM_WARLORDS_FOLDER = "PBEMPlayers";
    private static final String PREMADE_WARLORDS_FOLDER = "Assets/Warlords";
    private static final String BASE_URL = "http://www.portailsmm.com/warlords4/";
    private static final String HOMEPAGE_URL = "http://www.portailsmm.com/warlords4/index.html";
    private static final String ONLINE_HELP_URL = "http://www.portailsmm.com/warlords4/Warlords4Editor.html";
    private static final String EMAIL_URL = "http://www.portailsmm.com/warlords4/Warlords4Editor.html#Contact";
    private static final String DEFAULT_HELP_FILENAME = "file:///" + Files.getSystemBase().replace('\\', '/') + "/Warlords4Editor.html";
    private static final String EDITOR_VERSION_URL = "http://www.portailsmm.com/warlords4/version.txt";
    private static final String EDITOR_ZIP_FILE = "Warlords4Editor.zip";
    private static final String LOCK_FILE = "Warlords4Editor.syn";
    private static final String UBISOFT_FORUM_URL = "http://forums.ubi.com/groupee/forums/a/frm/f/416100442";
    private static final String BATTLEFIELD_FORUM_URL = "http://www.the-battlefield.com/forum/index.php?showforum=8";
    private static final String WARLORDERS_FORUM_URL = "http://www.warlorders.com/phpBB2/index.php";
    private static final String INFINITE_INTERACTIVE_FORUM_URL = "http://www.infinite-interactive.com/InfiniteForums";
    private static final String PORTAILSMM_URL = "http://www.portailsmm.com/warlords4";
    private static final String UBISOFT_URL = "http://www.warlords4.com";
    private static final String BATTLEFIELD_URL = "http://www.the-battlefield.com/index.php?page=maingame&game=wl4";
    private static final String WARLORDERS_URL = "http://www.warlorders.com";
    private static final String INFINITE_INTERACTIVE_URL = "http://www.infinite-interactive.com/W4index.shtml";
    private static final String NIVISEC_URL = "http://warlordsiv.nivisec.com/";
    private WarlordEditionPanel warlordPanel;
    private AboutDialog aboutDialog;
    private FileChooserDialog chooser = FileChooserDialog.DEFAULT_CHOOSER;
    private PreferencesDialog preferencesDialog;
    private boolean isNew = true;
    private List<JMenuItem> recentMenus = new ArrayList<JMenuItem>(4);
    private boolean changed;
    private WarlordWizardDialog wizardDialog;
    private ApplyResetPanel buttons;
    private PBEMWarlordEditionDialog pbemDialog;

    public WarlordEditionFrame() {
        super("Warlords IV - Warlord & Retinues Editor 2.54");
        this.setName("Usage");
        this.setJMenuBar(this.createMenuBar());
        this.setDefaultCloseOperation(0);
        JComponent root = (JComponent)this.getContentPane();
        root.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        root.setName("Usage");
        Splash defaultSplash = Splash.getDefaultSplash();
        defaultSplash.next();
        this.warlordPanel = new WarlordEditionPanel();
        root.add((Component)this.warlordPanel, "Center");
        defaultSplash.next();
        this.buttons = new ApplyResetPanel();
        this.buttons.addActionListener(this);
        root.add((Component)this.buttons, "South");
        this.buttons.installDefaultButton();
        defaultSplash.next();
        DefaultChangeTracker tracker = new DefaultChangeTracker();
        tracker.addChangeListener(this.buttons);
        tracker.addChangeListener(this);
        this.warlordPanel.addChangeTracker(tracker);
        defaultSplash.next();
        this.chooser.getContentPane().setName("Usage");
        StandardFileView sfv = (StandardFileView)StandardFileView.getFileView();
        sfv.addTypeDescription("rit", "Warlords IV - Retinue File");
        sfv.addIcon("rit", UNIT_ICON_SMALL);
        sfv.addTypeDescription("war", "Warlords IV - Warlord File");
        sfv.addIcon("war", WARLORD_ICON_SMALL);
        sfv.addTypeDescription("w4join", "Warlords IV - Warlord PBEM File");
        sfv.addIcon("w4join", PBEM_WARLORD_ICON);
        defaultSplash.next();
        this.showRecentFiles();
        defaultSplash.next();
        if (WARLORD_IMAGE != null) {
            Frame JAVA_FRAME0 = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.chooser);
            JAVA_FRAME0.setIconImage(WARLORD_IMAGE);
            this.setIconImage(WARLORD_IMAGE);
        }
        defaultSplash.next();
        this.addWindowListener(this);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        defaultSplash.next();
        ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
        String current = null;
        if (((Preferences)preferences).getBoolean("autoLoad", false)) {
            current = ((Preferences)preferences).get("entry0", null);
        }
        if (current == null || !this.load(current)) {
            this.newWarlord();
        }
        defaultSplash.next();
        HelpKeyEventDispatcher.installHelp();
        HelpKeyEventDispatcher.setHelpViewer(this);
        defaultSplash.next();
        if (((Preferences)preferences).getBoolean("autoUpdate", true)) {
            this.update(true);
        }
        defaultSplash.next();
    }

    public Warlord getWarlord() {
        return this.warlordPanel.getWarlord();
    }

    public void setRecentFile(String recent) {
        if (recent != null) {
            ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
            try {
                ((Preferences)preferences).sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean changed = false;
            ArrayList<String> recentList = new ArrayList<String>(9);
            recentList.add(recent);
            for (int i = 0; i < 9; ++i) {
                String current = ((Preferences)preferences).get(MENUITEM_RECENT + i, null);
                if (current == null) {
                    changed |= i == 0;
                    break;
                }
                if (!recent.equals(current)) {
                    recentList.add(current);
                    changed |= recentList.size() - 1 != i;
                    continue;
                }
                changed |= i != 0;
            }
            int maxRecent = ((Preferences)preferences).getInt("history", 4);
            while (recentList.size() > maxRecent) {
                recentList.remove(recentList.size() - 1);
            }
            for (int i = 0; i < recentList.size(); ++i) {
                ((Preferences)preferences).put(MENUITEM_RECENT + i, ((String)recentList.get(i)).toString());
            }
            try {
                ((Preferences)preferences).sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (changed) {
                this.showRecentFiles();
            } else {
                JMenuItem item = this.recentMenus.get(0);
                item.setEnabled(Files.exists(recent));
            }
        }
    }

    public void setWarlord(Warlord warlord) {
        this.warlordPanel.setWarlord(warlord);
        this.reset();
        this.changed = false;
    }

    @Override
    public void keyPressed(KeyEvent event) {
        int code = event.getKeyCode();
        if (code == 27) {
            this.exit(true);
        } else {
            super.keyPressed(event);
        }
    }

    public void apply() {
        this.warlordPanel.save();
        this.buttons.setApplyEnabled(false);
        this.buttons.setResetEnabled(false);
    }

    public void reset() {
        this.warlordPanel.load();
        this.buttons.setApplyEnabled(false);
        this.buttons.setResetEnabled(false);
    }

    private static final void showRecentFiles(List<JMenuItem> menuList, int maxSize, ActionListener listener, String action, int mask, String[] files, JMenu target) {
        int i;
        if (menuList.size() < maxSize) {
            for (i = menuList.size(); i < maxSize; ++i) {
                JMenuItem entry = new JMenuItem(WARLORD_ICON_SMALL);
                entry.addActionListener(listener);
                entry.setActionCommand(action);
                entry.setName(Integer.toString(i));
                entry.setAccelerator(KeyStroke.getKeyStroke(49 + i, mask));
                entry.setMnemonic(49 + i);
                entry.setDisabledIcon(WARLORD_ICON_DISABLED_SMALL);
                menuList.add(entry);
            }
        } else if (menuList.size() > maxSize) {
            i = menuList.size();
            while (i > maxSize) {
                menuList.remove(--i);
            }
        }
        int nbFiles = 0;
        for (int i2 = 0; i2 < menuList.size(); ++i2) {
            String filePath = i2 < files.length ? files[i2] : null;
            String name = Files.getName(filePath);
            JMenuItem item = menuList.get(i2);
            if (name != null) {
                item.setText(i2 + 1 + ". " + name);
            } else {
                item.setText(null);
            }
            if (filePath != null) {
                ++nbFiles;
            }
            item.setEnabled(Files.exists(filePath));
            item.setToolTipText(filePath);
        }
        if (target != null) {
            int lastEntry = -1;
            int firstEntry = -1;
            int lastSep = -1;
            int idx = 0;
            while (idx < target.getMenuComponentCount()) {
                Component comp = target.getMenuComponent(idx);
                if (comp instanceof JSeparator && firstEntry < 0) {
                    lastSep = idx;
                }
                if (comp instanceof AbstractButton) {
                    AbstractButton item = (AbstractButton)comp;
                    String command = item.getActionCommand();
                    if (action.equals(command)) {
                        try {
                            int fileIdx = Integer.parseInt(item.getName());
                            if (fileIdx >= maxSize) {
                                target.remove(idx);
                                continue;
                            }
                            if (item.getText() == null) {
                                target.remove(idx);
                                continue;
                            }
                            if (firstEntry < 0) {
                                firstEntry = idx;
                            }
                            lastEntry = idx++;
                        }
                        catch (Throwable exception) {}
                        continue;
                    }
                    ++idx;
                    continue;
                }
                ++idx;
            }
            if (nbFiles > 0) {
                int i3;
                if (firstEntry != -1) {
                    if (lastSep == -1) {
                        if (firstEntry == 0) {
                            lastSep = 0;
                            firstEntry = 1;
                        } else {
                            lastSep = firstEntry - 1;
                        }
                        target.insertSeparator(lastSep);
                    }
                    for (i3 = lastEntry - firstEntry + 1; i3 < nbFiles; ++i3) {
                        target.insert(menuList.get(i3), firstEntry + i3);
                    }
                } else {
                    if (lastSep == -1) {
                        target.addSeparator();
                        lastSep = target.getMenuComponentCount() - 1;
                    }
                    firstEntry = lastSep + 1;
                    for (i3 = 0; i3 < nbFiles; ++i3) {
                        target.insert(menuList.get(i3), firstEntry + i3);
                    }
                }
                lastEntry = firstEntry + nbFiles - 1;
                if (target.getMenuComponentCount() > lastEntry + 1 && !(target.getMenuComponent(lastEntry + 1) instanceof JSeparator)) {
                    target.insertSeparator(lastEntry + 1);
                }
            } else if (lastSep != -1) {
                lastEntry = target.getMenuComponentCount() - 1;
                if (lastSep < lastEntry && target.getMenuComponent(lastSep + 1) instanceof JSeparator) {
                    target.remove(lastSep + 1);
                }
                if (lastEntry == lastSep) {
                    target.remove(lastSep);
                }
            }
        }
    }

    public void showRecentFiles() {
        String current;
        ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
        int maxRecent = ((Preferences)preferences).getInt("history", 4);
        ArrayList<String> recentList = new ArrayList<String>(9);
        for (int i = 0; i < 9 && (current = ((Preferences)preferences).get(MENUITEM_RECENT + i, null)) != null; ++i) {
            recentList.add(current);
        }
        String[] recents = new String[recentList.size()];
        recentList.toArray(recents);
        WarlordEditionFrame.showRecentFiles(this.recentMenus, maxRecent, this, MENUITEM_RECENT, 8, recents, this.getJMenuBar().getMenu(0));
    }

    private JMenuBar createMenuBar() {
        JMenuBar menu = new JMenuBar();
        JMenu file = new JMenu("File");
        file.setMnemonic('F');
        JMenuItem newWar = new JMenuItem(MENUITEM_NEW, WARLORD_ICON_NEW);
        newWar.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        newWar.addActionListener(this);
        newWar.setActionCommand(MENUITEM_NEW);
        newWar.setMnemonic('N');
        JMenuItem saveWar = new JMenuItem(MENUITEM_SAVE, WARLORD_ICON_SAVE);
        saveWar.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        saveWar.addActionListener(this);
        saveWar.setActionCommand(MENUITEM_SAVE);
        saveWar.setMnemonic('S');
        JMenuItem saveAsWar = new JMenuItem(MENUITEM_SAVEAS, WARLORD_ICON_SAVEAS);
        saveAsWar.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        saveAsWar.addActionListener(this);
        saveAsWar.setActionCommand(MENUITEM_SAVEAS);
        saveAsWar.setMnemonic('S');
        JMenuItem openWar = new JMenuItem(MENUITEM_LOAD, WARLORD_ICON_LOAD);
        openWar.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        openWar.addActionListener(this);
        openWar.setActionCommand(MENUITEM_LOAD);
        openWar.setMnemonic('L');
        JMenuItem pbemImport = new JMenuItem(MENUITEM_IMPORT_PBEM, PBEM_WARLORD_IMPORT_ICON);
        pbemImport.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        pbemImport.addActionListener(this);
        pbemImport.setActionCommand(MENUITEM_IMPORT_PBEM);
        pbemImport.setMnemonic('I');
        JMenuItem pbemExport = new JMenuItem(MENUITEM_EXPORT_PBEM, PBEM_WARLORD_EXPORT_ICON);
        pbemExport.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        pbemExport.addActionListener(this);
        pbemExport.setActionCommand(MENUITEM_EXPORT_PBEM);
        pbemExport.setMnemonic('E');
        JMenuItem preMadeImport = new JMenuItem(MENUITEM_IMPORT_PREMADE, PREMADE_WARLORD_IMPORT_ICON);
        preMadeImport.setAccelerator(KeyStroke.getKeyStroke(73, 10));
        preMadeImport.addActionListener(this);
        preMadeImport.setActionCommand(MENUITEM_IMPORT_PREMADE);
        preMadeImport.setMnemonic('I');
        JMenuItem preMadeExport = new JMenuItem(MENUITEM_EXPORT_PREMADE, PREMADE_WARLORD_EXPORT_ICON);
        preMadeExport.setDisabledIcon(PREMADE_WARLORD_EXPORT_ICON_DISABLED);
        preMadeExport.setAccelerator(KeyStroke.getKeyStroke(69, 10));
        preMadeExport.addActionListener(this);
        preMadeExport.setActionCommand(MENUITEM_EXPORT_PREMADE);
        preMadeExport.setMnemonic('E');
        JMenuItem wizard = new JMenuItem(MENUITEM_WIZARD, WARLORD_WIZARD);
        wizard.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        wizard.addActionListener(this);
        wizard.setActionCommand(MENUITEM_WIZARD);
        wizard.setMnemonic('W');
        JMenuItem preferences = new JMenuItem(MENUITEM_PREFERENCES, ICON_PREFERENCES);
        preferences.setAccelerator(KeyStroke.getKeyStroke(120, 0));
        preferences.addActionListener(this);
        preferences.setActionCommand(MENUITEM_PREFERENCES);
        preferences.setMnemonic('P');
        JMenuItem exit = new JMenuItem(MENUITEM_EXIT, ICON_EXIT);
        exit.setAccelerator(KeyStroke.getKeyStroke(115, 2));
        exit.addActionListener(this);
        exit.setActionCommand(MENUITEM_EXIT);
        exit.setMnemonic('X');
        JMenu action = new JMenu("Action");
        action.setMnemonic('A');
        JMenuItem play = new JMenuItem(MENUITEM_PLAY, WARLORD_ICON_SMALL);
        play.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        play.addActionListener(this);
        play.setActionCommand(MENUITEM_PLAY);
        play.setMnemonic('P');
        JMenu forums = new JMenu(MENU_FORUMS);
        forums.setIcon(ICON_FORUMS);
        forums.setMnemonic('F');
        JMenuItem ubisoftForum = new JMenuItem("Ubisoft", ICON_FORUM_UBISOFT);
        ubisoftForum.addActionListener(this);
        ubisoftForum.setActionCommand("F@Ubisoft");
        ubisoftForum.setMnemonic('U');
        JMenuItem i2Forum = new JMenuItem("Inifinite Interactive", ICON_FORUM_INFINITE_INTERACTIVE);
        i2Forum.addActionListener(this);
        i2Forum.setActionCommand("F@Inifinite Interactive");
        i2Forum.setMnemonic('I');
        JMenuItem warlordersForum = new JMenuItem("Warlorders", ICON_FORUM_WARLORDERS);
        warlordersForum.addActionListener(this);
        warlordersForum.setActionCommand("F@Warlorders");
        warlordersForum.setMnemonic('W');
        JMenuItem battlefieldForum = new JMenuItem("The BattleField", ICON_FORUM_BATTLEFIELD);
        battlefieldForum.addActionListener(this);
        battlefieldForum.setActionCommand("F@The BattleField");
        battlefieldForum.setMnemonic('B');
        JMenu homePages = new JMenu(MENU_HOME_PAGES);
        homePages.setIcon(ICON_HOME_PAGES);
        homePages.setMnemonic('H');
        JMenuItem portailsmmHP = new JMenuItem(MENUITEM_PORTAILSMM, ICON_HOME_PAGE_PORTAILSMM);
        portailsmmHP.addActionListener(this);
        portailsmmHP.setActionCommand("HP@Warlords IV Editor");
        portailsmmHP.setMnemonic('P');
        JMenuItem ubisoftHP = new JMenuItem("Ubisoft", ICON_HOME_PAGE_UBISOFT);
        ubisoftHP.addActionListener(this);
        ubisoftHP.setActionCommand("HP@Ubisoft");
        ubisoftHP.setMnemonic('U');
        JMenuItem warlordersHP = new JMenuItem("Warlorders", ICON_HOME_PAGE_WARLORDERS);
        warlordersHP.addActionListener(this);
        warlordersHP.setActionCommand("HP@Warlorders");
        warlordersHP.setMnemonic('W');
        JMenuItem battlefieldHP = new JMenuItem("The BattleField", ICON_HOME_PAGE_BATTLEFIELD);
        battlefieldHP.addActionListener(this);
        battlefieldHP.setActionCommand("HP@The BattleField");
        battlefieldHP.setMnemonic('B');
        JMenuItem i2HP = new JMenuItem("Inifinite Interactive", ICON_HOME_PAGE_INFINITE_INTERACTIVE);
        i2HP.addActionListener(this);
        i2HP.setActionCommand("HP@Inifinite Interactive");
        i2HP.setMnemonic('I');
        JMenuItem nivisecHP = new JMenuItem(MENUITEM_NIVISEC, ICON_HOME_PAGE_NIVISEC);
        nivisecHP.addActionListener(this);
        nivisecHP.setActionCommand("HP@Nivisec's Warlords IV");
        nivisecHP.setMnemonic('N');
        JMenu help = new JMenu("Help");
        help.setMnemonic('H');
        JMenuItem helpTopics = new JMenuItem(MENUITEM_HELP, ICON_HELP);
        helpTopics.setAccelerator(KeyStroke.getKeyStroke(112, 2));
        helpTopics.addActionListener(this);
        helpTopics.setActionCommand(MENUITEM_HELP);
        helpTopics.setMnemonic('e');
        JMenu online = new JMenu("Online Help");
        online.setIcon(ICON_ONLINE);
        online.setMnemonic('L');
        JMenuItem homePage = new JMenuItem(MENUITEM_HOMEPAGE, ICON_HOMEPAGE);
        homePage.addActionListener(this);
        homePage.setActionCommand(MENUITEM_HOMEPAGE);
        homePage.setMnemonic('W');
        JMenuItem onlineHelp = new JMenuItem("Online Help", ICON_ONLINE_HELP);
        onlineHelp.addActionListener(this);
        onlineHelp.setActionCommand("Online Help");
        onlineHelp.setMnemonic('H');
        JMenuItem updates = new JMenuItem(MENUITEM_UPDATES, ICON_UPDATES);
        updates.addActionListener(this);
        updates.setActionCommand(MENUITEM_UPDATES);
        updates.setMnemonic('U');
        JMenuItem emailSupport = new JMenuItem(MENUITEM_EMAIL_SUPPORT, ICON_EMAIL_SUPPORT);
        emailSupport.addActionListener(this);
        emailSupport.setActionCommand(MENUITEM_EMAIL_SUPPORT);
        emailSupport.setMnemonic('E');
        JMenuItem about = new JMenuItem(MENUITEM_ABOUT, ICON_ABOUT);
        about.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        about.addActionListener(this);
        about.setActionCommand(MENUITEM_ABOUT);
        about.setMnemonic('A');
        ApplicationPreferences prefers = ApplicationPreferences.getDefaultPreferences();
        String extendedKey = ((Preferences)prefers).get("extended", "looser!");
        boolean extended = extendedKey.hashCode() == 146731693;
        file.add(newWar);
        file.add(openWar);
        file.add(saveWar);
        file.add(saveAsWar);
        file.addSeparator();
        file.add(pbemImport);
        file.add(pbemExport);
        file.add(preMadeImport);
        if (extended) {
            file.add(preMadeExport);
        }
        file.addSeparator();
        file.add(wizard);
        file.add(preferences);
        file.addSeparator();
        file.add(exit);
        action.add(play);
        action.addSeparator();
        action.add(battlefieldForum);
        action.add(forums);
        forums.add(warlordersForum);
        forums.add(i2Forum);
        forums.add(ubisoftForum);
        forums.add(battlefieldForum);
        action.add(homePages);
        homePages.add(portailsmmHP);
        homePages.add(i2HP);
        homePages.add(warlordersHP);
        homePages.add(ubisoftHP);
        homePages.add(battlefieldHP);
        homePages.add(nivisecHP);
        help.add(helpTopics);
        help.add(online);
        online.add(homePage);
        online.add(onlineHelp);
        online.add(updates);
        online.add(emailSupport);
        help.addSeparator();
        help.add(about);
        menu.add(file);
        menu.add(action);
        menu.add(help);
        return menu;
    }

    private void exit(boolean exit) {
        ExitDialog dialog;
        if (this.changed && (dialog = new ExitDialog(this)).showDialog() == 16) {
            this.save();
        }
        if (!ApplicationPreferences.getDefaultPreferences().save()) {
            MessageDialog messageDialog = new MessageDialog(this, "Save Error", true, 4, 8);
            messageDialog.setIcon(WARLORD_ICON_BIG);
            messageDialog.setMessage("<div style=\"font-size: 18;text-align: center;font-weight: bold;\">Warlords IV - Warlord & Retinues Editor 2.54</div><br>Impossible to save configuration file:<br />Warlords4Editor.ini");
            messageDialog.pack();
            messageDialog.setLocationRelativeTo(this);
            messageDialog.showDialog();
            messageDialog.dispose();
        }
        this.setVisible(false);
        this.dispose();
        if (exit) {
            System.exit(0);
        }
    }

    private void about() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(this);
        }
        this.aboutDialog.setVisible(true);
    }

    private void save() {
        ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
        String filename = ((Preferences)preferences).get("entry0", null);
        this.apply();
        if (filename == null || this.isNew) {
            File systemBase;
            File base;
            String basePath = ((Preferences)preferences).get("gameRoot", ApplicationPreferences.DEFAULT_GAME_ROOT);
            File file = base = basePath == null ? null : new File(basePath);
            if (base != null && base.exists()) {
                File warlordsBase = new File(basePath, WARLORDS_FOLDER);
                if (warlordsBase.exists()) {
                    base = warlordsBase;
                }
            } else {
                base = null;
            }
            if (base == null && !(base = new File(systemBase = new File(Files.getSystemBase()), WARLORDS_FOLDER)).exists()) {
                base = systemBase;
            }
            Warlord warlord = this.getWarlord();
            filename = null;
            if (warlord.getName() != null && warlord.getName().length() > 0) {
                filename = base.toString() + File.separatorChar + warlord.getName().replace(' ', '_') + '.' + "war";
            }
            if (filename != null) {
                filename = new File(filename).getAbsolutePath();
            }
        }
        if (filename == null) {
            this.saveAs();
        } else {
            this.save(filename);
        }
    }

    private void save(String path) {
        ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
        boolean backup = ((Preferences)preferences).getBoolean("backup", false);
        if (WarlordFactory.save(path, this.getWarlord(), backup)) {
            this.isNew = false;
            this.changed = false;
            this.setRecentFile(path);
            this.setMenuValues();
        } else {
            MessageDialog messageDialog = new MessageDialog(this, "Save Error", true, 4, 8);
            messageDialog.setIcon(WARLORD_ICON_BIG);
            messageDialog.setMessage("<div style=\"font-size: 18;text-align: center;font-weight: bold;\">Warlords IV - Warlord & Retinues Editor 2.54</div><br>Impossible to save Warlord file:<br />" + path);
            messageDialog.pack();
            messageDialog.setLocationRelativeTo(this);
            messageDialog.showDialog();
            messageDialog.dispose();
        }
    }

    private void saveAs() {
        File systemBase;
        File base;
        ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
        String basePath = ((Preferences)preferences).get("gameRoot", ApplicationPreferences.DEFAULT_GAME_ROOT);
        File file = base = basePath == null ? null : new File(basePath);
        if (base != null && base.exists()) {
            File warlordsBase = new File(basePath, WARLORDS_FOLDER);
            if (warlordsBase.exists()) {
                base = warlordsBase;
            }
        } else {
            base = null;
        }
        if (base == null && !(base = new File(systemBase = new File(Files.getSystemBase()), WARLORDS_FOLDER)).exists()) {
            base = systemBase;
        }
        this.apply();
        Warlord warlord = this.getWarlord();
        File file2 = null;
        if (warlord.getName() != null && warlord.getName().length() > 0) {
            String recent = ((Preferences)preferences).get("entry0", null);
            String name = warlord.getName().replace(' ', '_') + '.' + "war";
            file2 = recent != null && recent.endsWith(name) ? new File(recent) : new File(base, name);
            file2 = file2.getAbsoluteFile();
        }
        this.chooser.setSelectedFile(null);
        this.chooser.setCurrentDirectory(base);
        if (file2 != null) {
            this.chooser.setSelectedFile(file2);
        }
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.resetChoosableFileFilters();
        this.chooser.addChoosableFileFilter(Warlord.DEFAULT_FILTER);
        this.chooser.setFileSelectionMode(0);
        if (this.chooser.showDialog(1) == 0) {
            this.save(Files.setExtension(this.chooser.getSelectedFile().getAbsolutePath(), "war", true));
        }
    }

    private boolean load(String filename) {
        boolean ok = false;
        if (filename != null) {
            Warlord warlord = WarlordFactory.load(filename);
            if (warlord != null) {
                this.setRecentFile(filename);
                this.setWarlord(warlord);
                this.isNew = false;
                ok = true;
            } else {
                MessageDialog messageDialog = new MessageDialog(this, "Load Error", true, 4, 8);
                messageDialog.setIcon(WARLORD_ICON_BIG);
                messageDialog.setMessage("<div style=\"font-size: 18;text-align: center;font-weight: bold;\">Warlords IV - Warlord & Retinues Editor 2.54</div><br>Impossible to load Warlord file:<br />" + filename);
                messageDialog.pack();
                messageDialog.setLocationRelativeTo(this);
                messageDialog.showDialog();
                messageDialog.dispose();
            }
        }
        return ok;
    }

    private void load() {
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.resetChoosableFileFilters();
        this.chooser.addChoosableFileFilter(Warlord.DEFAULT_FILTER);
        this.chooser.setFileSelectionMode(0);
        ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
        String recent = ((Preferences)preferences).get("entry0", null);
        if (recent != null) {
            this.chooser.setSelectedFile(new File(recent));
        } else {
            File systemBase;
            File base;
            String basePath = ((Preferences)preferences).get("gameRoot", ApplicationPreferences.DEFAULT_GAME_ROOT);
            File file = base = basePath == null ? null : new File(basePath);
            if (base != null && base.exists()) {
                File warlordsBase = new File(basePath, WARLORDS_FOLDER);
                if (warlordsBase.exists()) {
                    base = warlordsBase;
                }
            } else {
                base = null;
            }
            if (base == null && !(base = new File(systemBase = new File(Files.getSystemBase()), WARLORDS_FOLDER)).exists()) {
                base = systemBase;
            }
            this.chooser.setSelectedFile(base);
            this.chooser.setCurrentDirectory(base);
        }
        if (this.chooser.showDialog(0) == 0) {
            this.load(this.chooser.getSelectedFile().toString());
        }
    }

    private void newWarlord() {
        this.setWarlord(new Warlord());
        this.isNew = true;
    }

    private void wizard() {
        if (this.wizardDialog == null) {
            this.wizardDialog = new WarlordWizardDialog(this);
        }
        this.wizardDialog.loadWarlord(this.getWarlord());
        this.wizardDialog.setVisible(true);
        Warlord warlord = this.wizardDialog.getWarlord();
        if (warlord != null) {
            this.setWarlord(warlord);
            this.isNew = true;
        }
    }

    private void importPBEM() {
        PBEMWarlord warlord;
        File systemBase;
        File base;
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.resetChoosableFileFilters();
        this.chooser.addChoosableFileFilter(PBEMWarlord.DEFAULT_FILTER);
        this.chooser.setFileSelectionMode(0);
        ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
        String basePath = ((Preferences)preferences).get("gameRoot", ApplicationPreferences.DEFAULT_GAME_ROOT);
        File file = base = basePath == null ? null : new File(basePath);
        if (base != null && base.exists()) {
            File pbemWarlordsBase = new File(basePath, PBEM_WARLORDS_FOLDER);
            if (pbemWarlordsBase.exists()) {
                base = pbemWarlordsBase;
            }
        } else {
            base = null;
        }
        if (base == null && !(base = new File(systemBase = new File(Files.getSystemBase()), PBEM_WARLORDS_FOLDER)).exists()) {
            base = systemBase;
        }
        this.chooser.setCurrentDirectory(base);
        if (this.chooser.showDialog(0) == 0 && (warlord = WarlordFactory.loadPBEM(this.chooser.getSelectedFile().toString())) != null) {
            if (this.pbemDialog == null) {
                this.pbemDialog = new PBEMWarlordEditionDialog(this);
            }
            this.pbemDialog.setMode(true);
            this.pbemDialog.setWarlord(warlord);
            this.pbemDialog.load();
            if (this.pbemDialog.showDialog()) {
                this.setWarlord(warlord.getWarlord());
                this.isNew = false;
            }
        }
    }

    private void exportPBEM() {
        if (this.pbemDialog == null) {
            this.pbemDialog = new PBEMWarlordEditionDialog(this);
        }
        this.pbemDialog.setMode(false);
        PBEMWarlord warlord = this.pbemDialog.getWarlord();
        if (warlord == null) {
            warlord = new PBEMWarlord();
        }
        this.apply();
        warlord.setWarlord(this.getWarlord());
        this.pbemDialog.setWarlord(warlord);
        this.pbemDialog.load();
        if (this.pbemDialog.showDialog()) {
            File systemBase;
            File base;
            this.pbemDialog.save();
            this.chooser.setAcceptAllFileFilterUsed(false);
            this.chooser.resetChoosableFileFilters();
            this.chooser.addChoosableFileFilter(PBEMWarlord.DEFAULT_FILTER);
            this.chooser.setFileSelectionMode(0);
            ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
            String basePath = ((Preferences)preferences).get("gameRoot", ApplicationPreferences.DEFAULT_GAME_ROOT);
            File file = base = basePath == null ? null : new File(basePath);
            if (base != null && base.exists()) {
                File pbemWarlordsBase = new File(basePath, PBEM_WARLORDS_FOLDER);
                if (pbemWarlordsBase.exists()) {
                    base = pbemWarlordsBase;
                }
            } else {
                base = null;
            }
            if (base == null && !(base = new File(systemBase = new File(Files.getSystemBase()), PBEM_WARLORDS_FOLDER)).exists()) {
                base = systemBase;
            }
            this.chooser.setCurrentDirectory(base);
            if (this.chooser.showDialog(1) == 0) {
                WarlordFactory.savePBEM(this.chooser.getSelectedFile().toString(), warlord);
            }
        }
    }

    private void importPreMade() {
        Warlord warlord;
        File systemBase;
        File base;
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.resetChoosableFileFilters();
        this.chooser.addChoosableFileFilter(Warlord.DEFAULT_FILTER);
        this.chooser.setFileSelectionMode(0);
        ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
        String basePath = ((Preferences)preferences).get("gameRoot", ApplicationPreferences.DEFAULT_GAME_ROOT);
        File file = base = basePath == null ? null : new File(basePath);
        if (base != null && base.exists()) {
            File preMadeWarlordsBase = new File(basePath, PREMADE_WARLORDS_FOLDER);
            if (preMadeWarlordsBase.exists()) {
                base = preMadeWarlordsBase;
            }
        } else {
            base = null;
        }
        if (base == null && !(base = new File(systemBase = new File(Files.getSystemBase()), PREMADE_WARLORDS_FOLDER)).exists()) {
            base = systemBase;
        }
        this.chooser.setCurrentDirectory(base);
        if (this.chooser.showDialog(0) == 0 && (warlord = WarlordFactory.loadPreMade(this.chooser.getSelectedFile().toString())) != null) {
            this.setWarlord(warlord);
            this.isNew = false;
        }
    }

    private void exportPreMade() {
        File systemBase;
        File base;
        this.apply();
        Warlord warlord = this.getWarlord();
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.resetChoosableFileFilters();
        this.chooser.addChoosableFileFilter(Warlord.DEFAULT_FILTER);
        this.chooser.setFileSelectionMode(0);
        ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
        String basePath = ((Preferences)preferences).get("gameRoot", ApplicationPreferences.DEFAULT_GAME_ROOT);
        File file = base = basePath == null ? null : new File(basePath);
        if (base != null && base.exists()) {
            File preMadeWarlordsBase = new File(basePath, PREMADE_WARLORDS_FOLDER);
            if (preMadeWarlordsBase.exists()) {
                base = preMadeWarlordsBase;
            }
        } else {
            base = null;
        }
        if (base == null && !(base = new File(systemBase = new File(Files.getSystemBase()), PREMADE_WARLORDS_FOLDER)).exists()) {
            base = systemBase;
        }
        this.chooser.setCurrentDirectory(base);
        if (this.chooser.showDialog(1) == 0) {
            WarlordFactory.savePreMade(this.chooser.getSelectedFile().toString(), warlord);
        }
    }

    private void play() {
        ExitDialog dialog;
        if (this.changed && (dialog = new ExitDialog(this)).showDialog() == 16) {
            this.save();
        }
        try {
            ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
            String basePath = ((Preferences)preferences).get("gameRoot", ApplicationPreferences.DEFAULT_GAME_ROOT);
            if (basePath != null && basePath.charAt(basePath.length() - 1) != File.separatorChar) {
                basePath = basePath + File.separatorChar;
            } else if (basePath == null) {
                basePath = "";
            }
            String executable = basePath + "Warlords4";
            String[] params = new String[]{executable};
            Runtime.getRuntime().exec(params);
        }
        catch (Throwable exception) {
            MessageDialog messageDialog = new MessageDialog(this, "Launch Error", true, 4, 8);
            messageDialog.setIcon(WARLORD_ICON_BIG);
            messageDialog.setMessage("<div style=\"font-size: 18;text-align: center;font-weight: bold;\">Warlords IV - Warlord & Retinues Editor 2.54</div><br>Impossible to launch the game!<br>Check your game root path in the preferences.");
            messageDialog.pack();
            messageDialog.setLocationRelativeTo(this);
            messageDialog.showDialog();
            messageDialog.dispose();
        }
    }

    private void preferences() {
        if (this.preferencesDialog == null) {
            this.preferencesDialog = new PreferencesDialog(this);
            this.preferencesDialog.setPreferences(ApplicationPreferences.getDefaultPreferences());
        }
        if (!this.preferencesDialog.isVisible()) {
            this.preferencesDialog.reset();
            this.preferencesDialog.setVisible(true);
        }
    }

    private void update(boolean mute) {
        ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
        boolean proxyUsed = ((Preferences)preferences).getBoolean("proxyUsed", false);
        Properties properties = System.getProperties();
        if (proxyUsed) {
            String proxyHost = ((Preferences)preferences).get("proxyHost", ApplicationPreferences.DEFAULT_PROXY_HOST);
            int proxyPort = ((Preferences)preferences).getInt("proxyPort", ApplicationPreferences.DEFAULT_PROXY_PORT);
            properties.setProperty("http.proxyHost", proxyHost.trim());
            properties.setProperty("http.proxyPort", String.valueOf(proxyPort));
        } else {
            properties.remove("http.proxyHost");
            properties.remove("http.proxyPort");
        }
        float version = Version.VERSION_NUMBER;
        String versionStr = "2.54";
        InputStream input = StreamUtil.getInputStream(EDITOR_VERSION_URL);
        if (input != null) {
            try {
                versionStr = new String(StreamUtil.toByteArray(input));
                version = Float.parseFloat(versionStr);
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        if (Version.VERSION_NUMBER < version) {
            boolean done;
            MessageDialog messageDialog = new MessageDialog(this, "Update Message", true, 4, 20);
            messageDialog.setIcon(WARLORD_ICON_BIG);
            messageDialog.setMessage("<div style=\"font-size: 18;text-align: center;font-weight: bold;\">Warlords IV - Warlord & Retinues Editor 2.54</div><br>A new editor is available on the server. Download the editor version <b style=\"color:red;\">" + versionStr + "</b>?");
            messageDialog.pack();
            messageDialog.setLocationRelativeTo(this);
            int returnValue = messageDialog.showDialog();
            messageDialog.dispose();
            if (returnValue != 16) {
                return;
            }
            String tempFolder = null;
            try {
                File temp = new File("W4EUpdate");
                tempFolder = temp.getAbsolutePath();
                if (!Files.mkdirs(tempFolder) && !temp.exists()) {
                    throw new Exception(tempFolder);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MessageDialog errorDialog = new MessageDialog(this, "Update Error", true, 4, 8);
                errorDialog.setMessage("<div style=\"font-size: 18;text-align: center;font-weight: bold;\">Warlords IV - Warlord & Retinues Editor 2.54</div><br>Impossible to update this editor! The current editor cannot access<br>the hard disk to create a download folder.<br><br>Ensure you have the right permissions before launching an update!");
                errorDialog.pack();
                errorDialog.setLocationRelativeTo(this);
                errorDialog.showDialog();
                errorDialog.dispose();
                return;
            }
            String localResource = tempFolder + File.separator + EDITOR_ZIP_FILE;
            UpdateManager manager = new UpdateManager(this, versionStr);
            manager.download("http://www.portailsmm.com/warlords4/data/Warlords4Editor.zip", localResource);
            boolean bl = done = manager.getReturnValue() == 8;
            if (done) {
                MessageDialog warningDialog = new MessageDialog(this, "Update...", true, 2, 8);
                warningDialog.setMessage("<div style=\"font-size: 18;text-align: center;font-weight: bold;\">Warlords IV - Warlord & Retinues Editor " + versionStr + "</div><br>" + "<b>Download completed</b>!<br><br>" + "To terminate the installation, the editor must restart.");
                warningDialog.pack();
                warningDialog.setLocationRelativeTo(this);
                warningDialog.showDialog();
                warningDialog.dispose();
                this.exit(false);
                try {
                    File synchronize = new File(LOCK_FILE);
                    synchronize.deleteOnExit();
                    new FileOutputStream(synchronize).close();
                    String[] params = new String[]{"java", "-cp", '\"' + tempFolder + '\"', "Updater", tempFolder, LOCK_FILE};
                    Runtime.getRuntime().exec(params);
                }
                catch (Throwable exception) {
                    exception.printStackTrace();
                }
                this.exit(true);
            } else {
                File temp = new File(tempFolder);
                File[] list = temp.listFiles();
                for (int i = 0; i < list.length; ++i) {
                    if (!list[i].delete()) continue;
                    System.err.println("File \"" + list[i] + "\" cannot be deleted!");
                }
                if (temp.delete()) {
                    System.err.println("Folder \"" + temp + "\" cannot be deleted!");
                }
            }
        } else if (!mute) {
            MessageDialog dialog = new MessageDialog(this, "Update", true, 2, 8);
            dialog.setMessage("<div style=\"font-size: 18;text-align: center;font-weight: bold;\">Warlords IV - Warlord & Retinues Editor 2.54</div><br>There is no new version available on the server.</div>");
            dialog.pack();
            dialog.setLocationRelativeTo(this);
            dialog.showDialog();
            dialog.dispose();
        }
    }

    private void setMenuValues() {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action == null) {
            return;
        }
        if (MENUITEM_EXIT.equals(action)) {
            this.exit(true);
        } else if (MENUITEM_ABOUT.equals(action)) {
            this.about();
        } else if (MENUITEM_HELP.equals(action)) {
            HelpKeyEventDispatcher.showHelp(this);
        } else if (MENUITEM_PREFERENCES.equals(action)) {
            this.preferences();
        } else if (MENUITEM_PLAY.equals(action)) {
            this.play();
        } else if (MENUITEM_NEW.equals(action)) {
            this.newWarlord();
        } else if (MENUITEM_SAVE.equals(action)) {
            this.save();
        } else if (MENUITEM_LOAD.equals(action)) {
            this.load();
        } else if (MENUITEM_SAVEAS.equals(action)) {
            this.saveAs();
        } else if (MENUITEM_WIZARD.equals(action)) {
            this.wizard();
        } else if (MENUITEM_EXPORT_PBEM.equals(action)) {
            this.exportPBEM();
        } else if (MENUITEM_IMPORT_PBEM.equals(action)) {
            this.importPBEM();
        } else if (MENUITEM_EXPORT_PREMADE.equals(action)) {
            this.exportPreMade();
        } else if (MENUITEM_IMPORT_PREMADE.equals(action)) {
            this.importPreMade();
        } else if (MENUITEM_RECENT.equals(action)) {
            try {
                ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
                int target = Integer.parseInt(((Component)event.getSource()).getName());
                String recent = ((Preferences)preferences).get(MENUITEM_RECENT + target, null);
                this.load(recent);
            }
            catch (Throwable exception) {}
        } else if ("arp:Apply".equals(action)) {
            this.apply();
        } else if ("arp:Reset".equals(action)) {
            this.reset();
        } else if ("arp:Close".equals(action)) {
            this.exit(true);
        } else if (MENUITEM_HOMEPAGE.equals(action)) {
            this.showHelpTopic(HOMEPAGE_URL);
        } else if ("Online Help".equals(action)) {
            this.showHelpTopic(ONLINE_HELP_URL);
        } else if (MENUITEM_UPDATES.equals(action)) {
            this.update(false);
        } else if (MENUITEM_EMAIL_SUPPORT.equals(action)) {
            this.showHelpTopic(EMAIL_URL);
        } else if (action.startsWith(FORUM_TAG)) {
            String forum = action.substring(FORUM_TAG.length());
            if ("Ubisoft".equals(forum)) {
                this.showHelpTopic(UBISOFT_FORUM_URL);
            } else if ("The BattleField".equals(forum)) {
                this.showHelpTopic(BATTLEFIELD_FORUM_URL);
            } else if ("Warlorders".equals(forum)) {
                this.showHelpTopic(WARLORDERS_FORUM_URL);
            } else if ("Inifinite Interactive".equals(forum)) {
                this.showHelpTopic(INFINITE_INTERACTIVE_FORUM_URL);
            }
        } else if (action.startsWith(HOME_PAGE_TAG)) {
            String hp = action.substring(HOME_PAGE_TAG.length());
            if (MENUITEM_PORTAILSMM.equals(hp)) {
                this.showHelpTopic(PORTAILSMM_URL);
            } else if ("Ubisoft".equals(hp)) {
                this.showHelpTopic(UBISOFT_URL);
            } else if ("Warlorders".equals(hp)) {
                this.showHelpTopic(WARLORDERS_URL);
            } else if ("The BattleField".equals(hp)) {
                this.showHelpTopic(BATTLEFIELD_URL);
            } else if ("Inifinite Interactive".equals(hp)) {
                this.showHelpTopic(INFINITE_INTERACTIVE_URL);
            } else if (MENUITEM_NIVISEC.equals(hp)) {
                this.showHelpTopic(NIVISEC_URL);
            }
        }
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
        this.exit(true);
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.changed = true;
        this.setMenuValues();
    }

    @Override
    public void showHelpTopic(String topic) {
        ApplicationPreferences preferences = ApplicationPreferences.getDefaultPreferences();
        try {
            String helpTarget = ONLINE_HELP_URL;
            if (((Preferences)preferences).getBoolean("localHelp", true)) {
                helpTarget = DEFAULT_HELP_FILENAME;
            }
            if (topic == null) {
                topic = helpTarget;
            }
            if (topic.indexOf(58) <= 1) {
                topic = helpTarget + '#' + topic;
            }
            BrowserLauncher.openURL(topic);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

