/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.gui.MessageDialog;
import com.softlabs.warlords4.gui.WarlordEditionFrame;
import com.softlabs.warlords4.util.Files;
import com.softlabs.warlords4.util.StreamUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class UpdateManager
extends MessageDialog {
    JProgressBar progress;
    private JLabel progressMessage;

    public UpdateManager(JFrame owner, String version) {
        super(owner, "Update Manager", true, 0, 2);
        this.setIcon(WarlordEditionFrame.WARLORD_ICON_BIG);
        this.setMessage("<div style=\"font-size: 18;text-align: center;font-weight: bold;\">Warlords IV - Warlord & Retinues Editor 2.54</div><br>Upgrade editor to version <b style=\"color:red;\">" + version + "</b>.<br><br>" + "This might take a couple of minutes depending on your Internet connection.<br>" + "To abort the update, press \"Cancel\".");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.insets.top = 5;
        JComponent root = (JComponent)this.getContentPane();
        this.progressMessage = new JLabel("Download new editor...");
        this.progressMessage.setFont(this.progressMessage.getFont().deriveFont(1));
        constraints.gridx = 0;
        constraints.gridy = 1;
        root.add((Component)this.progressMessage, constraints);
        this.progress = new JProgressBar();
        this.progress.setStringPainted(true);
        constraints.gridy = 2;
        root.add((Component)this.progress, constraints);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public void setProgressionMessage(String message) {
        this.progressMessage.setText(message);
    }

    public void setMaximum(int max) {
        this.progress.setMaximum(max);
    }

    public void download(String source, String destination) {
        new Downloader(source, destination);
        this.setVisible(true);
    }

    private class Downloader
    implements Runnable {
        private String source;
        private String destination;

        public Downloader(String source, String destination) {
            this.source = source;
            this.destination = destination;
            Thread thread = new Thread((Runnable)this, "Downloader");
            thread.setPriority(1);
            thread.start();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                URL resourceUrl = new URL(this.source);
                URLConnection resourceConnection = resourceUrl.openConnection();
                InputStream resource = resourceConnection.getInputStream();
                OutputStream data = StreamUtil.getOutputStream(this.destination, false);
                UpdateManager.this.setMaximum(resourceConnection.getContentLength());
                UpdateManager.this.progress.setValue(0);
                boolean ok = this.download(resource, data);
                resource.close();
                data.close();
                if (ok) {
                    UpdateManager.this.setProgressionMessage("Deploy new editor...");
                    ZipFile zipFile = new ZipFile(this.destination);
                    String localFolder = Files.getPath(this.destination);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        InputStream source = zipFile.getInputStream(entry);
                        OutputStream destination = StreamUtil.getOutputStream(localFolder + File.separator + entry.getName(), false);
                        UpdateManager.this.setMaximum(source.available());
                        UpdateManager.this.progress.setValue(0);
                        ok &= this.download(source, destination);
                        source.close();
                        destination.close();
                    }
                    zipFile.close();
                    File destination = new File(this.destination);
                    ok &= destination.delete();
                    InputStream source = StreamUtil.getInputStream("com/softlabs/warlords4/rsc/Updater.class");
                    OutputStream updater = StreamUtil.getOutputStream(localFolder + File.separator + "Updater.class", false);
                    UpdateManager.this.setMaximum(source.available());
                    UpdateManager.this.progress.setValue(0);
                    ok &= this.download(source, updater);
                    source.close();
                    updater.close();
                }
                if (ok) {
                    UpdateManager.this.setReturnValue(8);
                    UpdateManager.this.setVisible(false);
                }
            }
            catch (Throwable exception) {
                UpdateManager.this.setVisible(false);
                MessageDialog errorDialog = new MessageDialog(UpdateManager.this, "Update Error", true, 4, 8);
                errorDialog.setMessage("Download of the new editor impossible!<br>Check your Internet connection.");
                errorDialog.pack();
                errorDialog.setLocationRelativeTo(UpdateManager.this);
                errorDialog.showDialog();
                errorDialog.dispose();
            }
        }

        private boolean download(InputStream source, OutputStream destination) {
            boolean terminate = false;
            byte[] buffer = new byte[32768];
            int total = 0;
            while (!terminate && UpdateManager.this.isVisible()) {
                try {
                    int read = source.read(buffer);
                    if (read == -1) {
                        terminate = true;
                        continue;
                    }
                    destination.write(buffer, 0, read);
                    UpdateManager.this.progress.setValue(total += read);
                }
                catch (Throwable exception) {}
            }
            return terminate;
        }
    }
}

