/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class UniversalSeparator
extends JPanel {
    public static final int STYLE_EMPTY = 0;
    public static final int STYLE_HORIZONTAL = 1;
    public static final int STYLE_VERTICAL = 2;
    public static final int STYLE_CROSS = 3;
    private int style = 0;

    public UniversalSeparator() {
        this(1);
    }

    public UniversalSeparator(int style) {
        this.setStyle(style);
        this.setOpaque(false);
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isHorizontal() {
        return (this.style & 1) != 0;
    }

    public boolean isVertical() {
        return (this.style & 2) != 0;
    }

    public boolean isCrossed() {
        return this.isHorizontal() && this.isVertical();
    }

    public void setStyle(int style) {
        this.style = style;
    }

    @Override
    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        Color col = this.getBackground();
        Color dark = col.darker().darker();
        Color bright = col.brighter().brighter();
        int x = dim.width / 2;
        int y = dim.height / 2;
        if (this.isHorizontal()) {
            g.setColor(dark);
            g.drawLine(0, y - 1, dim.width, y - 1);
            g.setColor(bright);
            g.drawLine(0, y, dim.width, y);
        }
        if (this.isVertical()) {
            g.setColor(dark);
            g.drawLine(x - 1, 0, x - 1, dim.height);
            g.setColor(bright);
            g.drawLine(x, 0, x, dim.height);
        }
        if (this.isCrossed()) {
            g.setColor(col);
            g.drawLine(x - 1, y, x, y - 1);
        }
    }
}

