/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.data.Ability;
import com.softlabs.warlords4.data.HeroNameGenerator;
import com.softlabs.warlords4.data.Item;
import com.softlabs.warlords4.data.LabeledIcon;
import com.softlabs.warlords4.data.LimitedPlainDocument;
import com.softlabs.warlords4.data.Unit;
import com.softlabs.warlords4.data.UnitNameGenerator;
import com.softlabs.warlords4.gui.Filler;
import com.softlabs.warlords4.gui.GenericListCellRenderer;
import com.softlabs.warlords4.gui.SequenceButtonPanel;
import com.softlabs.warlords4.gui.UnitEditionPanel;
import com.softlabs.warlords4.gui.UniversalSeparator;
import com.softlabs.warlords4.gui.WizardTitle;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class UnitWizardPanel
extends JPanel
implements ActionListener,
DocumentListener {
    public static final String TITLE = "Unit Creation Wizard";
    private static final String MAIN_PANEL = "Main";
    private static final String ABILITIES_PANEL = "Abilities";
    private static final String ITEMS_PANEL = "Items";
    private static final String[] LEVEL_XP_LABELS = new String[]{"Level:", "Experience:"};
    private static final int[][][] CLASS_MAJOR_ABILITY = new int[][][]{new int[][]{{10, 1, 1}, {1, 1, 1}, {32, 1, 1}, {31, 1, 1}, {4, 1, 1}, {22, 1, 1}}, new int[][]{{17, 1, 1}, {1, 1, 1}, {34, 2, 1}, {31, 1, 1}, {25, 1, 1}, {22, 1, 1}}, new int[][]{{26, 1, 1}, {1, 1, 1}, {7, 1, 1}, {31, 1, 1}, {38, 1, 1}, {22, 1, 1}}, new int[][]{{30, 1, 1}, {28, 1, 1}, {5, 1, 1}, {31, 1, 1}, {7, 1, 1}, {15, 1, 1}}, new int[][]{{35, 1, 1}, {5, 1, 1}, {11, 1, 1}, {31, 1, 1}, {27, 1, 3}, {15, 1, 1}}, new int[][]{{21, 1, 1}, {9, 1, 1}, {33, 1, 1}, {31, 1, 1}, {8, 1, 3}, {15, 1, 1}}, new int[][]{{27, 1, 1}, {3, 1, 1}, {25, 1, 1}, {31, 1, 1}, {36, 1, 1}, {15, 1, 1}}, new int[][]{{35, 1, 1}, {37, 1, 1}, {16, 1, 1}, {31, 1, 1}, {24, 1, 1}, {15, 1, 1}}, new int[][]{{17, 1, 1}, {11, 1, 3}, {36, 1, 3}, {31, 1, 1}, {16, 1, 3}, {22, 1, 1}}, new int[][]{{1, 1, 1}, {13, 1, 1}, {34, 2, 1}, {19, 1, 1}, {38, 1, 1}, {22, 1, 1}}};
    private static final int[][][] CLASS_MINOR_ABILITIES = new int[][][]{new int[][]{{30}, {17}, {34}, new int[0], {19}, {2, 4, 66, 19, 32}}, new int[][]{{2}, new int[0], {59}, new int[0], {30}, {2, 3, 66, 30, 1}}, new int[][]{{6}, {20}, {2}, new int[0], {7}, {2, 6, 66, 31, 38}}, new int[][]{{37}, {11}, {12}, new int[0], {36}, {5, 7, 66, 27, 36}}, new int[][]{{13}, {41}, {34}, new int[0], new int[0], {5, 8, 11, 66, 38}}, new int[][]{{38}, {23}, {3}, new int[0], new int[0], {3, 8, 66, 36, 37}}, new int[][]{{14}, {17}, {34}, {1}, {29}, {3, 8, 25, 35, 36}}, new int[][]{{29}, {21}, {35}, new int[0], {27}, {9, 16, 28, 36, 38}}, new int[][]{{18}, new int[0], new int[0], {16}, new int[0], {66, 16, 17, 19, 38}}, new int[][]{{30}, {23}, new int[0], {32}, {31}, {1, 19, 23, 66, 30}}};
    private static final int[][][] CLASS_SPECS = new int[][][]{new int[][]{{5, 10, 2, 3}, {4, 9, 4, 2}, {8, 16, 8, 5}, {3, 15, 12, 0}, {11, 20, 20, 5}, {10, 18, 0, 0}}, new int[][]{{4, 10, 2, 3}, {5, 7, 4, 2}, {7, 15, 8, 0}, {2, 16, 12, 0}, {10, 19, 16, 5}, {8, 20, 0, 0}}, new int[][]{{5, 13, 2, 2}, {5, 12, 4, 2}, {6, 22, 12, 5}, {5, 16, 10, 0}, {7, 30, 16, 5}, {8, 24, 0, 0}}, new int[][]{{4, 8, 2, 3}, {6, 10, 6, 5}, {9, 18, 12, 5}, {8, 20, 14, 0}, {11, 21, 20, 3}, {10, 22, 0, 0}}, new int[][]{{4, 9, 1, 2}, {6, 12, 3, 2}, {8, 15, 5, 3}, {4, 16, 8, 0}, {10, 20, 20, 0}, {9, 20, 0, 0}}, new int[][]{{5, 9, 2, 2}, {5, 13, 4, 5}, {9, 14, 8, 5}, {3, 10, 12, 0}, {12, 21, 20, 0}, {8, 23, 0, 0}}, new int[][]{{5, 9, 1, 2}, {6, 11, 3, 3}, {8, 15, 10, 3}, {4, 12, 8, 2}, {9, 19, 16, 5}, {8, 20, 0, 0}}, new int[][]{{4, 8, 2, 3}, {5, 9, 4, 3}, {6, 19, 8, 5}, {5, 11, 12, 0}, {9, 23, 20, 5}, {10, 22, 0, 0}}, new int[][]{{4, 13, 2, 3}, {6, 16, 8, 0}, {9, 20, 10, 0}, {3, 15, 12, 3}, {15, 22, 20, 0}, {9, 21, 0, 0}}, new int[][]{{3, 8, 3, 2}, {5, 9, 2, 2}, {9, 14, 4, 0}, {7, 15, 10, 5}, {10, 27, 20, 3}, {10, 18, 0, 0}}};
    public static final int TYPE_HERO = 5;
    private SequenceButtonPanel buttons;
    private CardLayout cardLayout;
    private String cardState = "Main";
    private JPanel editor;
    private transient Unit unit;
    JTextField name;
    JComboBox race;
    JComboBox type;
    JComboBox targetType;
    JSpinner levelAndXP;
    SpinnerNumberModel levelAndXPModel;
    private JLabel major;
    private JSpinner majorLevel;
    private SpinnerNumberModel majorModel;
    JComboBox minor;
    JSpinner minorLevel;
    SpinnerNumberModel minorModel;
    private JSpinner life;
    private SpinnerNumberModel lifeModel;
    private JSpinner combat;
    private SpinnerNumberModel combatModel;
    private JLabel remainingLabel;
    private JLabel remaining;
    private JComboBox head;
    private JComboBox weapon;
    private JComboBox armor;
    private JComboBox accessory;

    public UnitWizardPanel() {
        this.setName("Retinues");
        this.setLayout(new BorderLayout());
        WizardTitle header = new WizardTitle(TITLE, "com/softlabs/warlords4/rsc/unitWizard.png");
        this.add((Component)header, "North");
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.bottom = 5;
        this.cardLayout = new CardLayout();
        this.editor = new JPanel(this.cardLayout);
        this.add((Component)this.editor, "Center");
        JPanel unitMain = new JPanel(new GridBagLayout());
        unitMain.setName("RCharacter");
        this.editor.add((Component)unitMain, MAIN_PANEL);
        gbConstraints.insets.top = 5;
        JLabel nameLabel = new JLabel("Name:");
        nameLabel.setDisplayedMnemonic('a');
        nameLabel.setToolTipText("Name: Maximum 31 characters.");
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        unitMain.add((Component)nameLabel, gbConstraints);
        gbConstraints.weightx = 1.0;
        this.name = new JTextField();
        this.name.setDocument(new LimitedPlainDocument(31, false, null));
        this.name.setToolTipText(nameLabel.getToolTipText());
        this.name.getDocument().addDocumentListener(this);
        nameLabel.setLabelFor(this.name);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 11;
        unitMain.add((Component)this.name, gbConstraints);
        JButton generateName = new JButton("Generate");
        generateName.addActionListener(new GenerateUnitNameAction(this));
        generateName.setToolTipText("Generate a unit name.");
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.right = 5;
        unitMain.add((Component)generateName, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.insets.right = 0;
        gbConstraints.insets.top = 0;
        JLabel raceLabel = new JLabel("Race:");
        raceLabel.setDisplayedMnemonic('R');
        raceLabel.setToolTipText("Race: One of the 10 races from the wheel.");
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        unitMain.add((Component)raceLabel, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.race = new JComboBox<Object>(UnitEditionPanel.RACE_NAMES.toArray());
        this.race.setRenderer(new GenericListCellRenderer());
        this.race.setToolTipText(raceLabel.getToolTipText());
        raceLabel.setLabelFor(this.race);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 5;
        unitMain.add((Component)this.race, gbConstraints);
        JLabel typeLabel = new JLabel("Type:");
        typeLabel.setDisplayedMnemonic('T');
        typeLabel.setToolTipText("Type: Each race has 6 different units. The names change according to the race.");
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        unitMain.add((Component)typeLabel, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.type = new JComboBox<LabeledIcon>(UnitEditionPanel.getUnitNames(0));
        this.type.setRenderer(new GenericListCellRenderer());
        this.type.setToolTipText(typeLabel.getToolTipText());
        typeLabel.setLabelFor(this.type);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 5;
        unitMain.add((Component)this.type, gbConstraints);
        this.targetType = new JComboBox<String>(LEVEL_XP_LABELS);
        this.targetType.setToolTipText("Select level or experience input.");
        this.targetType.setName("RStatistics");
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        unitMain.add((Component)this.targetType, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.levelAndXPModel = new SpinnerNumberModel(1, 1, 9999, 1);
        this.levelAndXP = new JSpinner(this.levelAndXPModel);
        this.levelAndXP.setToolTipText("Level or expereince depending on the choice.");
        this.levelAndXP.setName("RStatistics");
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 5;
        unitMain.add((Component)this.levelAndXP, gbConstraints);
        gbConstraints.weighty = 1.0;
        unitMain.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        JPanel abilities = new JPanel(new GridBagLayout());
        abilities.setName("RAbilities");
        this.editor.add((Component)abilities, ABILITIES_PANEL);
        gbConstraints.insets.top = 5;
        JLabel lifeLabel = new JLabel("Life:");
        lifeLabel.setDisplayedMnemonic('L');
        lifeLabel.setToolTipText("Life: The number of life point you can spend in combat before feeding worms.");
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        abilities.add((Component)lifeLabel, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.lifeModel = new SpinnerNumberModel(CLASS_SPECS[0][0][1], CLASS_SPECS[0][0][1], 255, 2);
        this.life = new JSpinner(this.lifeModel);
        this.life.setToolTipText(lifeLabel.getToolTipText());
        this.life.setName("RStatistics");
        lifeLabel.setLabelFor(this.life);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 5;
        abilities.add((Component)this.life, gbConstraints);
        gbConstraints.insets.top = 0;
        JLabel combatLabel = new JLabel("Combat:");
        combatLabel.setDisplayedMnemonic('o');
        combatLabel.setToolTipText("Combat: Fighting capacity.");
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        abilities.add((Component)combatLabel, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.combatModel = new SpinnerNumberModel(CLASS_SPECS[0][0][0], CLASS_SPECS[0][0][0], 255, 1);
        this.combat = new JSpinner(this.combatModel);
        this.combat.setToolTipText(combatLabel.getToolTipText());
        this.combat.setName("RStatistics");
        combatLabel.setLabelFor(this.combat);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 5;
        abilities.add((Component)this.combat, gbConstraints);
        gbConstraints.insets.left = 5;
        gbConstraints.insets.right = 5;
        abilities.add((Component)new JSeparator(), gbConstraints);
        JLabel majorNameLabel = new JLabel("Major Ability:");
        majorNameLabel.setToolTipText("Major Ability: Get help to cross-check with the class.");
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        abilities.add((Component)majorNameLabel, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        Ability ability = Ability.createAbility(CLASS_MAJOR_ABILITY[0][0][0]);
        this.major = new JLabel(ability.getLabel(), ability.getIcon(), 10);
        this.major.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        majorNameLabel.setLabelFor(this.major);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 5;
        abilities.add((Component)this.major, gbConstraints);
        JLabel majorLevelLabel = new JLabel("Level:");
        majorLevelLabel.setDisplayedMnemonic('e');
        majorLevelLabel.setToolTipText("Level: efficiency of this ability, max 5.");
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        abilities.add((Component)majorLevelLabel, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.majorModel = new SpinnerNumberModel(1, 1, 5, 1);
        this.majorLevel = new JSpinner(this.majorModel);
        this.majorLevel.setToolTipText(majorLevelLabel.getToolTipText());
        majorLevelLabel.setLabelFor(this.majorLevel);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 5;
        abilities.add((Component)this.majorLevel, gbConstraints);
        gbConstraints.insets.left = 5;
        gbConstraints.insets.right = 5;
        abilities.add((Component)new JSeparator(), gbConstraints);
        JLabel minorNameLabel = new JLabel("Minor Ability:");
        minorNameLabel.setDisplayedMnemonic('M');
        minorNameLabel.setToolTipText("Minor Ability: Get help to cross-check with the class.");
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        abilities.add((Component)minorNameLabel, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.minor = new JComboBox();
        this.minor.setRenderer(new GenericListCellRenderer());
        this.minor.addItem(Ability.NULL_ABILITY);
        minorNameLabel.setLabelFor(this.minor);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 5;
        abilities.add((Component)this.minor, gbConstraints);
        JLabel minorLevelLabel = new JLabel("Level:");
        minorLevelLabel.setDisplayedMnemonic('v');
        minorLevelLabel.setToolTipText("Level: efficiency of this ability, max 5.");
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        abilities.add((Component)minorLevelLabel, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.minorModel = new SpinnerNumberModel(0, 0, 5, 1);
        this.minorLevel = new JSpinner(this.minorModel);
        this.minorLevel.setToolTipText(minorLevelLabel.getToolTipText());
        minorLevelLabel.setLabelFor(this.minorLevel);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 5;
        abilities.add((Component)this.minorLevel, gbConstraints);
        gbConstraints.insets.left = 5;
        gbConstraints.insets.right = 5;
        abilities.add((Component)new JSeparator(), gbConstraints);
        JPanel remainingPanel = new JPanel(new GridBagLayout());
        remainingPanel.setOpaque(false);
        gbConstraints.weightx = 1.0;
        gbConstraints.insets.left = 5;
        gbConstraints.insets.right = 5;
        gbConstraints.insets.top = 5;
        gbConstraints.insets.bottom = 5;
        abilities.add((Component)remainingPanel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.insets.top = 0;
        gbConstraints.insets.bottom = 0;
        gbConstraints.weightx = 0.0;
        this.remainingLabel = new JLabel("Remaining development points:");
        this.remainingLabel.setToolTipText("To go to the next stage you must have a positive amount!");
        gbConstraints.gridwidth = 1;
        gbConstraints.insets.right = 11;
        remainingPanel.add((Component)this.remainingLabel, gbConstraints);
        gbConstraints.insets.right = 0;
        this.remaining = new JLabel();
        this.remaining.setToolTipText(this.remainingLabel.getToolTipText());
        gbConstraints.weightx = 1.0;
        gbConstraints.insets.right = 5;
        remainingPanel.add((Component)this.remaining, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 0;
        Font baseFont = UIManager.getFont("Label.font").deriveFont(1);
        this.remainingLabel.setFont(baseFont);
        this.remaining.setFont(baseFont);
        JButton adjust = new JButton("Adjust");
        adjust.setToolTipText("Adjust the Unit' level to the necessary development points.");
        adjust.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                UnitWizardPanel.this.adjustLevel();
            }
        });
        remainingPanel.add((Component)adjust, gbConstraints);
        gbConstraints.weighty = 1.0;
        abilities.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        JPanel unitItems = new JPanel(new GridBagLayout());
        unitItems.setName("RItems");
        this.editor.add((Component)unitItems, ITEMS_PANEL);
        gbConstraints.insets.top = 5;
        JLabel headLabel = new JLabel("Head:");
        headLabel.setDisplayedMnemonic('H');
        headLabel.setToolTipText("Head: Piece of fashion to cover your head.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        unitItems.add((Component)headLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.head = new JComboBox<Object>(Item.ITEMS_HEAD.toArray());
        this.head.setRenderer(new GenericListCellRenderer());
        this.head.setToolTipText(headLabel.getToolTipText());
        headLabel.setLabelFor(this.head);
        gbConstraints.insets.right = 5;
        unitItems.add((Component)this.head, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.insets.top = 5;
        JLabel weaponLabel = new JLabel("Weapon:");
        weaponLabel.setDisplayedMnemonic('W');
        weaponLabel.setToolTipText("Weapon: Piece of junk to kill.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        unitItems.add((Component)weaponLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.weapon = new JComboBox<Object>(Item.ITEMS_WEAPON.toArray());
        this.weapon.setRenderer(new GenericListCellRenderer());
        this.weapon.setToolTipText(weaponLabel.getToolTipText());
        weaponLabel.setLabelFor(this.weapon);
        gbConstraints.insets.right = 5;
        unitItems.add((Component)this.weapon, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel armorLabel = new JLabel("Armor:");
        armorLabel.setDisplayedMnemonic('A');
        armorLabel.setToolTipText("Armor: Piece of junk to protect you.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        unitItems.add((Component)armorLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.armor = new JComboBox<Object>(Item.ITEMS_ARMOR.toArray());
        this.armor.setRenderer(new GenericListCellRenderer());
        this.armor.setToolTipText(armorLabel.getToolTipText());
        armorLabel.setLabelFor(this.armor);
        gbConstraints.insets.right = 5;
        unitItems.add((Component)this.armor, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel accessoryLabel = new JLabel("Accessory:");
        accessoryLabel.setDisplayedMnemonic('e');
        accessoryLabel.setToolTipText("Accessory: Piece of Junk that makes you look better.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        unitItems.add((Component)accessoryLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.accessory = new JComboBox<Object>(Item.ITEMS_ACCESSORY.toArray());
        this.accessory.setRenderer(new GenericListCellRenderer());
        this.accessory.setToolTipText(accessoryLabel.getToolTipText());
        accessoryLabel.setLabelFor(this.accessory);
        gbConstraints.insets.right = 5;
        unitItems.add((Component)this.accessory, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.weighty = 1.0;
        unitItems.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        JPanel footer = new JPanel(new BorderLayout());
        footer.add((Component)new UniversalSeparator(), "North");
        this.buttons = new SequenceButtonPanel();
        this.buttons.setBackEnabled(false);
        this.buttons.addActionListener(this);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        footer.add((Component)this.buttons, "Center");
        this.add((Component)footer, "South");
        this.buttons.installDefaultButton();
        ActionListener raceAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int index = UnitWizardPanel.this.type.getSelectedIndex();
                UnitWizardPanel.this.type.removeAllItems();
                LabeledIcon[] units = UnitEditionPanel.getUnitNames(UnitWizardPanel.this.race.getSelectedIndex());
                for (int i = 0; i < units.length; ++i) {
                    UnitWizardPanel.this.type.addItem(units[i]);
                }
                UnitWizardPanel.this.type.setSelectedIndex(index);
                UnitWizardPanel.this.setClassSpecs();
            }
        };
        this.race.addActionListener(raceAction);
        ActionListener typeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (UnitWizardPanel.this.type.getSelectedIndex() >= 0) {
                    UnitWizardPanel.this.setClassSpecs();
                    UnitWizardPanel.this.checkItems();
                }
            }
        };
        this.type.addActionListener(typeAction);
        ActionListener targetTypeChange = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int target = UnitWizardPanel.this.targetType.getSelectedIndex();
                int curValue = 1;
                try {
                    Object object = UnitWizardPanel.this.levelAndXP.getValue();
                    curValue = object instanceof Number ? ((Number)object).intValue() : Integer.parseInt(object.toString());
                }
                catch (Throwable exception) {
                    // empty catch block
                }
                int level = curValue;
                int experience = curValue;
                if (target == 0) {
                    level = curValue / 10 + 1;
                    UnitWizardPanel.this.setLevelAndXP(target, level);
                } else {
                    experience = (curValue - 1) * 10;
                    UnitWizardPanel.this.setLevelAndXP(target, experience);
                }
            }
        };
        this.targetType.addActionListener(targetTypeChange);
        ChangeListener abilitiesChange = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                UnitWizardPanel.this.setDevelopmentPoints();
            }
        };
        this.life.addChangeListener(abilitiesChange);
        this.combat.addChangeListener(abilitiesChange);
        this.majorLevel.addChangeListener(abilitiesChange);
        this.minorLevel.addChangeListener(abilitiesChange);
        ActionListener minorChange = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (UnitWizardPanel.this.minor.getSelectedItem() != Ability.NULL_ABILITY) {
                    UnitWizardPanel.this.minorLevel.setEnabled(true);
                    Ability ability = (Ability)UnitWizardPanel.this.minor.getSelectedItem();
                    int max = ability != null && ability.getID() == 41 ? 255 : 5;
                    UnitWizardPanel.this.minorModel.setMaximum(new Integer(max));
                    UnitWizardPanel.this.minorModel.setValue(new Integer(Math.min(max, (Integer)UnitWizardPanel.this.minorLevel.getValue())));
                } else {
                    UnitWizardPanel.this.minorLevel.setEnabled(false);
                    UnitWizardPanel.this.minorLevel.setValue(new Integer(0));
                }
            }
        };
        this.minor.addActionListener(minorChange);
    }

    public Unit getUnit() {
        return this.unit;
    }

    private int getDevelopementPoints() {
        return this.getLevel();
    }

    private int getLevel() {
        int target = this.targetType.getSelectedIndex();
        int curValue = 1;
        try {
            Object object = this.levelAndXP.getValue();
            curValue = object instanceof Number ? ((Number)object).intValue() : Integer.parseInt(object.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (target == 1) {
            curValue /= 10;
            ++curValue;
        }
        return curValue;
    }

    private int getExperience() {
        int target = this.targetType.getSelectedIndex();
        int curValue = 1;
        try {
            Object object = this.levelAndXP.getValue();
            curValue = object instanceof Number ? ((Number)object).intValue() : Integer.parseInt(object.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (target == 0) {
            curValue *= 10;
        }
        return curValue;
    }

    void setClassSpecs() {
        Integer minLife;
        int type;
        int race = this.race.getSelectedIndex();
        Integer minCombat = new Integer(CLASS_SPECS[race][type = this.type.getSelectedIndex()][0]);
        if (minCombat.compareTo((Integer)this.combatModel.getMinimum()) != 0) {
            this.combatModel.setMinimum(minCombat);
        }
        if ((Integer)this.combat.getValue() != CLASS_SPECS[race][type][0]) {
            this.combat.setValue(new Integer(CLASS_SPECS[race][type][0]));
        }
        if ((minLife = new Integer(CLASS_SPECS[race][type][1])).compareTo((Integer)this.lifeModel.getMinimum()) != 0) {
            this.lifeModel.setMinimum(minLife);
        }
        if ((Integer)this.life.getValue() != CLASS_SPECS[race][type][1]) {
            this.life.setValue(new Integer(CLASS_SPECS[race][type][1]));
        }
        Ability ability = Ability.createAbility(CLASS_MAJOR_ABILITY[race][type][0]);
        this.major.setText(ability.getLabel());
        this.major.setIcon(ability.getIcon());
        this.major.setToolTipText(ability.getDescription());
        this.majorModel.setStepSize(new Integer(CLASS_MAJOR_ABILITY[race][type][1]));
        this.majorModel.setMinimum(new Integer(CLASS_MAJOR_ABILITY[race][type][2]));
        this.majorLevel.setValue(new Integer(CLASS_MAJOR_ABILITY[race][type][2]));
        this.minor.removeAllItems();
        if (type != 5) {
            this.minor.addItem(Ability.NULL_ABILITY);
        }
        for (int i = 0; i < CLASS_MINOR_ABILITIES[race][type].length; ++i) {
            this.minor.addItem(Ability.createAbility(CLASS_MINOR_ABILITIES[race][type][i]));
        }
        this.minor.setEnabled(CLASS_SPECS[race][type][3] == 0);
        if (type != 5) {
            this.minorModel.setMinimum(new Integer(0));
            this.minorLevel.setValue(new Integer(0));
        } else {
            this.minorLevel.setValue(new Integer(1));
            this.minorModel.setMinimum(new Integer(1));
        }
        this.minorLevel.setEnabled(false);
    }

    public void setLevelAndXP(int target, int value) {
        if (target == 1) {
            this.levelAndXP.setValue(new Integer(value));
            this.levelAndXPModel.setMinimum(new Integer(0));
            this.levelAndXPModel.setMaximum(new Integer(9999));
        } else {
            this.levelAndXP.setValue(new Integer(value));
            this.levelAndXPModel.setMinimum(new Integer(1));
            this.levelAndXPModel.setMaximum(new Integer(999));
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.remainingLabel != null) {
            Font baseFont = UIManager.getFont("Label.font");
            baseFont = baseFont.deriveFont(1);
            this.remainingLabel.setFont(baseFont);
            this.remaining.setFont(baseFont);
        }
    }

    private void close() {
        Window root = SwingUtilities.getWindowAncestor(this);
        if (root != null) {
            root.setVisible(false);
        }
    }

    public void reset() {
        this.unit = null;
        this.cardState = MAIN_PANEL;
        this.cardLayout.show(this.editor, this.cardState);
        this.checkItems();
        this.setDevelopmentPoints();
    }

    void adjustLevel() {
        int race = this.race.getSelectedIndex();
        int type = this.type.getSelectedIndex();
        int lifeCount = ((Integer)this.life.getValue() - CLASS_SPECS[race][type][1]) / 2;
        int combatCount = (Integer)this.combat.getValue() - CLASS_SPECS[race][type][0];
        int majorCount = ((Integer)this.majorLevel.getValue() - CLASS_MAJOR_ABILITY[race][type][2]) / CLASS_MAJOR_ABILITY[race][type][1];
        int minorCount = (Integer)this.minorLevel.getValue();
        if (type == 5) {
            --minorCount;
        }
        int devPointsNeeded = lifeCount + combatCount + majorCount + minorCount + 1;
        this.targetType.setSelectedItem(LEVEL_XP_LABELS[0]);
        this.levelAndXP.setValue(new Integer(devPointsNeeded));
        this.setDevelopmentPoints();
    }

    void checkItems() {
        int type = this.type.getSelectedIndex();
        if (type == 5) {
            this.head.setEnabled(true);
            this.armor.setEnabled(true);
            this.weapon.setEnabled(true);
            this.accessory.setEnabled(true);
        } else {
            this.head.setEnabled(false);
            this.head.setSelectedIndex(0);
            this.armor.setEnabled(false);
            this.armor.setSelectedIndex(0);
            this.weapon.setEnabled(false);
            this.weapon.setSelectedIndex(0);
            this.accessory.setEnabled(false);
            this.accessory.setSelectedIndex(0);
        }
    }

    private void checkMinorAbility() {
        int race = this.race.getSelectedIndex();
        int type = this.type.getSelectedIndex();
        int level = this.getLevel();
        if (level >= CLASS_SPECS[race][type][3]) {
            this.minor.setEnabled(true);
            if (this.minor.getSelectedIndex() > 0 || type == 5) {
                this.minorLevel.setEnabled(true);
            } else {
                this.minorLevel.setEnabled(false);
                this.minorLevel.setValue(new Integer(0));
            }
        } else {
            this.minor.setEnabled(false);
            this.minor.setSelectedIndex(0);
            this.minorLevel.setEnabled(false);
            this.minorLevel.setValue(new Integer(0));
        }
    }

    void setDevelopmentPoints() {
        int race = this.race.getSelectedIndex();
        int type = this.type.getSelectedIndex();
        int lifeCount = ((Integer)this.life.getValue() - CLASS_SPECS[race][type][1]) / 2;
        int combatCount = (Integer)this.combat.getValue() - CLASS_SPECS[race][type][0];
        int devPoints = this.getDevelopementPoints() - 1;
        int majorCount = ((Integer)this.majorLevel.getValue() - CLASS_MAJOR_ABILITY[race][type][2]) / CLASS_MAJOR_ABILITY[race][type][1];
        int minorCount = (Integer)this.minorLevel.getValue();
        if (type == 5) {
            --minorCount;
        }
        int rest = devPoints - lifeCount - combatCount - majorCount - minorCount;
        this.remaining.setText(Integer.toString(rest));
        if (rest == 0) {
            this.remaining.setForeground(Color.BLUE);
        } else if (rest > 0) {
            this.remaining.setForeground(Color.GREEN);
        } else {
            this.remaining.setForeground(Color.RED);
        }
        this.stateChanged();
    }

    private void buildUnit() {
        Unit unit = new Unit();
        unit.setName(this.name.getText());
        int race = this.race.getSelectedIndex();
        unit.setRace(race);
        int type = this.type.getSelectedIndex();
        unit.setType(type);
        unit.setLevel(this.getLevel());
        unit.setExperience(this.getExperience());
        unit.setMajorAbility(Ability.createAbility(CLASS_MAJOR_ABILITY[race][type][0]));
        unit.setMajorLevel((Integer)this.majorLevel.getValue());
        Ability minor = (Ability)this.minor.getSelectedItem();
        if (minor != null && minor != Ability.NULL_ABILITY) {
            unit.setMinorAbility(minor);
            unit.setMinorLevel(((Number)this.minorLevel.getValue()).intValue());
        } else {
            unit.setMinorAbility(null);
            unit.setMinorLevel(0);
        }
        unit.setLife((Integer)this.life.getValue());
        unit.setCombat((Integer)this.combat.getValue());
        unit.setUpkeep(0);
        unit.setHeadItem((Item)this.head.getSelectedItem());
        unit.setWeaponItem((Item)this.weapon.getSelectedItem());
        unit.setArmorItem((Item)this.armor.getSelectedItem());
        unit.setAccessoryItem((Item)this.accessory.getSelectedItem());
        this.unit = unit;
    }

    public void loadUnit(Unit unit) {
        if (unit != null) {
            this.name.setText(unit.getName());
            this.race.setSelectedIndex(unit.getRace());
            this.type.setSelectedIndex(unit.getType());
            int level = unit.getLevel();
            int pseudoLevel = (level - 1) * 10;
            int experience = unit.getExperience();
            if (level == 1 && experience <= 1 || experience == pseudoLevel) {
                this.targetType.setSelectedIndex(0);
                this.setLevelAndXP(0, unit.getLevel());
            } else {
                this.targetType.setSelectedIndex(1);
                this.setLevelAndXP(1, experience);
            }
            this.head.setSelectedItem(unit.getHeadItem());
            this.weapon.setSelectedItem(unit.getWeaponItem());
            this.armor.setSelectedItem(unit.getArmorItem());
            this.accessory.setSelectedItem(unit.getAccessoryItem());
            this.setClassSpecs();
            this.life.setValue(new Integer(unit.getLife()));
            this.combat.setValue(new Integer(unit.getCombat()));
            this.majorLevel.setValue(new Integer(unit.getMajorLevel()));
            this.minorLevel.setValue(new Integer(unit.getMinorLevel()));
            this.minor.setSelectedItem(unit.getMinorAbility());
        } else {
            this.name.setText(null);
            this.targetType.setSelectedIndex(0);
            this.setLevelAndXP(0, 1);
            this.head.setSelectedIndex(0);
            this.weapon.setSelectedIndex(0);
            this.armor.setSelectedIndex(0);
            this.accessory.setSelectedIndex(0);
            this.setClassSpecs();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("SB@Cancel".equals(command)) {
            this.close();
        } else if ("SB@Back".equals(command)) {
            if (this.buttons.isBackEnabled()) {
                if (this.cardState.equals(ABILITIES_PANEL)) {
                    this.cardState = MAIN_PANEL;
                } else if (this.cardState.equals(ITEMS_PANEL)) {
                    this.cardState = ABILITIES_PANEL;
                }
            }
            this.cardLayout.show(this.editor, this.cardState);
        } else if ("SB@Next".equals(command)) {
            if (this.buttons.isNextEnabled()) {
                if (this.cardState.equals(MAIN_PANEL)) {
                    this.cardState = ABILITIES_PANEL;
                    this.checkMinorAbility();
                } else if (this.cardState.equals(ABILITIES_PANEL)) {
                    this.cardState = ITEMS_PANEL;
                    this.checkItems();
                } else if (this.cardState.equals(ITEMS_PANEL)) {
                    this.buildUnit();
                    this.close();
                }
            }
            this.cardLayout.show(this.editor, this.cardState);
        }
        this.setDevelopmentPoints();
    }

    private void stateChanged() {
        if (this.cardState.equals(MAIN_PANEL)) {
            this.buttons.setBackEnabled(false);
            this.buttons.setNextEnabled(this.name.getText().length() > 0);
            this.buttons.setCustomizeNextButton(null, null, -1);
        } else if (this.cardState.equals(ABILITIES_PANEL)) {
            this.buttons.setBackEnabled(true);
            this.buttons.setNextEnabled(Integer.parseInt(this.remaining.getText()) >= 0);
            this.buttons.setCustomizeNextButton(null, null, -1);
        } else if (this.cardState.equals(ITEMS_PANEL)) {
            this.buttons.setBackEnabled(true);
            this.buttons.setCustomizeNextButton("Finish", "Finish and Return to editor", 70);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.stateChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.stateChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.stateChanged();
    }

    private static final class GenerateUnitNameAction
    implements ActionListener {
        private final UnitWizardPanel panel;

        public GenerateUnitNameAction(UnitWizardPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int race = this.panel.race.getSelectedIndex();
            int type = this.panel.type.getSelectedIndex();
            String name = null;
            name = type == 5 ? HeroNameGenerator.generateName(race) : UnitNameGenerator.generateName(race);
            this.panel.name.setText(name);
        }
    }
}

