/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.data.Ability;
import com.softlabs.warlords4.data.HeroNameGenerator;
import com.softlabs.warlords4.data.Item;
import com.softlabs.warlords4.data.LabeledIcon;
import com.softlabs.warlords4.data.LimitedPlainDocument;
import com.softlabs.warlords4.data.Unit;
import com.softlabs.warlords4.data.UnitNameGenerator;
import com.softlabs.warlords4.event.ChangeTracker;
import com.softlabs.warlords4.gui.AbilityPanel;
import com.softlabs.warlords4.gui.Filler;
import com.softlabs.warlords4.gui.GenericListCellRenderer;
import com.softlabs.warlords4.image.ResourceIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class UnitEditionPanel
extends JPanel {
    public static final List<LabeledIcon> RACE_NAMES = new ArrayList<LabeledIcon>(16);
    static final LabeledIcon[][] UNIT_NAMES;
    private static final Icon ICON_CHARACTER;
    private static final Icon ICON_ABILITIES;
    private static final Icon ICON_STATISTICS;
    private static final Icon ICON_ITEMS;
    JTextField name;
    JComboBox race;
    JComboBox type;
    private AbilityPanel major;
    private AbilityPanel minor;
    private JSpinner life;
    private JSpinner combat;
    private JSpinner upkeep;
    private JSpinner experience;
    private JSpinner level;
    private JComboBox upgrade;
    private JComboBox head;
    private JComboBox weapon;
    private JComboBox armor;
    private JComboBox accessory;
    private transient Unit unit;

    public UnitEditionPanel() {
        super(new BorderLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.bottom = 5;
        JTabbedPane pane = new JTabbedPane();
        pane.setTabLayoutPolicy(1);
        this.add((Component)pane, "Center");
        JPanel character = new JPanel(new GridBagLayout());
        character.setName("RCharacter");
        pane.addTab("Character", ICON_CHARACTER, character);
        gbConstraints.insets.top = 5;
        JLabel nameLabel = new JLabel("Name:");
        nameLabel.setToolTipText("Name: Maximum 31 characters.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        character.add((Component)nameLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        this.name = new JTextField();
        this.name.setDocument(new LimitedPlainDocument(31, false, null));
        this.name.setToolTipText(nameLabel.getToolTipText());
        gbConstraints.insets.right = 11;
        character.add((Component)this.name, gbConstraints);
        JButton generateName = new JButton("Generate");
        generateName.addActionListener(new GenerateUnitNameAction(this));
        generateName.setToolTipText("Generate a unit name.");
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.right = 5;
        character.add((Component)generateName, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.insets.right = 0;
        gbConstraints.insets.top = 0;
        JLabel raceLabel = new JLabel("Race:");
        raceLabel.setToolTipText("Race: One of the 10 races from the wheel.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        character.add((Component)raceLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.race = new JComboBox<Object>(RACE_NAMES.toArray());
        this.race.setRenderer(new GenericListCellRenderer());
        this.race.setToolTipText(raceLabel.getToolTipText());
        gbConstraints.insets.right = 5;
        character.add((Component)this.race, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel typeLabel = new JLabel("Type:");
        typeLabel.setToolTipText("Type: Each race has 6 different units. The names change according to the race.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        character.add((Component)typeLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.type = new JComboBox<LabeledIcon>(UNIT_NAMES[0]);
        this.type.setRenderer(new GenericListCellRenderer());
        this.type.setToolTipText(typeLabel.getToolTipText());
        gbConstraints.insets.right = 5;
        character.add((Component)this.type, gbConstraints);
        gbConstraints.insets.right = 0;
        ActionListener raceAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int index = UnitEditionPanel.this.type.getSelectedIndex();
                UnitEditionPanel.this.type.setModel(new DefaultComboBoxModel<LabeledIcon>(UNIT_NAMES[UnitEditionPanel.this.race.getSelectedIndex()]));
                UnitEditionPanel.this.type.setSelectedIndex(index);
            }
        };
        this.race.addActionListener(raceAction);
        gbConstraints.weighty = 1.0;
        character.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        JPanel abilities = new JPanel(new GridBagLayout());
        abilities.setName("RAbilities");
        pane.addTab("Abilities", ICON_ABILITIES, abilities);
        this.major = new AbilityPanel("Major");
        this.major.setToolTipText("Major Abilty: Look to the game help for detailed information.");
        abilities.add((Component)this.major, gbConstraints);
        this.minor = new AbilityPanel("Minor");
        this.minor.setToolTipText("Major Abilty: Look to the game help for detailed information.");
        abilities.add((Component)this.minor, gbConstraints);
        gbConstraints.weighty = 1.0;
        abilities.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        JPanel statistics = new JPanel(new GridBagLayout());
        statistics.setName("RStatistics");
        pane.addTab("Statistics", ICON_STATISTICS, statistics);
        gbConstraints.insets.top = 5;
        JLabel lifeLabel = new JLabel("Life:");
        lifeLabel.setToolTipText("Life: The number of life point you can spend in combat before feeding worms.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        statistics.add((Component)lifeLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.life = new JSpinner(new SpinnerNumberModel(1, 1, 255, 1));
        this.life.setToolTipText(lifeLabel.getToolTipText());
        gbConstraints.insets.right = 5;
        statistics.add((Component)this.life, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.insets.top = 0;
        JLabel combatLabel = new JLabel("Combat:");
        combatLabel.setToolTipText("Combat: Fighting capacity.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        statistics.add((Component)combatLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.combat = new JSpinner(new SpinnerNumberModel(1, 1, 255, 1));
        this.combat.setToolTipText(combatLabel.getToolTipText());
        gbConstraints.insets.right = 5;
        statistics.add((Component)this.combat, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel upkeepLabel = new JLabel("Upkeep:");
        upkeepLabel.setToolTipText("Upkeep: Gold pieces you need to spend in order to sustain the unit.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        statistics.add((Component)upkeepLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.upkeep = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.upkeep.setToolTipText(upkeepLabel.getToolTipText());
        gbConstraints.insets.right = 5;
        statistics.add((Component)this.upkeep, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel experienceLabel = new JLabel("Experience:");
        experienceLabel.setToolTipText("Experience: Each 10 points equals a level.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        statistics.add((Component)experienceLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.experience = new JSpinner(new SpinnerNumberModel(0, 0, 32768, 1));
        this.experience.setToolTipText(experienceLabel.getToolTipText());
        gbConstraints.insets.right = 5;
        statistics.add((Component)this.experience, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel levelLabel = new JLabel("Level:");
        levelLabel.setToolTipText("Level: Each level equals a 10 experience points.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        statistics.add((Component)levelLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.level = new JSpinner(new SpinnerNumberModel(1, 1, 32768, 1));
        this.level.setToolTipText(levelLabel.getToolTipText());
        gbConstraints.insets.right = 5;
        statistics.add((Component)this.level, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel upgradeLabel = new JLabel("Upgrade:");
        upgradeLabel.setToolTipText("Upgrade: Gives the unit boost for their achievements.");
        upgradeLabel.setVisible(false);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        statistics.add((Component)upgradeLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.upgrade = new JComboBox();
        this.upgrade.addItem("None");
        this.upgrade.addItem("Level 1");
        this.upgrade.addItem("Level 2");
        this.upgrade.setToolTipText(upgradeLabel.getToolTipText());
        this.upgrade.setVisible(false);
        gbConstraints.insets.right = 5;
        statistics.add((Component)this.upgrade, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.weighty = 1.0;
        statistics.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        JPanel items = new JPanel(new GridBagLayout());
        items.setName("RItems");
        pane.addTab("Items", ICON_ITEMS, items);
        gbConstraints.insets.top = 5;
        JLabel headLabel = new JLabel("Head:");
        headLabel.setToolTipText("Head: Piece of fashion to cover your head.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        items.add((Component)headLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.head = new JComboBox<Object>(Item.ITEMS_HEAD.toArray());
        this.head.setRenderer(new GenericListCellRenderer());
        this.head.setToolTipText(headLabel.getToolTipText());
        gbConstraints.insets.right = 5;
        items.add((Component)this.head, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.insets.top = 0;
        JLabel weaponLabel = new JLabel("Weapon:");
        weaponLabel.setToolTipText("Weapon: Piece of junk to kill.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        items.add((Component)weaponLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.weapon = new JComboBox<Object>(Item.ITEMS_WEAPON.toArray());
        this.weapon.setRenderer(new GenericListCellRenderer());
        this.weapon.setToolTipText(weaponLabel.getToolTipText());
        gbConstraints.insets.right = 5;
        items.add((Component)this.weapon, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel armorLabel = new JLabel("Armor:");
        armorLabel.setToolTipText("Armor: Piece of junk to protect you.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        items.add((Component)armorLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.armor = new JComboBox<Object>(Item.ITEMS_ARMOR.toArray());
        this.armor.setRenderer(new GenericListCellRenderer());
        this.armor.setToolTipText(armorLabel.getToolTipText());
        gbConstraints.insets.right = 5;
        items.add((Component)this.armor, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel accessoryLabel = new JLabel("Accessory:");
        accessoryLabel.setToolTipText("Accessory: Piece of Junk that makes you look better.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        items.add((Component)accessoryLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.accessory = new JComboBox<Object>(Item.ITEMS_ACCESSORY.toArray());
        this.accessory.setRenderer(new GenericListCellRenderer());
        this.accessory.setToolTipText(accessoryLabel.getToolTipText());
        gbConstraints.insets.right = 5;
        items.add((Component)this.accessory, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.weighty = 1.0;
        items.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public static final LabeledIcon getUnitName(int race, int type) {
        return UNIT_NAMES[race][type];
    }

    public static final LabeledIcon[] getUnitNames(int race) {
        return UNIT_NAMES[race];
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public static final String getUnitLabel(Unit unit) {
        return unit == null ? "Retinue" : unit.toString();
    }

    public void load() {
        Unit unit = this.getUnit();
        if (unit != null) {
            this.name.setText(unit.getName());
            this.race.setSelectedIndex(unit.getRace());
            this.type.setSelectedIndex(unit.getType());
            this.major.setAbility(unit.getMajorAbility());
            this.major.setLevel(unit.getMajorLevel());
            this.minor.setAbility(unit.getMinorAbility());
            this.minor.setLevel(unit.getMinorLevel());
            this.life.setValue(new Integer(unit.getLife()));
            this.combat.setValue(new Integer(unit.getCombat()));
            this.upkeep.setValue(new Integer(unit.getUpkeep()));
            this.experience.setValue(new Integer(unit.getExperience()));
            this.level.setValue(new Integer(unit.getLevel()));
            this.upgrade.setSelectedIndex(unit.getUpgrade());
            this.head.setSelectedItem(unit.getHeadItem());
            this.weapon.setSelectedItem(unit.getWeaponItem());
            this.armor.setSelectedItem(unit.getArmorItem());
            this.accessory.setSelectedItem(unit.getAccessoryItem());
        } else {
            this.name.setText(null);
            this.race.setSelectedIndex(0);
            this.type.setSelectedIndex(0);
            this.major.setAbility(Ability.NULL_ABILITY);
            this.major.setLevel(0);
            this.minor.setAbility(Ability.NULL_ABILITY);
            this.minor.setLevel(0);
            this.life.setValue(new Integer(1));
            this.combat.setValue(new Integer(1));
            this.upkeep.setValue(new Integer(0));
            this.experience.setValue(new Integer(0));
            this.level.setValue(new Integer(1));
            this.upgrade.setSelectedIndex(0);
            this.head.setSelectedItem(Item.NULL_ITEM);
            this.weapon.setSelectedItem(Item.NULL_ITEM);
            this.armor.setSelectedItem(Item.NULL_ITEM);
            this.accessory.setSelectedItem(Item.NULL_ITEM);
        }
    }

    public void save() {
        Unit unit = this.getUnit();
        if (unit != null) {
            unit.setName(this.name.getText());
            unit.setRace(this.race.getSelectedIndex());
            unit.setType(this.type.getSelectedIndex());
            unit.setMajorAbility(this.major.getAbility());
            unit.setMajorLevel(this.major.getLevel());
            unit.setMinorAbility(this.minor.getAbility());
            unit.setMinorLevel(this.minor.getLevel());
            unit.setLife(((Number)this.life.getValue()).intValue());
            unit.setCombat(((Number)this.combat.getValue()).intValue());
            unit.setUpkeep(((Number)this.upkeep.getValue()).intValue());
            unit.setExperience(((Number)this.experience.getValue()).intValue());
            unit.setLevel(((Number)this.level.getValue()).intValue());
            unit.setUpgrade(this.upgrade.getSelectedIndex());
            unit.setHeadItem((Item)this.head.getSelectedItem());
            unit.setWeaponItem((Item)this.weapon.getSelectedItem());
            unit.setArmorItem((Item)this.armor.getSelectedItem());
            unit.setAccessoryItem((Item)this.accessory.getSelectedItem());
        }
    }

    public void addChangeTracker(ChangeTracker tracker) {
        this.name.getDocument().addDocumentListener(tracker);
        this.race.addActionListener(tracker);
        this.type.addActionListener(tracker);
        this.major.addChangeTracker(tracker);
        this.minor.addChangeTracker(tracker);
        this.life.addChangeListener(tracker);
        this.combat.addChangeListener(tracker);
        this.upkeep.addChangeListener(tracker);
        this.experience.addChangeListener(tracker);
        this.level.addChangeListener(tracker);
        this.upgrade.addActionListener(tracker);
        this.head.addActionListener(tracker);
        this.weapon.addActionListener(tracker);
        this.armor.addActionListener(tracker);
        this.accessory.addActionListener(tracker);
    }

    static {
        RACE_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/race0.png"), "Knights [Good]"));
        RACE_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/race1.png"), "Empire [Neutral]"));
        RACE_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/race2.png"), "Dwarves [Neutral]"));
        RACE_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/race3.png"), "Ogres [Neutral]"));
        RACE_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/race4.png"), "Orcs [Evil]"));
        RACE_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/race5.png"), "Undead [Evil]"));
        RACE_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/race6.png"), "Dark Elves [Evil]"));
        RACE_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/race7.png"), "Daemons [Evil]"));
        RACE_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/race8.png"), "Dragons [Neutral]"));
        RACE_NAMES.add(new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/race9.png"), "Elves [Good]"));
        UNIT_NAMES = new LabeledIcon[][]{{new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit00.png"), "Swordsman (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit01.png"), "Bowman (Archer)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit02.png"), "Knight (Cavalry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit03.png"), "Trebuchet (Machine)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit04.png"), "Archon (Celestial, Flight)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit05.png"), "Knight Hero (Hero)")}, {new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit10.png"), "Spearman (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit11.png"), "Ballista (Archer)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit12.png"), "Cavalry (Cavalry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit13.png"), "Twin Catapult (Machine)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit14.png"), "Pegasus (Monster, Flight)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit15.png"), "Empire Hero (Hero)")}, {new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit20.png"), "Axeman (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit21.png"), "Crossbow (Archer)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit22.png"), "Golem (Monster)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit23.png"), "Bolt Thrower (Machine)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit24.png"), "Elemental (Monster)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit25.png"), "Dwarven Hero (Hero)")}, {new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit30.png"), "Giant Bat (Monster, Flight)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit31.png"), "Troll (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit32.png"), "Minotaur (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit33.png"), "Rock Giant (Monster)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit34.png"), "Ogre (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit35.png"), "Ogre Hero (Hero)")}, {new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit40.png"), "Goblin (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit41.png"), "Orc (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit42.png"), "Wolfrider (Cavalry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit43.png"), "Goblin Thrower (Machine)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit44.png"), "Wyvern (Dragon, Flight)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit45.png"), "Orkish Hero (Hero)")}, {new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit50.png"), "Skeleton (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit51.png"), "Liche (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit52.png"), "Skeleton Rider (Cavalry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit53.png"), "Skull Thrower (Machine)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit54.png"), "Dragonliche (Dragon, Flight)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit55.png"), "Undead Hero (Hero)")}, {new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit60.png"), "Spider (Monster)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit61.png"), "Assassin (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit62.png"), "Shadowrider (Cavalry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit63.png"), "Manticore (Machine)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit64.png"), "Harpy (Monster, Flight)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit65.png"), "Dark Elven Hero (Hero)")}, {new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit70.png"), "Imp (Flight)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit71.png"), "Soul Gatherer (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit72.png"), "Daemon Minion (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit73.png"), "Hellbore (Monster)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit74.png"), "Hydra (Monster)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit75.png"), "Daemon Hero (Hero)")}, {new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit80.png"), "Dragonknight (Human, Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit81.png"), "Swamp Dragon (Flight)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit82.png"), "Storm Dragon (Flight)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit83.png"), "Flame Cannon (Machine)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit84.png"), "Fire Dragon (Flight)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit85.png"), "Dragonlord Hero (Hero, Human)")}, {new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit90.png"), "Elven Archer (Archer)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit91.png"), "Elfguard (Infantry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit92.png"), "Elven Knight (Cavalry)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit93.png"), "Unicorn (Monster)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit94.png"), "Treant (Monster)"), new LabeledIcon(new ResourceIcon("com/softlabs/warlords4/rsc/unit95.png"), "Elven Hero (Hero)")}};
        ICON_CHARACTER = new ResourceIcon("com/softlabs/warlords4/rsc/character.png");
        ICON_ABILITIES = new ResourceIcon("com/softlabs/warlords4/rsc/abilities.png");
        ICON_STATISTICS = new ResourceIcon("com/softlabs/warlords4/rsc/statistics.png");
        ICON_ITEMS = new ResourceIcon("com/softlabs/warlords4/rsc/item.png");
    }

    private static final class GenerateUnitNameAction
    implements ActionListener {
        private final UnitEditionPanel panel;

        public GenerateUnitNameAction(UnitEditionPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int race = this.panel.race.getSelectedIndex();
            int type = this.panel.type.getSelectedIndex();
            String name = null;
            name = type == 5 ? HeroNameGenerator.generateName(race) : UnitNameGenerator.generateName(race);
            this.panel.name.setText(name);
        }
    }
}

