/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class SplashImagePanel
extends JPanel {
    private Image image;

    public SplashImagePanel() {
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.setOpaque(false);
    }

    public SplashImagePanel(Image image) {
        this();
        this.setImage(image);
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets in = this.getInsets();
        return new Dimension(this.image.getWidth(this) + (in.right + in.left), this.image.getHeight(this) + (in.top + in.bottom));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (graphics instanceof Graphics2D) {
            this.render((Graphics2D)graphics);
        }
    }

    private void render(Graphics2D graphics) {
        Dimension dim = this.getSize();
        Insets in = this.getInsets();
        Rectangle display = new Rectangle(in.left, in.top, dim.width - in.left - in.right, dim.height - in.top - in.bottom);
        Image image = this.getImage();
        if (image == null || display.width <= 0 || display.height <= 0) {
            return;
        }
        graphics.translate(in.left, in.top);
        graphics.drawImage(image, 0, 0, display.width, display.height, this);
        graphics.translate(-in.left, -in.top);
    }
}

