/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.Version;
import com.softlabs.warlords4.gui.Filler;
import com.softlabs.warlords4.gui.SplashImagePanel;
import com.softlabs.warlords4.image.ImageFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class Splash
extends JWindow {
    private static Splash defaultSplash = null;
    private JProgressBar progress;

    public Splash() {
        this.setContentPane(new SplashImagePanel(ImageFactory.getImage("com/softlabs/warlords4/rsc/splash.png")));
        JPanel glass = new JPanel(new BorderLayout());
        glass.setOpaque(false);
        this.setGlassPane(glass);
        glass.setVisible(true);
        glass.add((Component)new Filler(10, 243), "North");
        this.progress = new JProgressBar(0, 0, 14);
        this.progress.setOpaque(false);
        this.progress.setBorder(BorderFactory.createEmptyBorder(0, 33, 0, 28));
        this.progress.setBorderPainted(false);
        this.progress.setStringPainted(false);
        this.progress.setForeground(new Color(193, 123, 5));
        this.progress.setValue(0);
        glass.add((Component)this.progress, "Center");
        JLabel copyright = new JLabel("Version 2.54 - " + Version.COPYRIGHT);
        copyright.setForeground(new Color(250, 230, 168));
        copyright.setVerticalAlignment(3);
        copyright.setBorder(BorderFactory.createEmptyBorder(57, 5, 5, 5));
        copyright.setOpaque(false);
        glass.add((Component)copyright, "South");
        MouseInputAdapter motionListener = new MouseInputAdapter(){
            private Point initPos = new Point();
            private Point hitPos = new Point();
            private Point curPos = new Point();
            private Point offset = new Point();

            @Override
            public void mousePressed(MouseEvent event) {
                this.initPos.setLocation(0, 0);
                SwingUtilities.convertPointToScreen(this.initPos, (Component)event.getSource());
                this.hitPos.setLocation(event.getX(), event.getY());
                SwingUtilities.convertPointToScreen(this.hitPos, (Component)event.getSource());
            }

            @Override
            public void mouseDragged(MouseEvent event) {
                this.curPos.setLocation(event.getX(), event.getY());
                SwingUtilities.convertPointToScreen(this.curPos, (Component)event.getSource());
                this.offset.setLocation(this.curPos.x - this.hitPos.x, this.curPos.y - this.hitPos.y);
                Splash.this.setLocation(this.initPos.x + this.offset.x, this.initPos.y + this.offset.y);
            }
        };
        this.addMouseListener(motionListener);
        this.addMouseMotionListener(motionListener);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
    }

    public static final Splash getDefaultSplash() {
        return defaultSplash;
    }

    public static final void setDefaultSplash(Splash splash) {
        defaultSplash = splash;
    }

    public void next() {
        this.progress.setValue(this.progress.getValue() + 1);
    }
}

