/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.event.ChangeTracker;
import com.softlabs.warlords4.gui.Filler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SkillsPanel
extends JPanel
implements ActionListener {
    private static final String[] SKILLS_NAMES = new String[]{"Fame:", "Gate:", "Glory:", "Merchant:", "Defender:", "Anti-Magic:", "Chaos:", "Crusader:", "Weaponmaster:", "Morale:", "Engineer:", "Archmage:", "Divine Magic:", "Rune Magic:", "Nature Magic:", "Summoning:", "Necromancy:"};
    private static final Integer[] SKILLS_LIMITS = new Integer[]{new Integer(10), new Integer(10), new Integer(10), new Integer(10), new Integer(10), new Integer(10), new Integer(10), new Integer(10), new Integer(10), new Integer(10), new Integer(10), new Integer(10), new Integer(255), new Integer(255), new Integer(255), new Integer(255), new Integer(255)};
    private static final char[] SKILLS_MNEMONIC = new char[]{'B', 'G', 'l', 'M', 'V', 't', 'o', 'Z', 'W', 'P', 'E', 'i', 'D', 'u', 'N', 'S', 'y'};
    private static final String[] SKILLS_TOOLTIP = new String[]{"Fame: Increases your chance of being offered an ally every turn, decreases the cost of allies.", "Gate: Increases the strength of all units summoned with spells.", "Glory: Increases your chance of being offered a hero every turn, decreases the cost of heroes.", "Merchant: Increases your total gold income every turn.", "Defender: Increasing both life and damage from towers.", "Anti-Magic: Increases the resistance of all your groups to enemy magic. Cumulative with the Magic Immunity skill.", "Chaos: Chaos subtracts from the Morale of all enemy Warlords.", "Crusader: Extra movement and life, possibly extra attacks with Siege Weapons.", "Weapon Master: Adds extra XP to the pool of experience after each battle. Add XP to fresh units.", "Morale: A higher Morale will benefit you in combat.", "Engineer: Decreases costs of building and upgrading cities, Strengthening of towers.", "Archimage: Increases starting mana, maximum mana and mana regeneration rate.", "Divine Magic: Allows you to learn and cast spells devoted to Healing, Blessing and destruction of evil creatures.", "Rune Magic: Allows you to learn and cast spells devoted to stone, strength, earth and protection.", "Nature Magic: Allows you to learn and cast spells devoted to summoning and empowering monsters, improving production and income.", "Summoning: Allows you to learn and cast spells devoted to both fire, and summoning and empowering Daemons.", "Necromancy: Allows you to learn and cast spells devoted to raising and empowering Undead, and destroying good creatures."};
    private static final int[][] CLASSES_SKILLS = new int[][]{{1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 5, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1}, {1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 5, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 5, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1}, {1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 5, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1}, {1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 5}};
    private static final int MAXIMUM_MAGIC_SKILS = 5;
    private static final String ACTION_RESET_ALL = "Reset All";
    private static final String ACTION_MAX_ALL = "Max All";
    private static final String ACTION_GOD_MODE = "God Mode";
    private static final Integer BEST_MAGIC_MAX = new Integer(17);
    private static final Integer MAX_SKILL_LEVEL = new Integer(255);
    private JLabel[] skillsLabel;
    private JSpinner[] skills;
    private SpinnerNumberModel[] skillModels;
    private boolean limited;
    private int classType;
    private int activeSkills;
    private JPanel messagePanel;
    private boolean highLevel;
    private Font boldFont;

    public SkillsPanel() {
        super(new GridBagLayout());
        this.setName("WSkills");
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.bottom = 5;
        this.skillsLabel = new JLabel[17];
        this.skills = new JSpinner[17];
        this.skillModels = new SpinnerNumberModel[17];
        JPanel generalSkills = new JPanel(new GridLayout(0, 6, 5, 5));
        generalSkills.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("General"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        generalSkills.setOpaque(false);
        this.add((Component)generalSkills, gbConstraints);
        for (int i = 0; i < this.skills.length - 5; ++i) {
            this.skillsLabel[i] = new JLabel(SKILLS_NAMES[i]);
            this.skillsLabel[i].setDisplayedMnemonic(SKILLS_MNEMONIC[i]);
            this.skillsLabel[i].setToolTipText(SKILLS_TOOLTIP[i]);
            generalSkills.add(this.skillsLabel[i]);
            this.skillModels[i] = new SpinnerNumberModel(0, 0, 255, 1);
            this.skills[i] = new JSpinner(this.skillModels[i]);
            this.skills[i].setToolTipText(SKILLS_TOOLTIP[i]);
            this.skillsLabel[i].setLabelFor(this.skills[i]);
            generalSkills.add(this.skills[i]);
        }
        this.boldFont = this.skillsLabel[0].getFont().deriveFont(1);
        JPanel magicSkills = new JPanel(new GridLayout(0, 6, 5, 5));
        magicSkills.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Magic"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        magicSkills.setOpaque(false);
        this.add((Component)magicSkills, gbConstraints);
        for (int i = this.skills.length - 5; i < this.skills.length; ++i) {
            this.skillsLabel[i] = new JLabel(SKILLS_NAMES[i]);
            this.skillsLabel[i].setDisplayedMnemonic(SKILLS_MNEMONIC[i]);
            this.skillsLabel[i].setToolTipText(SKILLS_TOOLTIP[i]);
            magicSkills.add((Component)this.skillsLabel[i], gbConstraints);
            this.skillModels[i] = new SpinnerNumberModel(0, 0, 255, 1);
            this.skills[i] = new JSpinner(this.skillModels[i]);
            this.skills[i].setToolTipText(SKILLS_TOOLTIP[i]);
            this.skillsLabel[i].setLabelFor(this.skills[i]);
            magicSkills.add((Component)this.skills[i], gbConstraints);
        }
        this.messagePanel = new JPanel(new BorderLayout());
        this.messagePanel.setVisible(false);
        this.messagePanel.setOpaque(false);
        gbConstraints.insets.left = 3;
        this.add((Component)this.messagePanel, gbConstraints);
        gbConstraints.insets.left = 0;
        JLabel attention = new JLabel("Attention: ");
        attention.setFont(attention.getFont().deriveFont(1));
        attention.setToolTipText("See help for more details.");
        this.messagePanel.add((Component)attention, "West");
        JLabel message = new JLabel("Your warlord is now editable in High-Level mode.");
        message.setToolTipText(attention.getToolTipText());
        this.messagePanel.add((Component)message, "Center");
        gbConstraints.weighty = 1.0;
        gbConstraints.insets.bottom = 5;
        this.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        gbConstraints.insets.bottom = 0;
        gbConstraints.gridwidth = 1;
        this.add((Component)new Filler(), gbConstraints);
        JButton godMode = new JButton(ACTION_GOD_MODE);
        godMode.setActionCommand(ACTION_GOD_MODE);
        godMode.addActionListener(this);
        godMode.setToolTipText("Creaete a God Warlord!");
        godMode.setMnemonic(ACTION_GOD_MODE.charAt(0));
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.bottom = 5;
        gbConstraints.insets.right = 5;
        this.add((Component)godMode, gbConstraints);
        JButton maxAll = new JButton(ACTION_MAX_ALL);
        maxAll.setActionCommand(ACTION_MAX_ALL);
        maxAll.addActionListener(this);
        maxAll.setToolTipText("Put the default maximum to all available skills.");
        maxAll.setMnemonic(ACTION_MAX_ALL.charAt(0));
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.bottom = 5;
        this.add((Component)maxAll, gbConstraints);
        gbConstraints.gridwidth = 0;
        JButton resetAll = new JButton(ACTION_RESET_ALL);
        resetAll.setActionCommand(ACTION_RESET_ALL);
        resetAll.addActionListener(this);
        resetAll.setToolTipText("Reset all skills to their mimimum.");
        resetAll.setMnemonic(ACTION_RESET_ALL.charAt(0));
        gbConstraints.insets.right = 2;
        this.add((Component)resetAll, gbConstraints);
    }

    public int getSkillLevel(int target) {
        return ((Number)this.skills[target].getValue()).intValue();
    }

    public int getDevelopmentPoints() {
        int devPoints = 0;
        for (int i = 0; i < this.skills.length; ++i) {
            devPoints += this.getSkillLevel(i);
        }
        return devPoints - this.activeSkills;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public int getClassType() {
        return this.classType;
    }

    public boolean isHighLevel() {
        return this.highLevel && this.isLimited();
    }

    public void setClassType(int classType) {
        if (this.classType != classType) {
            this.classType = classType;
            this.ensureLimited();
        }
    }

    public void setSkillLevel(int target, int level) {
        this.skills[target].setValue(new Integer(level));
    }

    public void setLimited(boolean limited) {
        if (this.limited != limited) {
            this.limited = limited;
            this.ensureLimited();
        }
    }

    public void setHighLevel(boolean highLevel) {
        if (this.highLevel != highLevel) {
            this.highLevel = highLevel;
            this.ensureLimited();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.skillsLabel != null) {
            this.boldFont = this.skillsLabel[0].getFont().deriveFont(1);
            this.ensureLimited();
        }
    }

    public void ensureLimited() {
        this.activeSkills = 0;
        int classType = this.getClassType();
        if (this.isLimited()) {
            boolean highLevel = this.isHighLevel();
            for (int i = 0; i < this.skills.length; ++i) {
                if (CLASSES_SKILLS[classType][i] != 0) {
                    this.skills[i].setEnabled(true);
                    this.skillsLabel[i].setEnabled(true);
                    this.skillsLabel[i].setFont(this.boldFont);
                    this.skillModels[i].setMinimum(new Integer(CLASSES_SKILLS[classType][i]));
                    if (this.getSkillLevel(i) < CLASSES_SKILLS[classType][i]) {
                        this.setSkillLevel(i, CLASSES_SKILLS[classType][i]);
                    }
                    this.activeSkills += CLASSES_SKILLS[classType][i];
                } else {
                    this.skills[i].setEnabled(false);
                    this.skillsLabel[i].setEnabled(false);
                    this.skillsLabel[i].setFont(null);
                    this.skillModels[i].setMinimum(new Integer(0));
                    this.setSkillLevel(i, 0);
                }
                if (highLevel) {
                    this.skillModels[i].setMaximum(new Integer(255));
                    continue;
                }
                if (this.getSkillLevel(i) > SKILLS_LIMITS[i]) {
                    this.skills[i].setValue(SKILLS_LIMITS[i]);
                }
                this.skillModels[i].setMaximum(SKILLS_LIMITS[i]);
            }
            this.messagePanel.setVisible(highLevel);
        } else {
            for (int i = 0; i < this.skills.length; ++i) {
                this.skills[i].setEnabled(true);
                this.skillsLabel[i].setEnabled(true);
                if (CLASSES_SKILLS[classType][i] != 0) {
                    this.skillsLabel[i].setFont(this.boldFont);
                } else {
                    this.skillsLabel[i].setFont(null);
                }
                this.skillModels[i].setMinimum(new Integer(0));
                this.skillModels[i].setMaximum(new Integer(255));
            }
            this.messagePanel.setVisible(false);
        }
    }

    public void addChangeTracker(ChangeTracker tracker) {
        for (int i = 0; i < this.skills.length; ++i) {
            this.skills[i].addChangeListener(tracker);
        }
    }

    private void maxAll() {
        int i;
        for (i = 0; i < this.skills.length - 5; ++i) {
            if (!this.skills[i].isEnabled()) continue;
            this.skills[i].setValue(SKILLS_LIMITS[i]);
        }
        for (i = this.skills.length - 5; i < this.skills.length; ++i) {
            if (!this.skills[i].isEnabled()) continue;
            this.skills[i].setValue(BEST_MAGIC_MAX);
        }
    }

    private void godMode() {
        int result = JOptionPane.showConfirmDialog(this, "Do you really want to set god like skill levels?\nThis might cause the game to behave strangely\non some occasions and ensures you always win,\nwhatever army you throw in the game.", "Set God Like Skills?", 2, 2);
        if (result == 0) {
            for (int i = 0; i < this.skills.length; ++i) {
                if (!this.skills[i].isEnabled()) continue;
                this.skills[i].setValue(MAX_SKILL_LEVEL);
            }
        }
    }

    public void resetAll(boolean force) {
        int level;
        int currentLevel;
        int i;
        int classType = this.getClassType();
        for (i = 0; i < this.skills.length - 5; ++i) {
            if (this.skills[i].isEnabled()) {
                if (force) {
                    this.setSkillLevel(i, CLASSES_SKILLS[classType][i]);
                    continue;
                }
                currentLevel = this.getSkillLevel(i);
                level = CLASSES_SKILLS[classType][i];
                level = currentLevel == 1 && CLASSES_SKILLS[classType][i] == 0 ? 0 : Math.max(level, currentLevel);
                this.setSkillLevel(i, level);
                continue;
            }
            this.setSkillLevel(i, 0);
        }
        for (i = this.skills.length - 5; i < this.skills.length; ++i) {
            if (this.skills[i].isEnabled()) {
                if (force) {
                    this.setSkillLevel(i, CLASSES_SKILLS[classType][i]);
                    continue;
                }
                currentLevel = this.getSkillLevel(i);
                level = CLASSES_SKILLS[classType][i];
                level = (currentLevel == 1 || currentLevel == 5) && CLASSES_SKILLS[classType][i] == 0 ? 0 : Math.max(level, currentLevel);
                this.setSkillLevel(i, level);
                continue;
            }
            this.setSkillLevel(i, 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (ACTION_MAX_ALL.equals(command)) {
            this.maxAll();
        } else if (ACTION_RESET_ALL.equals(command)) {
            this.resetAll(true);
        } else if (ACTION_GOD_MODE.equals(command)) {
            this.godMode();
        }
    }
}

