/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.gui.Filler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class SequenceButtonPanel
extends JPanel {
    public static final String KEY_BACK = "backKey";
    public static final String KEY_NEXT = "nextKey";
    public static final String KEY_CANCEL = "cancelKey";
    private static final String BACK_VALUE = "Back";
    private static final String NEXT_VALUE = "Next";
    private static final String CANCEL_VALUE = "Cancel";
    private static final String ACTION_TAG = "SB@";
    public static final String ACTION_BACK = "SB@Back";
    public static final String ACTION_NEXT = "SB@Next";
    public static final String ACTION_CANCEL = "SB@Cancel";
    private JButton back;
    private JButton next;
    private JButton cancel;

    public SequenceButtonPanel() {
        super(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 0.0;
        gbConstraints.fill = 1;
        gbConstraints.insets.bottom = 5;
        gbConstraints.insets.top = 10;
        gbConstraints.weightx = 1.0;
        this.add((Component)new Filler(), gbConstraints);
        gbConstraints.weightx = 0.0;
        this.back = new JButton("<< Back");
        this.back.setActionCommand(ACTION_BACK);
        this.back.setToolTipText("Go one step back");
        this.back.setMnemonic(BACK_VALUE.charAt(0));
        gbConstraints.insets.right = 5;
        this.add((Component)this.back, gbConstraints);
        this.next = new JButton("Next >>");
        this.next.setActionCommand(ACTION_NEXT);
        this.next.setToolTipText("Next Step");
        this.next.setMnemonic(NEXT_VALUE.charAt(0));
        this.next.setEnabled(false);
        this.add((Component)this.next, gbConstraints);
        this.cancel = new JButton(CANCEL_VALUE);
        this.cancel.setActionCommand(ACTION_CANCEL);
        this.cancel.setToolTipText("Close the Dialog");
        this.cancel.setMnemonic(CANCEL_VALUE.charAt(0));
        gbConstraints.insets.right = 0;
        this.add((Component)this.cancel, gbConstraints);
    }

    public boolean isBackEnabled() {
        return this.back.isEnabled();
    }

    public boolean isNextEnabled() {
        return this.next.isEnabled();
    }

    public void addActionListener(ActionListener listener) {
        this.back.addActionListener(listener);
        this.cancel.addActionListener(listener);
        this.next.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.back.removeActionListener(listener);
        this.cancel.removeActionListener(listener);
        this.next.removeActionListener(listener);
    }

    public void setBackEnabled(boolean enable) {
        this.back.setEnabled(enable);
    }

    public void setNextEnabled(boolean enable) {
        this.next.setEnabled(enable);
    }

    public void setCustomizeNextButton(String label, String toolTip, int mnemonic) {
        if (label == null) {
            this.next.setText("Next >>");
        } else {
            this.next.setText(label);
        }
        if (toolTip != null) {
            this.next.setToolTipText(toolTip);
        } else {
            this.next.setToolTipText("Next Step");
        }
        if (mnemonic != -1) {
            this.next.setMnemonic(mnemonic);
        } else {
            this.next.setMnemonic(NEXT_VALUE.charAt(0));
        }
    }

    public void installDefaultButton() {
        RootPaneContainer root = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this));
        if (root != null) {
            root.getRootPane().setDefaultButton(this.cancel);
        }
    }
}

