/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.data.ApplicationPreferences;
import com.softlabs.warlords4.event.ChangeTracker;
import com.softlabs.warlords4.gui.Filler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class ProxyPanel
extends JPanel {
    private JCheckBox proxyUsed;
    private Preferences preferences;
    private JSpinner proxyPort;
    private JTextField proxyHost;

    public ProxyPanel() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.bottom = 5;
        JPanel proxy = new JPanel(new GridBagLayout());
        proxy.setBorder(BorderFactory.createTitledBorder("Proxy"));
        this.add((Component)proxy, gbConstraints);
        this.proxyUsed = new JCheckBox("Use proxy gate");
        this.proxyUsed.setToolTipText("Use a proxy gate to connect the internet");
        this.proxyUsed.setMnemonic('U');
        gbConstraints.insets.left = 5;
        gbConstraints.insets.right = 10;
        proxy.add((Component)this.proxyUsed, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        JLabel proxyHostLabel = new JLabel("Host:");
        proxyHostLabel.setToolTipText("Host name of the proxy server");
        proxyHostLabel.setDisplayedMnemonic('H');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 9;
        proxy.add((Component)proxyHostLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.proxyHost = new JTextField(16);
        this.proxyHost.setToolTipText(proxyHostLabel.getToolTipText());
        proxyHostLabel.setLabelFor(this.proxyHost);
        gbConstraints.insets.right = 10;
        proxy.add((Component)this.proxyHost, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel proxyPortLabel = new JLabel("Port:");
        proxyPortLabel.setToolTipText("Port number of the proxy server");
        proxyPortLabel.setDisplayedMnemonic('P');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 9;
        proxy.add((Component)proxyPortLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.proxyPort = new JSpinner(new SpinnerNumberModel(8080, 0, 65536, 1));
        this.proxyPort.setToolTipText(proxyPortLabel.getToolTipText());
        proxyPortLabel.setLabelFor(this.proxyPort);
        gbConstraints.insets.right = 10;
        proxy.add((Component)this.proxyPort, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.weighty = 1.0;
        this.add((Component)new Filler(), gbConstraints);
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    public void load() {
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            this.proxyUsed.setSelected(preferences.getBoolean("proxyUsed", false));
            this.proxyHost.setText(preferences.get("proxyHost", ApplicationPreferences.DEFAULT_PROXY_HOST));
            this.proxyPort.setValue(new Integer(preferences.getInt("proxyPort", ApplicationPreferences.DEFAULT_PROXY_PORT)));
        } else {
            this.proxyUsed.setSelected(false);
            this.proxyHost.setText(ApplicationPreferences.DEFAULT_PROXY_HOST);
            this.proxyPort.setValue(new Integer(ApplicationPreferences.DEFAULT_PROXY_PORT));
        }
    }

    public void save() {
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            preferences.putBoolean("proxyUsed", this.proxyUsed.isSelected());
            preferences.put("proxyHost", this.proxyHost.getText());
            preferences.putInt("proxyPort", ((Number)this.proxyPort.getValue()).intValue());
        }
    }

    public void addChangeTracker(ChangeTracker tracker) {
        this.proxyUsed.addActionListener(tracker);
        this.proxyHost.getDocument().addDocumentListener(tracker);
        this.proxyPort.addChangeListener(tracker);
    }
}

