/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.event.ChangeTracker;
import com.softlabs.warlords4.gui.Filler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ProvincesPanel
extends JPanel
implements ActionListener {
    private static final String[] PROVINCES_NAME = new String[]{"The Storm Hills", "Giantridge Mountains", "The Doomwood", "Bartonia", "Dragon Realm", "Khaz-Agar", "Selentia", "Ehlariel", "The Broken Marsh", "Malbec", "Siria", "Southern Selentia", "Drak-Dum", "White Mountains", "Kor", "Zhur", "Sserin Jungle", "Realms of Plague", "Barad Dumyr", "Silvermyr", "Elenia", "The Borderlands", "Mountains of Agaria", "Northern Kor", "Southern Kor", "Colis Tarn", "Lysea", "Goblin Mountains", "Ylarie", "Theira", "The Trarg", "The Plains of Ar"};
    private static final char[] PROVINCES_MNEMONIC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'S', 'o', 'D', 'W', 'K', 'Z', 'J', 'P', 'B', 'v', 'E', 'n', 'M', 'Q', 'u', 'X', 'L', 'G', 'Y', 'T', '.', 'i'};
    private static final String[] PROVINCES_DESCRIPTION = new String[]{"Your northern provinces were attacked by Daemons who raided their libraries.", "You searched for the Sorceress Aravein but found her citadel deserted.", "You approached King Garranoth, seeking guidance. He told you of concerns about Aravein - that she may be seeking to cast the spell of sundering.", "You stole the Dragonstone from the Sirian Knights to aid you in approaching the Dragons.", "You fought your way to speak with Kelthurax, the Ancient Dragon, so that you might learn about the Sundering.", "You raided the Dwarven Halls of Khaz-Agar to appease Kelthurax and gain some answers from him.", "You raided the Selentine Empire to gain more answers from Kelthurax.", "You attacked the Citadel of Ice to obtain a counterspell that might stop Aravein casting the spell of sundering.", "You fought your way across the Broken Marsh toward Malbec where Aravein was attempting to cast the spell.", "You defeated Aravein and saved the Realms of Etheria.", "Siria is home to the Sirian Knights. If you conquer this province you may lead the Knights in future battles (or gain +1 Morale if they are your favored race).", "Southern Selentia holds most of the Imperial Military. If you conquer this province you may lead the Empire in future battles (or gain +1 Morale if they are your favored race).", "Drak-Dum is the ancestral home of the Dwarves. If you conquer this province you may lead the Dwarves in future battles (or gain +1 Morale if they are your favored race).", "Ogres and Giants infest these mountains. If you conquer this province you may lead the Ogres in future battles (or gain +1 Morale if they are your favored race).", "Kor is home to many large tribes of Orcs. If you conquer this province you may lead the Orcs in future battles (or gain +1 Morale if they are your favored race).", "Zhur is ruled by a cruel Lichelord. If you conquer this province you may lead the Undead in future battles (or gain +1 Morale if they are your favored race).", "The Sserin Jungle has recently been conquered by Eldakkar's Dark Elves. If you conquer this province you may lead the Dark Elves in future battles (or gain +1 Morale if they are your favored race).", "The Realms of Plague are home to the Daemon Lord, Antharg. If you conquer this province you may lead the Daemons in future battles (or gain +1 Morale if they are your favored race).", "Many dragons live amidst the peaks of the Barad Dumyr. If you conquer this province you may lead the Dragons in future battles (or gain +1 Morale if they are your favored race).", "Elves inhabit the fair woodland city of Silvermyr. If you conquer this province you may lead the Elves in future battles (or gain +1 Morale if they are your favored race).", "If you conquer Elenia, the mighty Knight Hero, Sir Albion, will join you in your next battle.", "If you conquer the Borderlands, the Emperor's daughter, Lady Selentia, will join you in your next battle.", "If you conquer the Mountains of Agaria, the mighty Dwarven Hero, Lord Kharik, will join you in your next battle.", "If you conquer Northern Kor, the mighty Ogre Hero, Ogrock, will join you in your next battle.", "If you conquer Southern Kor, the mighty Orkish Hero, Skull-splitter, will join you in your next battle.", "If you conquer Colis Tarn, the ancient Undead Hero, Lord Ghuldarkar, will join you in your next battle.", "If you conquer Lysea, the evil Dark Elven Hero, Velaxia, will join you in your next battle.", "If you conquer the Goblin Mountains, the mighty Daemon Hero, Thulcondar, will join you in your next battle.", "If you conquer Ylarie, then Sir Arakus, Lord of Dragons, will join you in your next battle.", "If you conquer Theira, the fair Elven Hero, Brianna, will join you in your next battle.", "If you conquer the Trarg, their fine horses will grant you +3 Speed in your next battle.", "If you conquer the Plains of Ar, then its untapped wealth will grant you 1000 extra Gold in your next battle."};
    private static final int MAXIMUM_STORYLINE = 10;
    private static final int MAXIMUM_EXTRA_MISSION = 22;
    private static final int[][] PROVINCES_LINKS = new int[][]{{1, 2, 12}, {0, 12, 15, 16, 25}, {0, 12, 26}, {10, 20, 22, 29}, {14, 23, 24}, {10, 14, 18, 22, 29}, {11, 19, 20}, {28, 19}, {9, 26}, {8}, {3, 5, 22, 29}, {6, 15, 20, 30}, {0, 1, 2, 26}, {18, 23, 28, 31}, {4, 5, 18, 22, 23, 24}, {1, 11, 21, 26}, {1, 21, 25, 27}, {27}, {5, 13, 14, 23, 29, 31}, {6, 7, 31}, {3, 6, 11, 22, 30}, {15, 16, 22, 27}, {3, 5, 10, 20, 14, 21, 24, 27, 30}, {4, 13, 14, 18}, {14, 17, 22, 27}, {1, 16}, {2, 8, 12, 15}, {16, 17, 21, 22, 24}, {7, 13}, {3, 5, 10, 18}, {11, 20, 22}, {13, 18, 19, 23}};
    private static final String ACTION_SELECT_ALL = "Select All";
    private static final String ACTION_UNSELECT_ALL = "Unselect All";
    private JCheckBox[] provinces;

    public ProvincesPanel() {
        super(new GridBagLayout());
        this.setName("WProvinces");
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.bottom = 5;
        this.provinces = new JCheckBox[32];
        JPanel storyline = new JPanel(new GridLayout(0, 4, 2, 2));
        storyline.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Storyline"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        storyline.setOpaque(false);
        this.add((Component)storyline, gbConstraints);
        for (int i = 0; i < 10; ++i) {
            this.provinces[i] = new JCheckBox(PROVINCES_NAME[i]);
            this.provinces[i].setToolTipText(PROVINCES_DESCRIPTION[i]);
            this.provinces[i].setMnemonic(PROVINCES_MNEMONIC[i]);
            this.provinces[i].addActionListener(this);
            this.provinces[i].setOpaque(false);
            storyline.add(this.provinces[i]);
        }
        JPanel extraMissions = new JPanel(new GridLayout(0, 4, 2, 2));
        extraMissions.setOpaque(false);
        extraMissions.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Extra Missions"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.add((Component)extraMissions, gbConstraints);
        for (int i = 10; i < 32; ++i) {
            this.provinces[i] = new JCheckBox(PROVINCES_NAME[i]);
            this.provinces[i].setToolTipText(PROVINCES_DESCRIPTION[i]);
            this.provinces[i].setMnemonic(PROVINCES_MNEMONIC[i]);
            this.provinces[i].addActionListener(this);
            this.provinces[i].setOpaque(false);
            extraMissions.add(this.provinces[i]);
        }
        gbConstraints.weighty = 1.0;
        gbConstraints.insets.bottom = 5;
        this.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        gbConstraints.insets.bottom = 0;
        gbConstraints.gridwidth = 1;
        this.add((Component)new Filler(), gbConstraints);
        JButton selectAll = new JButton(ACTION_SELECT_ALL);
        selectAll.setActionCommand(ACTION_SELECT_ALL);
        selectAll.addActionListener(this);
        selectAll.setToolTipText("Select all Provinces");
        selectAll.setMnemonic(ACTION_SELECT_ALL.charAt(0));
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.bottom = 5;
        gbConstraints.insets.right = 5;
        this.add((Component)selectAll, gbConstraints);
        gbConstraints.gridwidth = 0;
        JButton unselectAll = new JButton(ACTION_UNSELECT_ALL);
        unselectAll.setActionCommand(ACTION_UNSELECT_ALL);
        unselectAll.addActionListener(this);
        unselectAll.setToolTipText("Unselect all Provinces");
        unselectAll.setMnemonic(ACTION_UNSELECT_ALL.charAt(0));
        gbConstraints.insets.right = 2;
        this.add((Component)unselectAll, gbConstraints);
        this.setState();
    }

    public boolean isSelected(int target) {
        return this.provinces[target].isSelected();
    }

    public void setSelected(int target, boolean selected) {
        this.provinces[target].setSelected(selected);
        this.setState();
    }

    public void addChangeTracker(ChangeTracker tracker) {
        for (int i = 0; i < this.provinces.length; ++i) {
            this.provinces[i].addActionListener(tracker);
        }
    }

    public void setState() {
        int i;
        for (i = 1; i < 10; ++i) {
            this.provinces[i].setEnabled(this.provinces[i - 1].isSelected());
            if (this.provinces[i].isEnabled()) continue;
            this.provinces[i].setSelected(false);
        }
        for (i = 10; i < 32; ++i) {
            int[] links = PROVINCES_LINKS[i];
            boolean selected = false;
            for (int j = 0; j < links.length; ++j) {
                selected |= this.provinces[links[j]].isSelected();
            }
            this.provinces[i].setEnabled(selected);
            if (this.provinces[i].isEnabled()) continue;
            this.provinces[i].setSelected(false);
        }
    }

    private void selectAll(boolean select) {
        for (int i = 0; i < this.provinces.length; ++i) {
            this.provinces[i].setSelected(select);
        }
        this.setState();
        ActionListener[] listener = this.provinces[0].getActionListeners();
        ActionEvent event = new ActionEvent(this.provinces[0], 1001, this.provinces[0].getActionCommand());
        for (int i = 0; i < listener.length; ++i) {
            listener[i].actionPerformed(event);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (ACTION_SELECT_ALL.equals(event.getActionCommand())) {
            this.selectAll(true);
        } else if (ACTION_UNSELECT_ALL.equals(event.getActionCommand())) {
            this.selectAll(false);
        } else {
            this.setState();
        }
    }
}

