/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.data.ApplicationPreferences;
import com.softlabs.warlords4.event.ChangeTracker;
import com.softlabs.warlords4.gui.FileSelectionField;
import com.softlabs.warlords4.gui.Filler;
import com.softlabs.warlords4.gui.ProxyDialog;
import com.softlabs.warlords4.gui.plaf.LookAndFeelManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PreferencesPanel
extends JPanel
implements ActionListener {
    private static final String ACTION_PROXY = "Proxy";
    private JSpinner history;
    private JCheckBox backup;
    private JCheckBox autoLoad;
    private JCheckBox update;
    private FileSelectionField gameRoot;
    private Preferences preferences;
    private JRadioButton localHelp;
    private JRadioButton onlineHelp;
    private ProxyDialog proxyDialog;
    private JComboBox plaf;

    public PreferencesPanel() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.bottom = 5;
        JPanel saveLoad = new JPanel(new GridBagLayout());
        saveLoad.setBorder(BorderFactory.createTitledBorder("Load / Save"));
        this.add((Component)saveLoad, gbConstraints);
        JLabel gameRootLabel = new JLabel("Game Root:");
        gameRootLabel.setToolTipText("Game Root: Path to the folder where the game is installed.");
        gameRootLabel.setDisplayedMnemonic('G');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 9;
        saveLoad.add((Component)gameRootLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.gameRoot = new FileSelectionField();
        this.gameRoot.setToolTipText(gameRootLabel.getToolTipText());
        this.gameRoot.setDirectoryOnly(true);
        gameRootLabel.setLabelFor(this.gameRoot);
        gbConstraints.insets.right = 10;
        saveLoad.add((Component)this.gameRoot, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel historyLabel = new JLabel("History:");
        historyLabel.setToolTipText("History: Number of warlord files the application must remember.");
        historyLabel.setDisplayedMnemonic('H');
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 9;
        saveLoad.add((Component)historyLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.history = new JSpinner(new SpinnerNumberModel(1, 1, 9, 1));
        this.history.setToolTipText(historyLabel.getToolTipText());
        historyLabel.setLabelFor(this.history);
        gbConstraints.insets.right = 10;
        saveLoad.add((Component)this.history, gbConstraints);
        gbConstraints.insets.right = 0;
        this.autoLoad = new JCheckBox("Auto Load last Warlord");
        this.autoLoad.setToolTipText("Auto Load: Load the latest saved warlord, when not set create a new warlord.");
        this.autoLoad.setMnemonic('t');
        gbConstraints.insets.left = 5;
        gbConstraints.insets.right = 10;
        saveLoad.add((Component)this.autoLoad, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        this.backup = new JCheckBox("Backup Warlord");
        this.backup.setToolTipText("Backup: Create a backup file of the warlord before saving.");
        this.backup.setMnemonic('k');
        gbConstraints.insets.left = 5;
        gbConstraints.insets.right = 10;
        saveLoad.add((Component)this.backup, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        JPanel updates = new JPanel(new GridBagLayout());
        updates.setBorder(BorderFactory.createTitledBorder("Updates"));
        this.add((Component)updates, gbConstraints);
        this.update = new JCheckBox("Updates Automated");
        this.update.setToolTipText("Updates: automatically check the server for new versions and start updating.");
        this.update.setMnemonic('U');
        gbConstraints.insets.left = 5;
        gbConstraints.insets.right = 10;
        gbConstraints.gridwidth = 1;
        updates.add((Component)this.update, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.gridwidth = 0;
        JButton proxy = new JButton(ACTION_PROXY);
        proxy.setToolTipText("Set proxy settings");
        proxy.setActionCommand(ACTION_PROXY);
        proxy.addActionListener(this);
        proxy.setMnemonic('P');
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 10;
        updates.add((Component)proxy, gbConstraints);
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        JPanel help = new JPanel(new GridBagLayout());
        help.setBorder(BorderFactory.createTitledBorder("Help"));
        this.add((Component)help, gbConstraints);
        JLabel targetLabel = new JLabel("Target:");
        targetLabel.setToolTipText("Target: Choose where the help must come from.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 9;
        help.add((Component)targetLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        this.localHelp = new JRadioButton("Local");
        this.localHelp.setMnemonic('L');
        this.localHelp.setToolTipText("Use the help that comes with the editor.");
        gbConstraints.insets.right = 5;
        help.add((Component)this.localHelp, gbConstraints);
        gbConstraints.insets.right = 0;
        this.onlineHelp = new JRadioButton("Online");
        this.onlineHelp.setMnemonic('O');
        this.onlineHelp.setToolTipText("Use the most up-to-date help on-line (Needs an Internet connection)");
        gbConstraints.gridwidth = 0;
        help.add((Component)this.onlineHelp, gbConstraints);
        ButtonGroup group = new ButtonGroup();
        group.add(this.localHelp);
        group.add(this.onlineHelp);
        JPanel plaf = new JPanel(new GridBagLayout());
        plaf.setBorder(BorderFactory.createTitledBorder("Look & Feel"));
        this.add((Component)plaf, gbConstraints);
        this.plaf = new JComboBox();
        this.plaf.setToolTipText("Look & Feel: Select your preferred User Interface.");
        gbConstraints.gridwidth = 0;
        plaf.add((Component)this.plaf, gbConstraints);
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lafInfo.length; ++i) {
            this.plaf.addItem(new LAFWrapper(lafInfo[i]));
        }
        this.plaf.setSelectedItem("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        this.plaf.addActionListener(new ChangeLookAndFeelAction());
        gbConstraints.weighty = 1.0;
        this.add((Component)new Filler(), gbConstraints);
        int width = 0;
        int maxWidth = 0;
        width = gameRootLabel.getPreferredSize().width;
        if (maxWidth < width) {
            maxWidth = width;
        }
        if (maxWidth < (width = historyLabel.getPreferredSize().width)) {
            maxWidth = width;
        }
        if (maxWidth < (width = targetLabel.getPreferredSize().width)) {
            maxWidth = width;
        }
        Dimension size = new Dimension(maxWidth, 10);
        gameRootLabel.setPreferredSize(size);
        historyLabel.setPreferredSize(size);
        targetLabel.setPreferredSize(size);
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    private void setLAF(String laf) {
        LAFWrapper item = null;
        ComboBoxModel model = this.plaf.getModel();
        for (int iterator = model.getSize() - 1; iterator >= 0 && item == null; --iterator) {
            item = (LAFWrapper)model.getElementAt(iterator);
            if (item.getLAF().equals(laf)) continue;
            item = null;
        }
        if (item != null) {
            this.plaf.setSelectedItem(item);
        }
    }

    public void load() {
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            this.gameRoot.setPath(preferences.get("gameRoot", ApplicationPreferences.DEFAULT_GAME_ROOT));
            this.history.setValue(new Integer(preferences.getInt("history", 4)));
            this.autoLoad.setSelected(preferences.getBoolean("autoLoad", false));
            this.backup.setSelected(preferences.getBoolean("backup", false));
            if (preferences.getBoolean("localHelp", true)) {
                this.localHelp.setSelected(true);
            } else {
                this.onlineHelp.setSelected(true);
            }
            this.update.setSelected(preferences.getBoolean("autoUpdate", true));
            this.setLAF(preferences.get("plaf", "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel"));
        } else {
            this.gameRoot.setPath(ApplicationPreferences.DEFAULT_GAME_ROOT);
            this.history.setValue(new Integer(4));
            this.autoLoad.setSelected(false);
            this.backup.setSelected(false);
            this.localHelp.setSelected(true);
            this.update.setSelected(true);
            this.setLAF("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
    }

    public void save() {
        Preferences preferences = this.getPreferences();
        if (preferences != null) {
            String root = this.gameRoot.getPath();
            if (root != null && (root = root.trim()).length() == 0) {
                root = null;
            }
            if (root == null) {
                preferences.remove("gameRoot");
            } else {
                preferences.put("gameRoot", root);
            }
            preferences.putInt("history", ((Number)this.history.getValue()).intValue());
            preferences.putBoolean("backup", this.backup.isSelected());
            preferences.putBoolean("autoLoad", this.autoLoad.isSelected());
            preferences.putBoolean("localHelp", this.localHelp.isSelected());
            preferences.putBoolean("autoUpdate", this.update.isSelected());
            preferences.put("plaf", ((LAFWrapper)this.plaf.getSelectedItem()).getLAF());
        }
    }

    public void addChangeTracker(ChangeTracker tracker) {
        this.gameRoot.addChangeTracker(tracker);
        this.backup.addActionListener(tracker);
        this.autoLoad.addActionListener(tracker);
        this.history.addChangeListener(tracker);
        this.update.addActionListener(tracker);
        this.localHelp.addActionListener(tracker);
        this.onlineHelp.addActionListener(tracker);
        this.plaf.addActionListener(tracker);
    }

    private void proxy() {
        if (this.proxyDialog == null) {
            this.proxyDialog = new ProxyDialog((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this));
            this.proxyDialog.setPreferences(this.getPreferences());
        }
        this.proxyDialog.reset();
        this.proxyDialog.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (ACTION_PROXY.equals(command)) {
            this.proxy();
        }
    }

    private final class ChangeLookAndFeel
    implements Runnable {
        public final LAFWrapper laf;

        public ChangeLookAndFeel(LAFWrapper laf) {
            this.laf = laf;
        }

        @Override
        public void run() {
            LookAndFeelManager.setLookAndFeel(this.laf.info.getClassName(), true);
        }
    }

    private final class ChangeLookAndFeelAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent event) {
            SwingUtilities.invokeLater(new ChangeLookAndFeel((LAFWrapper)((JComboBox)event.getSource()).getSelectedItem()));
        }
    }

    private final class LAFWrapper {
        UIManager.LookAndFeelInfo info;

        public LAFWrapper(UIManager.LookAndFeelInfo info) {
            this.info = info;
        }

        public String toString() {
            return this.info.getName();
        }

        public String getLAF() {
            return this.info.getClassName();
        }

        public int hashCode() {
            return this.info.getClassName().hashCode();
        }

        public boolean equals(Object object) {
            boolean equal;
            if (object == this) {
                equal = true;
            } else if (object instanceof LAFWrapper) {
                equal = this.info.equals(((LAFWrapper)object).info);
            } else {
                equal = this.info.getClassName().equals(object);
                if (!equal) {
                    equal = this.info.getName().equals(object);
                }
            }
            return equal;
        }
    }
}

