/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.gui.ApplicationDialog;
import com.softlabs.warlords4.image.ResourceIcon;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MessageDialog
extends ApplicationDialog {
    private static final String TEXT_HEADER = "<html><head><title>No Data</title></head><body style=\"";
    private static final String TEXT_MIDDLE = "\"><div>";
    private static final String TEXT_FOOTER = "</div></body></html>";
    private static final String ACTION_OK = "OK";
    private static final String ACTION_CANCEL = "Cancel";
    private static final String ACTION_YES = "Yes";
    private static final String ACTION_NO = "No";
    private static final Icon ICON_WARNING = new ResourceIcon("com/softlabs/warlords4/rsc/icon-warning.png");
    private static final Icon ICON_QUESTION = new ResourceIcon("com/softlabs/warlords4/rsc/icon-question.png");
    private static final Icon ICON_ABOUT = new ResourceIcon("com/softlabs/warlords4/rsc/icon-about.png");
    private static final Icon ICON_ERROR = new ResourceIcon("com/softlabs/warlords4/rsc/icon-error.png");
    public static final int TYPE_QUESTION = 1;
    public static final int TYPE_WARNING = 2;
    public static final int TYPE_ABOUT = 3;
    public static final int TYPE_ERROR = 4;
    public static final int OPTION_CLOSED = 0;
    public static final int OPTION_CANCEL = 2;
    public static final int OPTION_NO = 4;
    public static final int OPTION_OK = 8;
    public static final int OPTION_YES = 16;
    public static final int OPTION_CUSTOM = 32;
    private JLabel message;
    private JLabel icon;
    private int returnValue = 0;

    public MessageDialog(JDialog owner, String title, boolean modal, int type, int mask) {
        super(owner, title, modal);
        this.init(type, mask);
    }

    public MessageDialog(JFrame owner, String title, boolean modal, int type, int mask) {
        super(owner, title, modal);
        this.init(type, mask);
    }

    private void init(int type, int mask) {
        JComponent root = (JComponent)this.getContentPane();
        root.setLayout(new GridBagLayout());
        root.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        Icon icon = null;
        switch (type) {
            case 4: {
                icon = ICON_ERROR;
                break;
            }
            case 3: {
                icon = ICON_ABOUT;
                break;
            }
            case 2: {
                icon = ICON_WARNING;
                break;
            }
            default: {
                icon = ICON_QUESTION;
            }
        }
        this.icon = new JLabel(icon);
        this.icon.setVerticalAlignment(1);
        this.icon.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 10));
        this.icon.setOpaque(false);
        constraints.insets.right = 10;
        constraints.gridx = 0;
        constraints.gridy = 0;
        root.add((Component)this.icon, constraints);
        constraints.insets.right = 0;
        this.message = new JLabel();
        this.message.setOpaque(false);
        this.message.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.message.setFocusable(false);
        this.message.setRequestFocusEnabled(false);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 1;
        constraints.gridwidth = 0;
        root.add((Component)this.message, constraints);
        constraints.insets.bottom = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MessageDialog.this.setReturnValue(Integer.parseInt(event.getActionCommand()));
                MessageDialog.this.setVisible(false);
            }
        };
        mask &= 0x3E;
        JPanel buttonPane = new JPanel(new GridLayout(1, 1, 0, 0));
        constraints.gridwidth = 0;
        constraints.insets.top = 10;
        constraints.gridx = 0;
        constraints.gridy = 4;
        root.add((Component)buttonPane, constraints);
        if ((mask & 8) != 0) {
            JButton ok = new JButton(ACTION_OK);
            ok.setMnemonic(ACTION_OK.charAt(0));
            ok.setActionCommand(Integer.toString(8));
            ok.setToolTipText(ACTION_OK);
            ok.addActionListener(listener);
            mask &= 0xFFFFFFF7;
            buttonPane.add(ok);
            if (this.getRootPane().getDefaultButton() == null) {
                this.getRootPane().setDefaultButton(ok);
            }
        }
        if ((mask & 0x10) != 0) {
            JButton yes = new JButton(ACTION_YES);
            yes.setMnemonic(ACTION_YES.charAt(0));
            yes.setActionCommand(Integer.toString(16));
            yes.setToolTipText(ACTION_YES);
            yes.addActionListener(listener);
            buttonPane.add(yes);
            if (this.getRootPane().getDefaultButton() == null) {
                this.getRootPane().setDefaultButton(yes);
            }
        }
        if ((mask & 2) != 0) {
            JButton cancel = new JButton(ACTION_CANCEL);
            cancel.setMnemonic(ACTION_CANCEL.charAt(0));
            cancel.setActionCommand(Integer.toString(2));
            cancel.setToolTipText(ACTION_CANCEL);
            cancel.addActionListener(listener);
            buttonPane.add(cancel);
            if (this.getRootPane().getDefaultButton() == null) {
                this.getRootPane().setDefaultButton(cancel);
            }
        }
        if ((mask & 4) != 0) {
            JButton no = new JButton(ACTION_NO);
            no.setMnemonic(ACTION_NO.charAt(0));
            no.setActionCommand(Integer.toString(4));
            no.setToolTipText(ACTION_NO);
            no.addActionListener(listener);
            buttonPane.add(no);
            if (this.getRootPane().getDefaultButton() == null) {
                this.getRootPane().setDefaultButton(no);
            }
        }
        this.setMessage(" ");
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    protected void setReturnValue(int returnValue) {
        this.returnValue = returnValue;
    }

    public void setIcon(Icon icon) {
        this.icon.setIcon(icon);
    }

    public void setMessage(String message) {
        if (message == null || message.length() == 0) {
            message = "<b>No Message</b>";
        }
        try {
            StringBuffer buffer = new StringBuffer(256);
            buffer.append(TEXT_HEADER);
            buffer.append(TEXT_MIDDLE);
            buffer.append(message);
            buffer.append(TEXT_FOOTER);
            this.message.setText(buffer.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.isVisible()) {
            this.setReturnValue(0);
            JButton defaultButton = this.getRootPane().getDefaultButton();
            if (defaultButton != null) {
                defaultButton.requestFocusInWindow();
            }
        }
        super.setVisible(visible);
    }

    @Override
    public void pack() {
        if (this.message != null) {
            this.message.setSize(this.message.getPreferredSize());
        }
        super.pack();
    }

    public int showDialog() {
        this.setVisible(true);
        this.getRootPane().getDefaultButton().requestFocus();
        return this.getReturnValue();
    }
}

