/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.gui.HelpViewer;
import com.softlabs.warlords4.util.BrowserLauncher;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.JTabbedPane;

public class HelpKeyEventDispatcher
implements KeyEventDispatcher {
    private static HelpViewer viewer;

    private HelpKeyEventDispatcher() {
    }

    public static final void setHelpViewer(HelpViewer viewer) {
        HelpKeyEventDispatcher.viewer = viewer;
    }

    public static final void installHelp() {
        HelpKeyEventDispatcher keyDispatcher = new HelpKeyEventDispatcher();
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(keyDispatcher);
    }

    public static final void showHelp(Component component) {
        if (component instanceof JTabbedPane) {
            JTabbedPane pane = (JTabbedPane)component;
            component = pane.getSelectedComponent();
        }
        String topic = component.getName();
        for (Container comp = component.getParent(); topic == null && comp != null; comp = comp.getParent()) {
            topic = comp.getName();
        }
        if (topic != null && topic.startsWith("null")) {
            topic = null;
        }
        try {
            if (viewer != null) {
                viewer.showHelpTopic(topic);
            } else if (topic != null) {
                BrowserLauncher.openURL(topic);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.isConsumed()) {
            return false;
        }
        if (event.getID() == 401 && event.getKeyCode() == 112) {
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            HelpKeyEventDispatcher.showHelp(manager.getFocusOwner());
        }
        return event.isConsumed();
    }
}

