/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.data.LabelIconProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.UIManager;

public class GenericListCellRenderer
extends DefaultListCellRenderer {
    private ImageIcon iconBuffer;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list == null) {
            return this;
        }
        this.setComponentOrientation(list.getComponentOrientation());
        if (value instanceof Number) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : UIManager.getBorder("List.cellNoFocusBorder"));
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value == null) {
            this.setForeground(Color.gray);
            this.setText("<No Data>");
            this.setIcon(null);
        } else if (value instanceof LabelIconProvider) {
            LabelIconProvider liProvider = (LabelIconProvider)value;
            this.setIcon(liProvider.getIcon());
            this.setText(liProvider.getLabel());
        } else if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText(null);
        } else if (value instanceof Image) {
            if (this.iconBuffer == null) {
                this.iconBuffer = new ImageIcon();
            }
            this.iconBuffer.setImage((Image)value);
            this.setIcon(this.iconBuffer);
            this.setText(null);
        } else {
            this.setIcon(null);
            this.setText(value.toString());
        }
        return this;
    }
}

