/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.event.ChangeTracker;
import com.softlabs.warlords4.gui.FileChooserDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class FileSelectionField
extends JPanel
implements ActionListener,
ChangeListener {
    private static final String BROWSE_VALUE = "Browse";
    public static final String ACTION_CHANGED = "FileChanged";
    public static final FileChooserDialog DEFAULT_CHOOSER = FileChooserDialog.DEFAULT_CHOOSER;
    private JTextField field;
    private JButton browse;
    private FileChooserDialog chooser = DEFAULT_CHOOSER;
    private List<Object> filters;
    private File file;
    private String base;
    private String fullBase;
    private boolean dirOnly;
    private boolean relative = true;
    private boolean needParsing = true;

    public FileSelectionField() {
        this(true);
    }

    public FileSelectionField(boolean shared) {
        super(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        this.field = new JTextField(12);
        this.field.addActionListener(this);
        gbConstraints.weightx = 1.0;
        this.add((Component)this.field, gbConstraints);
        gbConstraints.weightx = 0.0;
        this.browse = new JButton(BROWSE_VALUE);
        this.browse.setActionCommand(BROWSE_VALUE);
        this.browse.addActionListener(this);
        this.browse.setToolTipText("Browse...");
        this.browse.setMnemonic(66);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.anchor = 13;
        this.add((Component)this.browse, gbConstraints);
        if (!shared) {
            this.setFileChooser(new FileChooserDialog("Choose..."));
        }
        this.filters = new ArrayList<Object>(1);
    }

    public boolean isRelative() {
        return this.relative;
    }

    public File getFile() {
        this.parseField();
        return this.file;
    }

    public String getBase() {
        return this.base;
    }

    public String getFullBase() {
        if (this.fullBase == null) {
            String base = this.getBase();
            if (base == null || base.length() == 0) {
                this.fullBase = base = System.getProperty("user.home");
            } else if (base.indexOf(58) != -1) {
                this.fullBase = base;
            } else {
                String fBase = null;
                try {
                    File baseFile = new File(base);
                    fBase = baseFile.getAbsolutePath();
                }
                catch (Throwable e) {
                    fBase = System.getProperty("user.home") + File.separatorChar + base;
                }
                this.fullBase = fBase;
            }
        }
        return this.fullBase;
    }

    public String getPath() {
        return this.field.getText().trim();
    }

    public String getFullPath() {
        String fullPath = null;
        String base = this.getFullBase();
        String path = this.getPath();
        fullPath = path == null || path.length() == 0 ? base : (path.startsWith("/") ? path : (path.indexOf(58) != -1 ? path : FileSelectionField.makeAbsoluteWith(base, path)));
        return fullPath;
    }

    public FileChooserDialog getFileChooser() {
        return this.chooser;
    }

    public boolean isDirectoryOnly() {
        return this.dirOnly;
    }

    public void setBase(String base) {
        if (base != null && base.endsWith(File.separator)) {
            base = base.substring(0, base.length() - 1);
        }
        if (base != null && !base.equals(this.base) || base == null && this.base != null) {
            String path = this.getPath();
            String fullPath = this.getFullPath();
            this.base = base;
            this.fullBase = null;
            if (path != null && path.length() > 0) {
                this.setValue(fullPath);
            }
        }
    }

    public void setRelative(boolean relative) {
        if (this.relative != relative) {
            String fullPath = this.getFullPath();
            String fullBase = this.getFullBase();
            String path = null;
            path = relative ? FileSelectionField.makeRelativeTo(fullBase, fullPath) : FileSelectionField.makeAbsoluteWith(fullBase, fullPath);
            this.relative = relative;
            this.setPath(path);
        }
    }

    public void setPath(String path) {
        this.field.setText(path);
        this.needParsing = true;
    }

    public void setFile(File file) {
        String path;
        String string = path = file == null ? "" : file.toString();
        if (this.isRelative()) {
            path = FileSelectionField.makeRelativeTo(this.getFullBase(), path);
        }
        this.setPath(path);
    }

    public void setDirectoryOnly(boolean b) {
        if (this.isDirectoryOnly() != b) {
            this.dirOnly = b;
            this.needParsing = true;
            this.parseField();
        }
    }

    public void setFileChooser(FileChooserDialog chooser) {
        this.chooser = chooser;
        if (this.chooser == null) {
            this.chooser = DEFAULT_CHOOSER;
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.field.setEditable(!readOnly);
        this.browse.setEnabled(!readOnly);
    }

    public void setValue(Object value) {
        if (value instanceof File) {
            this.setFile((File)value);
        } else if (value != null) {
            String path = String.valueOf(value);
            this.setFile(new File(path));
        } else {
            this.setPath(null);
        }
    }

    public void addChoosableFileFilter(FileFilter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public void addChoosableFileFilters(FileFilter[] filters) {
        for (int i = 0; i < filters.length; ++i) {
            this.addChoosableFileFilter(filters[i]);
        }
    }

    public void addChoosableFileFilter(long mask) {
        if (mask == 0L) {
            this.filters.clear();
        } else {
            this.filters.add(new Long(mask));
        }
    }

    public void removeChoosableFileFilter(FileFilter filter) {
        int idx = this.filters.indexOf(filter);
        if (idx != 0) {
            this.filters.remove(idx);
        }
    }

    public void removeChoosableFileFilters() {
        this.filters.clear();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.field.setEnabled(enabled);
        this.browse.setEnabled(enabled);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.field != null) {
            this.field.setFont(font);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.field != null) {
            this.field.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.field != null) {
            this.field.setForeground(color);
        }
    }

    @Override
    public void requestFocus() {
        this.field.requestFocus();
    }

    public void addChangeTracker(ChangeTracker tracker) {
        this.field.getDocument().addDocumentListener(tracker);
    }

    private void parseField() {
        if (this.needParsing) {
            this.needParsing = false;
            this.file = new File(this.getFullPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent vent) {
        String command = vent.getActionCommand();
        if (command.equals(BROWSE_VALUE)) {
            FileChooserDialog chooser;
            this.parseField();
            FileChooserDialog fileChooserDialog = chooser = this.getFileChooser();
            synchronized (fileChooserDialog) {
                File target;
                if (this.isDirectoryOnly()) {
                    chooser.setFileSelectionMode(1);
                    chooser.setAcceptAllFileFilterUsed(false);
                    chooser.resetChoosableFileFilters();
                } else {
                    chooser.setFileSelectionMode(0);
                    chooser.setAcceptAllFileFilterUsed(true);
                    chooser.resetChoosableFileFilters();
                    FileFilter first = null;
                    for (int i = 0; i < this.filters.size(); ++i) {
                        Object filter = this.filters.get(i);
                        chooser.addChoosableFileFilter((FileFilter)filter);
                        if (first != null) continue;
                        first = (FileFilter)filter;
                    }
                    if (first != null) {
                        chooser.setFileFilter(first);
                    }
                }
                File dir = target = this.getFile();
                if (this.isDirectoryOnly()) {
                    if (target != null && !target.exists() && target.mkdirs()) {
                        System.err.println("Folder \"" + target + "\" cannot be created!");
                    }
                } else if (target != null && !target.exists()) {
                    String targetStr = target.toString();
                    File path = target;
                    if (targetStr.lastIndexOf(46) > targetStr.lastIndexOf(File.separatorChar)) {
                        path = target.getParentFile();
                    }
                    if (!path.exists() && path.mkdirs()) {
                        System.err.println("Folder \"" + path + "\" cannot be created!");
                    }
                    dir = path;
                }
                chooser.setCurrentDirectory(dir);
                if (this.isDirectoryOnly() || target != null && !target.equals(dir)) {
                    chooser.setSelectedFile(target);
                }
                chooser.setDialogType(2);
                chooser.setApproveButtonText("Choose");
                chooser.setApproveButtonToolTipText("Approve Selection");
                chooser.setApproveButtonMnemonic('C');
                if (chooser.showDialog() == 0) {
                    this.setFile(chooser.getSelectedFile());
                }
            }
        } else {
            this.parseField();
        }
    }

    private static final String makeRelativeTo(String base, String source) {
        if (base == null || base.length() == 0 || source == null || source.length() == 0 || base.equals(source)) {
            return source;
        }
        String fileSep = File.separator;
        char fileSepChar = File.separatorChar;
        source = FileSelectionField.replace(FileSelectionField.getCanonicalPath(source), "%20", " ");
        base = FileSelectionField.replace(FileSelectionField.getCanonicalPath(base), "%20", " ");
        if (source.startsWith(fileSep)) {
            return source;
        }
        String backDir = "";
        String mainDir = "";
        if (source.lastIndexOf("..") == -1) {
            mainDir = source;
        } else if (source.endsWith("..")) {
            backDir = source;
        } else {
            backDir = source.substring(0, source.lastIndexOf("..") + 2);
            mainDir = source.substring(backDir.length() + 1);
        }
        if (backDir.length() > 0) {
            return source;
        }
        String common = "";
        int ptr = 0;
        String curDir = null;
        while (ptr < mainDir.length()) {
            int idx = mainDir.indexOf(fileSepChar, ptr);
            if (idx == -1) {
                curDir = mainDir.substring(ptr);
                idx = mainDir.length();
            } else {
                curDir = mainDir.substring(ptr, idx);
            }
            if (base.indexOf(common + curDir) == -1) break;
            common = common + curDir + fileSepChar;
            ptr = idx + 1;
        }
        if (common.length() == 0) {
            return source;
        }
        String endPart = base.substring(base.indexOf(common = common.substring(0, common.length() - 1)) + common.length());
        if (endPart.startsWith(fileSep)) {
            endPart = endPart.substring(1);
        }
        String relativePath = "";
        ptr = 0;
        curDir = null;
        while (ptr < endPart.length()) {
            int idx = endPart.indexOf(fileSepChar, ptr);
            if (idx == -1) {
                curDir = endPart.substring(ptr);
                idx = endPart.length();
            } else {
                curDir = endPart.substring(ptr, idx);
            }
            relativePath = relativePath + ".." + fileSepChar;
            ptr = idx + 1;
        }
        if (relativePath.endsWith(fileSep)) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        String finalPath = source.substring(common.length());
        if (relativePath.length() == 0 && finalPath.startsWith(fileSep)) {
            finalPath = finalPath.substring(1);
        } else if (finalPath.length() > 0 && !finalPath.startsWith(fileSep)) {
            finalPath = fileSepChar + finalPath;
        }
        finalPath = relativePath + finalPath;
        return finalPath;
    }

    private static final String makeAbsoluteWith(String base, String source) {
        if (source == null || source.length() == 0) {
            return base;
        }
        if (source.equals(base) || source.indexOf(58) != -1) {
            return source;
        }
        if (base == null || base.length() == 0) {
            return source;
        }
        source = FileSelectionField.replace(FileSelectionField.getCanonicalPath(source), "%20", " ");
        base = FileSelectionField.replace(FileSelectionField.getCanonicalPath(base), "%20", " ");
        char fileSepChar = File.separatorChar;
        return FileSelectionField.getCanonicalPath(base + fileSepChar + source);
    }

    private static final String getCanonicalPath(String source) {
        int dotdot;
        if (source == null || source.length() == 0) {
            return "";
        }
        String fileSep = File.separator;
        char fileSepChar = File.separatorChar;
        source = source.replace('/', fileSepChar).replace('\\', fileSepChar);
        int columnPos = Math.max(0, source.lastIndexOf(58));
        String startChunk = "";
        if (columnPos > 0) {
            int pathStart = source.indexOf(fileSepChar, columnPos);
            int offest = 1;
            while (source.charAt(pathStart + offest) == fileSepChar) {
                ++offest;
            }
            startChunk = source.substring(0, pathStart + offest);
        }
        source = source.substring(startChunk.length());
        if ((source = FileSelectionField.replace(source, fileSep + fileSep, fileSep)).endsWith(fileSep)) {
            source = source.substring(0, source.length() - 1);
        }
        if ((source = FileSelectionField.replace(source, fileSepChar + "." + fileSepChar, fileSep)).endsWith(fileSepChar + ".")) {
            source = source.substring(0, source.length() - 2);
        }
        if (source.startsWith("." + fileSepChar, columnPos)) {
            source = source.substring(columnPos + 2);
        }
        int prev = 0;
        int cur = source.indexOf(fileSepChar);
        while (cur >= 0 && (dotdot = source.indexOf("..", cur)) >= 0) {
            if (dotdot != 0 && source.charAt(dotdot - 1) == fileSepChar) {
                cur = dotdot - 1;
                for (prev = cur - 1; prev >= 0 && source.charAt(prev) != fileSepChar; --prev) {
                }
                if (source.substring(prev + 1, cur).equals("..")) {
                    cur += 2;
                    continue;
                }
                source = cur + 3 < source.length() ? (source.charAt(cur + 3) == fileSepChar ? source.substring(0, prev + 1) + source.substring(cur + 4) : source.substring(0, prev + 1) + source.substring(cur + 3)) : source.substring(0, prev + 1);
                cur = source.indexOf(fileSepChar, prev + 1);
                continue;
            }
            cur = source.indexOf(fileSepChar, dotdot);
        }
        if (startChunk.length() > 1) {
            return FileSelectionField.replace(startChunk + source, fileSepChar + "..", "");
        }
        return startChunk + source;
    }

    private static final String replace(String source, String what, String by) {
        if (source == null) {
            return null;
        }
        if (what == null || by == null || what.length() == 0) {
            return source;
        }
        int idx = 0;
        int oldIdx = 0;
        StringBuffer str = new StringBuffer(source.length());
        idx = source.indexOf(what);
        while (idx >= 0 && oldIdx < source.length()) {
            str.append(source.substring(oldIdx, idx));
            str.append(by);
            oldIdx = idx + what.length();
            idx = source.indexOf(what, oldIdx);
        }
        if (oldIdx >= 0 && oldIdx < source.length()) {
            str.append(source.substring(oldIdx));
        }
        return str.toString();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.needParsing = true;
    }
}

