/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.data.PBEMWarlord;
import com.softlabs.warlords4.data.Unit;
import com.softlabs.warlords4.data.Warlord;
import com.softlabs.warlords4.gui.UnitEditionPanel;
import com.softlabs.warlords4.gui.WarlordEditionPanel;
import com.softlabs.warlords4.io.WarlordFactory;
import com.softlabs.warlords4.io.WarlordInputStream;
import com.softlabs.warlords4.util.Files;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FilePreviewer
extends JPanel
implements PropertyChangeListener {
    private static final String TEXT_HEADER = "<html><head><title>No Data</title></head><body style=\"";
    private static final String TEXT_MIDDLE = "\"><div>";
    private static final String TEXT_FOOTER = "</div></body></html>";
    private Object data;
    private JLabel message;
    private JLabel icon;

    public FilePreviewer(int orientation) {
        super(new GridBagLayout());
        this.setToolTipText("Current warlord preview.");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 0.0;
        constraints.anchor = 11;
        this.icon = new JLabel();
        this.icon.setVerticalAlignment(0);
        constraints.insets.right = 10;
        constraints.gridwidth = orientation == 1 ? 0 : 1;
        this.add((Component)this.icon, constraints);
        this.message = new JLabel();
        this.message.setOpaque(false);
        this.message.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.message.setFocusable(false);
        this.message.setRequestFocusEnabled(false);
        this.setFont(this.message.getFont());
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        this.add((Component)this.message, constraints);
        this.setMessage(" ");
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
        this.load();
    }

    private void setIcon(Icon icon) {
        this.icon.setIcon(icon);
    }

    private void setMessage(String message) {
        if (message == null || message.length() == 0) {
            message = "<b>Select File</b>";
        }
        try {
            Color color;
            StringBuffer buffer = new StringBuffer(128);
            buffer.append(TEXT_HEADER);
            Font font = this.getFont();
            if (font != null) {
                buffer.append("font-size: ");
                buffer.append(font.getSize());
                buffer.append(";");
                if (font.isBold()) {
                    buffer.append("font-weight: bold;");
                }
                if (font.isItalic()) {
                    buffer.append("font-style: italic;");
                }
                buffer.append("font-family: '");
                buffer.append(font.getFamily());
                buffer.append("';");
            }
            if ((color = this.getForeground()) != null) {
                buffer.append("color: rgb(");
                buffer.append(color.getRed());
                buffer.append(",");
                buffer.append(color.getGreen());
                buffer.append(",");
                buffer.append(color.getBlue());
                buffer.append(");");
            }
            buffer.append(TEXT_MIDDLE);
            buffer.append(message);
            buffer.append(TEXT_FOOTER);
            this.message.setText(buffer.toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void load() {
        Object data = this.getData();
        if (data instanceof Warlord) {
            Warlord warlord = (Warlord)data;
            this.setIcon(WarlordEditionPanel.AVATARS_ICONS.get(warlord.getAvatar()));
            StringBuffer buffer = new StringBuffer();
            buffer.append("<b>").append(warlord.getName()).append("</b><br>");
            buffer.append("Level: ").append(warlord.getLevel()).append("<br>");
            buffer.append(WarlordEditionPanel.CLASS_NAMES.get(warlord.getClassType()).getLabel()).append("<br>");
            int retinues = 0;
            for (int i = 0; i < 3; ++i) {
                if (warlord.getRetinue(i) == null) continue;
                ++retinues;
            }
            if (retinues > 0) {
                buffer.append("Retinues: <b>yes</b> (").append(retinues).append(')');
            } else {
                buffer.append("Retinues: <b>no</b>");
            }
            this.setMessage(buffer.toString());
        } else if (data instanceof Unit) {
            Unit unit = (Unit)data;
            this.setIcon(UnitEditionPanel.getUnitName(unit.getRace(), unit.getType()).getIcon());
            StringBuffer buffer = new StringBuffer();
            buffer.append("<b>").append(unit.getName()).append("</b><br>");
            buffer.append("Level: ").append(unit.getLevel()).append("<br>");
            String type = UnitEditionPanel.getUnitName(unit.getRace(), unit.getType()).getLabel();
            buffer.append(type.substring(0, type.indexOf(40) - 1));
            this.setMessage(buffer.toString());
        } else {
            this.setIcon(null);
            this.setMessage(null);
        }
    }

    public void registerFileChooser(JFileChooser fileChooser) {
        fileChooser.addPropertyChangeListener("SelectedFileChangedProperty", this);
    }

    public void unregisterFileChooser(JFileChooser fileChooser) {
        fileChooser.removePropertyChangeListener("SelectedFileChangedProperty", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if ("SelectedFileChangedProperty".equals(property)) {
            Object data = null;
            File file = (File)event.getNewValue();
            if (file != null) {
                String filename = file.toString();
                String extension = Files.getExtension(file);
                if ("war".equals(extension)) {
                    if (file.exists()) {
                        if (file.length() == 692L) {
                            data = WarlordFactory.loadPreMade(filename);
                        }
                        if (data == null) {
                            data = WarlordFactory.load(filename);
                        }
                    }
                } else if ("w4join".equals(extension)) {
                    PBEMWarlord pbemWarlord;
                    if (file.exists() && (pbemWarlord = WarlordFactory.loadPBEM(filename)) != null) {
                        data = pbemWarlord.getWarlord();
                    }
                } else if ("rit".equals(extension)) {
                    WarlordInputStream input = null;
                    try {
                        if (file.exists()) {
                            input = new WarlordInputStream(filename);
                            data = WarlordFactory.readUnit(input);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException exception) {
                            // empty catch block
                        }
                    }
                }
            }
            this.setData(data);
            this.load();
        }
    }
}

