/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.gui.ApplicationDialog;
import com.softlabs.warlords4.gui.FilePreviewer;
import com.softlabs.warlords4.gui.filechooser.StandardFileSystemView;
import com.softlabs.warlords4.gui.filechooser.StandardFileView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

public class FileChooserDialog
extends ApplicationDialog
implements ActionListener {
    private static final String TITLE_OPEN = "Open file";
    private static final String TITLE_SAVE = "Save file";
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int CUSTOM_DIALOG = 2;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final FileChooserDialog DEFAULT_CHOOSER = new FileChooserDialog("Choose...");
    private JFileChooser chooser;
    private int returnValue = -1;

    public FileChooserDialog() {
        this((Frame)null, null, true);
    }

    public FileChooserDialog(String title) {
        this((Frame)null, title, true);
    }

    public FileChooserDialog(Frame owner) {
        this(owner, null, true);
    }

    public FileChooserDialog(Frame owner, String title) {
        this(owner, title, true);
    }

    public FileChooserDialog(Frame owner, boolean modal) {
        this(owner, null, modal);
    }

    public FileChooserDialog(Frame owner, String title, boolean modal) {
        super(owner, title != null ? title : TITLE_OPEN, modal);
        Container panel = this.getContentPane();
        this.chooser = new JFileChooser();
        panel.add((Component)this.chooser, "Center");
        this.chooser.setFileHidingEnabled(false);
        this.chooser.setMultiSelectionEnabled(false);
        this.setFileSelectionMode(2);
        this.chooser.setFileView(StandardFileView.getFileView());
        this.chooser.setFileSystemView(StandardFileSystemView.getFileSystemView());
        this.resetChoosableFileFilters();
        this.setAcceptAllFileFilter();
        FilePreviewer previewer = new FilePreviewer(1);
        previewer.setPreferredSize(new Dimension(120, 150));
        previewer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0), BorderFactory.createEtchedBorder()));
        previewer.registerFileChooser(this.chooser);
        this.chooser.setAccessory(previewer);
        this.addActionListener(this);
        this.pack();
    }

    public void setFileSelectionMode(int dialogType) {
        this.chooser.setFileSelectionMode(dialogType);
    }

    public void setFileView(FileView fileView) {
        this.chooser.setFileView(fileView);
    }

    public void addChoosableFileFilter(FileFilter filter) {
        if (filter != null) {
            this.chooser.addChoosableFileFilter(filter);
        }
    }

    public void setApproveButtonText(String approveButtonText) {
        this.chooser.setApproveButtonText(approveButtonText);
    }

    public void setApproveButtonToolTipText(String toolTipText) {
        this.chooser.setApproveButtonToolTipText(toolTipText);
    }

    public void setApproveButtonMnemonic(char mnemonic) {
        this.chooser.setApproveButtonMnemonic(mnemonic);
    }

    public void setApproveButtonMnemonic(int mnemonic) {
        this.chooser.setApproveButtonMnemonic(mnemonic);
    }

    public void setCurrentDirectory(File dir) {
        this.chooser.setCurrentDirectory(dir);
    }

    public void setDialogType(int dialogType) {
        this.chooser.setDialogType(dialogType);
    }

    public void setFileFilter(FileFilter filter) {
        this.chooser.setFileFilter(filter);
    }

    public void setAcceptAllFileFilter() {
        this.setFileFilter(this.chooser.getAcceptAllFileFilter());
    }

    public void setSelectedFile(File selectedFile) {
        this.chooser.setSelectedFile(selectedFile);
    }

    public boolean removeChoosableFileFilter(FileFilter f) {
        return this.chooser.removeChoosableFileFilter(f);
    }

    public void resetChoosableFileFilters() {
        this.chooser.resetChoosableFileFilters();
    }

    public void setAcceptAllFileFilterUsed(boolean b) {
        this.chooser.setAcceptAllFileFilterUsed(b);
    }

    public void addActionListener(ActionListener listener) {
        this.chooser.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.chooser.removeActionListener(listener);
    }

    public FileView getFileView() {
        return this.chooser.getFileView();
    }

    public String getApproveButtonText() {
        return this.chooser.getApproveButtonText();
    }

    public String getApproveButtonToolTipText() {
        return this.chooser.getApproveButtonToolTipText();
    }

    public FileFilter[] getChoosableFileFilters() {
        return this.chooser.getChoosableFileFilters();
    }

    public File getCurrentDirectory() {
        return this.chooser.getCurrentDirectory();
    }

    public File getSelectedFile() {
        return this.chooser.getSelectedFile();
    }

    public int getDialogType() {
        return this.chooser.getDialogType();
    }

    public FileFilter getFileFilter() {
        return this.chooser.getFileFilter();
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            title = this.chooser.getDialogType() == 1 ? TITLE_SAVE : TITLE_OPEN;
        }
        super.setTitle(title);
    }

    public int showDialog(int dialogType) {
        this.chooser.setDialogType(dialogType);
        return this.showDialog();
    }

    public int showDialog() {
        this.returnValue = -1;
        this.setLocationRelativeTo(SwingUtilities.getAncestorOfClass(Frame.class, this));
        this.setVisible(true);
        return this.returnValue;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.compareTo("CancelSelection") == 0) {
            this.returnValue = 1;
        } else if (action.compareTo("ApproveSelection") == 0) {
            this.returnValue = 0;
        }
        this.setVisible(false);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '\u001b') {
            this.returnValue = 1;
            this.setVisible(false);
        } else {
            super.keyPressed(e);
        }
    }
}

