/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.event.ChangeTracker;
import com.softlabs.warlords4.gui.Filler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CityUpgradesPanel
extends JPanel
implements ActionListener {
    public static final int BUILDING_COMBAT = 0;
    public static final int BUILDING_DIVINE_MAGIC = 1;
    public static final int BUILDING_RUNE_MAGIC = 2;
    public static final int BUILDING_NATURE_MAGIC = 3;
    public static final int BUILDING_SUMMONING = 4;
    public static final int BUILDING_NECROMANCY = 5;
    private static final String[][] BUILDING_NAMES = new String[][]{{"Level 1 Walls", "Level 2 Walls", "Level 3 Walls", "Level 4 Walls", "Village Hall", "Town Hall", "City Hall", "Capital", "Sty", "Pit", "Sink Hole", "Vat", "Rock Quarry", "Shaman Spire", "Shaman Turret", "Shaman Tower", "Pen", "Hovel", "Overseer", "Gateway of Thorns", "Prison Cages", "Temple of War", "Grinder"}, {"Level 1 Walls", "Level 2 Walls", "Level 3 Walls", "Level 4 Walls", "Village Hall", "Town Hall", "City Hall", "Capital", "Barracks", "Armory", "Archery Range", "Stables", "Mage Spire", "Mage Turret", "Mage Tower", "Inn", "Bureau", "Temple", "Prison", "Marketplace", "Banking Center", "Mint", "Recruiting Office"}, {"Level 1 Walls", "Level 2 Walls", "Level 3 Walls", "Level 4 Walls", "Camp", "Fort", "Bailey", "Keep", "Lodge", "Eyrie", "Foundry", "Armory", "Iron Works", "Rune Spire", "Rune Turret", "Rune Tower", "Refectory", "Quarry", "Obelisk", "Gaol", "Trading Post", "Gold Mine", "Blast Furnace"}, {"Level 1 Walls", "Level 2 Walls", "Level 3 Walls", "Level 4 Walls", "Green Palace", "Emerald Palace", "Jade Palace", "Sage Palace", "Tree of Life", "Circle of Power", "Workshop", "Forest Forge", "Sylvan Fletcher", "Adept Spire", "Adept Turret", "Adept Tower", "Sweetwater Well", "Hostel", "Rangers' Hall", "Magic Pool", "Reformatory", "Trade Center", "Evergreen Shrine"}, {"Level 1 Walls", "Level 2 Walls", "Level 3 Walls", "Level 4 Walls", "Citadel of Fear", "Citadel of Dread", "Citadel of Despair", "Citadel of Horror", "Cadaver Hall", "Portal of Hades", "Gate of Ctharos", "Fumerole", "Vulcanic Mills", "Occult Spire", "Occult Turret", "Occult Tower", "Stygian Shrine", "Infernal Cloister", "Thralls' Quarters", "Blood Altar", "House of Penitence", "Pool of Lethe", "Sacrifical Shrine"}, {"Level 1 Walls", "Level 2 Walls", "Level 3 Walls", "Level 4 Walls", "Cell of the Undead", "Chamber of the Undead", "Hall of the Undead", "Great Hall of the Undead", "Graveyard", "Mausoleum", "Dark Mills", "Necromantic Chamber", "Barrow", "Dead Spire", "Dead Turret", "Dead Tower", "Royal Tomb", "Chateau", "Hard Labor Camp", "Lightning Spire", "Cage", "Office of Blight", "Death Shrine"}};
    private static final String[][] BUILDING_TIPS = new String[][]{{"Level 1 Walls: Tower Damage +1", "Level 2 Walls: Tower Damage +1 (Level 1 Walls as pre-condition)", "Level 3 Walls: Tower Damage +1 (Level 2 Walls as pre-condition)", "Level 4 Walls: Tower Damage +1 (Level 3 Walls as pre-condition)", "Village Hall: Tower Life +4", "Town Hall: Tower Life +4 (Village Hall as pre-condition)", "City Hall: Tower Life +4 (Town Hall as pre-condition)", "Capital: Tower Life +4 (City Hall as pre-condition)", "Sty: Unit Combat +2", "Pit: Unit Combat +2", "Sink Hole: Unit Combat +2", "Vat: Unit Life +3", "Rock Quarry: Income +30", "Shaman Spire: Mana Regeneration +1", "Shaman Turret: Maximum Mana +2 (Shaman Spire as pre-condition)", "Shaman Tower:  Maximum Mana +2 (Shaman Turret as pre-condition) ", "Pen: Income +30", "Hovel: Morale +1", "Overseer: Morale +1", "Gateway of Thorns: Speed +1", "Prison Cages: +20 Gold per Unit for Defending", "Temple of War: Quests Available", "Grinder: Unit Life +3"}, {"Level 1 Walls: Tower Damage +1", "Level 2 Walls: Tower Damage +1 (Level 1 Walls as pre-condition)", "Level 3 Walls: Tower Damage +1 (Level 2 Walls as pre-condition)", "Level 4 Walls: Tower Damage +1 (Level 3 Walls as pre-condition)", "Village Hall: Tower Life +4", "Town Hall: Tower Life +4 (Village Hall as pre-condition)", "City Hall: Tower Life +4 (Town Hall as pre-condition)", "Capital: Tower Life +4 (City Hall as pre-condition)", "Barracks: Production Time -1", "Armory: Unit Life +3", "Archery Range: Unit Combat +2", "Stables: Speed +1", "Mage Spire: Mana Regeneration +1", "Mage Turret: Mana Regeneration +1 (Mage Spire as pre-condition)", "Mage Tower: Mana Regeneration +1 (Mage Turet as pre-condition)", "Inn: Hero cost -20%", "Bureau: Speed +1", "Temple: Quests Available", "Prison: +20 Gold per Unit for Defending", "Marketplace: Income +30", "Banking Center: Income +30 (Marketplace as pre-condition)", "Mint: Income +30 (Banking Center as pre-condition)", "Recruiting Office: Hero cost -20%"}, {"Level 1 Walls: Tower Damage +1", "Level 2 Walls: Tower Damage +1 (Level 1 Walls as pre-condition)", "Level 3 Walls: Tower Damage +1 (Level 2 Walls as pre-condition)", "Level 4 Walls: Tower Damage +1 (Level 3 Walls as pre-condition)", "Camp: Tower Life +5", "Fort: Tower Life +5 (Camp as pre-condition)", "Bailey: Tower Life +5 (Fort as pre-condition)", "Keep: Tower Life +5 (Bailey as pre-condition)", "Lodge: Hero cost -15%", "Eyrie: Speed +1", "Foundry: Production Time -1", "Armory: Unit Life +3", "Iron Works: Unit Combat +2", "Rune Spire: Mana Regeneration +1", "Rune Turret: Mana Regeneration +1 (Rune Spire as pre-condition)", "Rune Tower: Mana Regeneration +1 (Rune Turret as pre-condition)", "Refectory: Hero cost -15%", "Quarry: Income +50", "Obelisk: Morale +1", "Gaol: +20 Gold per Unit for Defending", "Trading Post: Income +40", "Gold Mine: Income +40", "Blast Furnace: Unit Combat +2"}, {"Level 1 Walls: Tower Damage +1", "Level 2 Walls: Tower Damage +1 (Level 1 Walls as pre-condition)", "Level 3 Walls: Tower Damage +1 (Level 2 Walls as pre-condition)", "Level 4 Walls: Tower Damage +1 (Level 3 Walls as pre-condition)", "Green Palace: Tower Life +3", "Emerald Palace: Tower Life +3 (Green Palace as pre-condition", "Jade Palace: Tower Life +3 (Emerald Palace as pre-condition)", "Sage Palace: Tower Life +3 (Jade Palace as pre-condition)", "Tree of Life: Unit Life +3", "Circle of Power: Mana Regeneration +1", "Workshop: Unit Combat +2", "Forest Forge: Production Time -1", "Sylvan Fletcher: Unit Combat +2", "Adept Spire: Mana Regeneration +1", "Adept Turret: Maximum Mana +2 (Adept Spire as pre-condition)", "Adept Tower: Maximum Mana +2 (Adept Turret as pre-condition)", "Sweetwater Well: Unit Life +3", "Hostel: Hero cost -20%", "Rangers' Hall: Speed +1", "Magic Pool: Speed +1", "Reformatory: +20 Gold per Unit for Defending", "Trade Center: Income +30", "Evergreen Shrine: Quests Available"}, {"Level 1 Walls: Tower Damage +1", "Level 2 Walls: Tower Damage +1 (Level 1 Walls as pre-condition)", "Level 3 Walls: Tower Damage +1 (Level 2 Walls as pre-condition)", "Level 4 Walls: Tower Damage +1 (Level 3 Walls as pre-condition)", "Citadel of Fear: Tower Life +4", "Citadel of Dread: Tower Life +4 (Citadel of Fear as pre-condition)", "Citadel of Despair: Tower Life +4 (Citadel of Dread as pre-condition)", "Citadel of Horror: Tower Life +4 (Citadel of Despair as pre-condition)", "Cadaver Hall: Unit Combat +2", "Portal of Hades: Production Time -1", "Gate of Ctharos: Speed +1", "Fumerole: Speed +1", "Vulcanic Mills: Income +30", "Occult Spire: Mana Regeneration +1 ", "Occult Turret: Mana Regeneration +1 (Occult Spire as pre-condition)", "Occult Tower: Maximum Mana +3 (Occult Turret as pre-condition)", "Stygian Shrine: Morale +1", "Infernal Cloister: Unit Combat +2", "Thralls' Quarters: Income +30", "Blood Altar: Ennemy Morale -1", "House of Penitence: +20 Gold per Unit for Defending", "Pool of Lethe: Unit Life +2", "Sacrifical Shrine: Quests Available"}, {"Level 1 Walls: Tower Damage +1", "Level 2 Walls: Tower Damage +1 (Level 1 Walls as pre-condition)", "Level 3 Walls: Tower Damage +1 (Level 2 Walls as pre-condition)", "Level 4 Walls: Tower Damage +1 (Level 3 Walls as pre-condition)", "Cell of the Undead: Tower Life +4", "Chamber of the Undead: Tower Life +4 (Cell of the Undead as pre-condition)", "Hall of the Undead: Tower Life +4 (Chamber of the Undead as pre-condition)", "Great Hall of the Undead: Tower Life +4 (Hall of the Undead as pre-condition)", "Graveyard: Unit Combat +2", "Mausoleum: Unit Combat +2", "Dark Mills: Production Time -1", "Necromantic Chamber: Ennemy Morale -1", "Barrow: Unit Combat +2", "Dead Spire: Mana Regeneration +1", "Dead Turret: Mana Regeneration +1 (Dead Spire as pre-condition)", "Dead Tower: Maximum Mana +4 (Dead Turret as pre-condition)", "Royal Tomb: Income +30", "Chateau: Hero cost -20%", "Hard Labor Camp: +20 Gold per Unit for Defending", "Lightning Spire: Speed +1", "Cage: Ennemy Morale -1", "Office of Blight: Income +30", "Death Shrine: Quests Available"}};
    private static final char[][] UPGARDE_MNEMONIC = new char[][]{{'1', '2', '3', '4', 'V', 'T', 'i', 'd', 'S', 'P', 'n', 'j', 'k', 'm', 'u', 'w', 'e', 'l', 'O', 'G', 'z', 'b', 'x'}, {'1', '2', '3', '4', 'V', 'T', 'l', 'p', 'B', 'y', 'e', 'S', 'M', 'g', 'w', 'I', 'u', 'D', 'z', 'k', 'j', 'X', 'O'}, {'1', '2', '3', '4', 'Z', 'X', 'v', 'K', 'L', 'E', 'n', 'u', 'I', 'S', 'T', 'w', 'y', 'Q', 'O', 'G', 'P', 'M', 'B'}, {'1', '2', '3', '4', 'G', 'E', 'J', 'S', 'L', 'i', 'W', 'o', 'y', 'd', 'u', 'p', 't', 'b', 'n', 'M', 'x', 'z', 'v'}, {'1', '2', '3', '4', 'Z', 'D', 't', 'X', 'K', 'o', 'G', 'e', 'V', 'S', 'u', 'w', 'y', 'I', 'Q', 'B', 'P', 'L', 'a'}, {'1', '2', '3', '4', 'U', 'i', 'j', 'G', 'y', 'M', 'D', 'N', 'B', 'p', 'z', 'w', 'T', 'x', 'L', 'S', 'e', 'O', 'a'}};
    private static final int MAXIMUM_DEFENSE_BUILDINGS = 8;
    private static final String ACTION_SELECT_ALL = "Select All";
    private static final String ACTION_UNSELECT_ALL = "Unselect All";
    private JCheckBox[] upgrades;
    private int type;
    private boolean limited;

    public CityUpgradesPanel() {
        super(new GridBagLayout());
        this.setName("WUpgrades");
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.bottom = 5;
        this.upgrades = new JCheckBox[23];
        JPanel defensePanel = new JPanel(new GridLayout(0, 4, 5, 5));
        defensePanel.setOpaque(false);
        defensePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Defense"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.add((Component)defensePanel, gbConstraints);
        for (int i = 0; i < 8; ++i) {
            this.upgrades[i] = new JCheckBox();
            this.upgrades[i].addActionListener(this);
            this.upgrades[i].setOpaque(false);
            defensePanel.add(this.upgrades[i]);
        }
        JPanel buildingsPanel = new JPanel(new GridLayout(0, 4, 5, 5));
        buildingsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Buildings"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        buildingsPanel.setOpaque(false);
        this.add((Component)buildingsPanel, gbConstraints);
        for (int i = 8; i < this.upgrades.length; ++i) {
            this.upgrades[i] = new JCheckBox();
            this.upgrades[i].addActionListener(this);
            this.upgrades[i].setOpaque(false);
            buildingsPanel.add(this.upgrades[i]);
        }
        gbConstraints.weighty = 1.0;
        gbConstraints.insets.bottom = 5;
        this.add((Component)new Filler(), gbConstraints);
        gbConstraints.weighty = 0.0;
        gbConstraints.insets.bottom = 0;
        gbConstraints.gridwidth = 1;
        this.add((Component)new Filler(), gbConstraints);
        JButton selectAll = new JButton(ACTION_SELECT_ALL);
        selectAll.setActionCommand(ACTION_SELECT_ALL);
        selectAll.addActionListener(this);
        selectAll.setToolTipText("Select all Upgrades");
        selectAll.setMnemonic(ACTION_SELECT_ALL.charAt(0));
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.bottom = 5;
        gbConstraints.insets.right = 5;
        this.add((Component)selectAll, gbConstraints);
        gbConstraints.gridwidth = 0;
        JButton unselectAll = new JButton(ACTION_UNSELECT_ALL);
        unselectAll.setActionCommand(ACTION_UNSELECT_ALL);
        unselectAll.addActionListener(this);
        unselectAll.setToolTipText("Unselect all Upgrades");
        unselectAll.setMnemonic(ACTION_UNSELECT_ALL.charAt(0));
        gbConstraints.insets.right = 2;
        this.add((Component)unselectAll, gbConstraints);
        this.setLabels(5);
    }

    public boolean isSelected(int target) {
        return this.upgrades[target].isSelected();
    }

    public int getDevelopmentPoints() {
        int devPoints = 0;
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (!this.upgrades[i].isSelected()) continue;
            ++devPoints;
        }
        return devPoints - 2;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public boolean areAllUpgradesSelected() {
        boolean allSelected = true;
        for (int i = 0; i < this.upgrades.length; ++i) {
            allSelected &= this.upgrades[i].isSelected();
        }
        return allSelected;
    }

    public void setLabels(int type) {
        this.type = type;
        for (int i = 0; i < 23; ++i) {
            this.upgrades[i].setText(BUILDING_NAMES[type][i]);
            this.upgrades[i].setToolTipText(BUILDING_TIPS[type][i]);
            this.upgrades[i].setVisible(BUILDING_NAMES[type][i] != null);
            this.upgrades[i].setMnemonic(UPGARDE_MNEMONIC[type][i]);
            if (BUILDING_NAMES[type][i] != null) continue;
            this.upgrades[i].setSelected(false);
        }
        this.setState();
    }

    public void setSelected(int target, boolean selected) {
        this.upgrades[target].setSelected(selected);
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
        if (limited) {
            this.upgrades[0].setEnabled(false);
            this.upgrades[0].setSelected(true);
            this.upgrades[4].setEnabled(false);
            this.upgrades[4].setSelected(true);
        } else {
            this.upgrades[0].setEnabled(true);
            this.upgrades[4].setEnabled(true);
        }
        this.setState();
    }

    public void setState() {
        this.upgrades[1].setEnabled(this.upgrades[0].isSelected());
        if (!this.upgrades[1].isEnabled()) {
            this.upgrades[1].setSelected(false);
        }
        this.upgrades[2].setEnabled(this.upgrades[1].isSelected());
        if (!this.upgrades[2].isEnabled()) {
            this.upgrades[2].setSelected(false);
        }
        this.upgrades[3].setEnabled(this.upgrades[2].isSelected());
        if (!this.upgrades[3].isEnabled()) {
            this.upgrades[3].setSelected(false);
        }
        this.upgrades[5].setEnabled(this.upgrades[4].isSelected());
        if (!this.upgrades[5].isEnabled()) {
            this.upgrades[5].setSelected(false);
        }
        this.upgrades[6].setEnabled(this.upgrades[5].isSelected());
        if (!this.upgrades[6].isEnabled()) {
            this.upgrades[6].setSelected(false);
        }
        this.upgrades[7].setEnabled(this.upgrades[6].isSelected());
        if (!this.upgrades[7].isEnabled()) {
            this.upgrades[7].setSelected(false);
        }
        if (this.type == 1) {
            this.upgrades[13].setEnabled(this.upgrades[12].isSelected());
            if (!this.upgrades[13].isEnabled()) {
                this.upgrades[13].setSelected(false);
            }
            this.upgrades[14].setEnabled(this.upgrades[13].isSelected());
            if (!this.upgrades[14].isEnabled()) {
                this.upgrades[14].setSelected(false);
            }
            this.upgrades[15].setEnabled(true);
        } else {
            this.upgrades[13].setEnabled(true);
            this.upgrades[14].setEnabled(true);
            this.upgrades[14].setEnabled(this.upgrades[13].isSelected());
            if (!this.upgrades[14].isEnabled()) {
                this.upgrades[14].setSelected(false);
            }
            this.upgrades[15].setEnabled(this.upgrades[14].isSelected());
            if (!this.upgrades[15].isEnabled()) {
                this.upgrades[15].setSelected(false);
            }
        }
        if (this.type == 1) {
            this.upgrades[20].setEnabled(this.upgrades[19].isSelected());
            if (!this.upgrades[20].isEnabled()) {
                this.upgrades[20].setSelected(false);
            }
            this.upgrades[21].setEnabled(this.upgrades[20].isSelected());
            if (!this.upgrades[21].isEnabled()) {
                this.upgrades[21].setSelected(false);
            }
        } else {
            this.upgrades[20].setEnabled(true);
            this.upgrades[21].setEnabled(true);
        }
    }

    private void selectAll(boolean select) {
        for (int i = 0; i < this.upgrades.length; ++i) {
            this.upgrades[i].setSelected(select);
        }
        this.setLimited(this.isLimited());
        ActionListener[] listener = this.upgrades[0].getActionListeners();
        ActionEvent event = new ActionEvent(this.upgrades[0], 1001, this.upgrades[0].getActionCommand());
        for (int i = 0; i < listener.length; ++i) {
            listener[i].actionPerformed(event);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (ACTION_SELECT_ALL.equals(event.getActionCommand())) {
            this.selectAll(true);
        } else if (ACTION_UNSELECT_ALL.equals(event.getActionCommand())) {
            this.selectAll(false);
        } else {
            this.setState();
        }
    }

    public void addChangeTracker(ChangeTracker tracker) {
        for (int i = 0; i < this.upgrades.length; ++i) {
            this.upgrades[i].addActionListener(tracker);
        }
    }
}

