/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.gui.Filler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ApplyResetPanel
extends JPanel
implements ChangeListener {
    public static final String KEY_APPLY = "applyKey";
    public static final String KEY_RESET = "resetKey";
    public static final String KEY_CLOSE = "closeKey";
    private static final String APPLY_VALUE = "Apply";
    private static final String RESET_VALUE = "Reset";
    private static final String CLOSE_VALUE = "Close";
    private static final String ACTION_ID = "arp:";
    public static final String ACTION_APPLY = "arp:Apply";
    public static final String ACTION_RESET = "arp:Reset";
    public static final String ACTION_CLOSE = "arp:Close";
    private JButton apply;
    private JButton reset;
    private JButton close;

    public ApplyResetPanel() {
        super(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 0.0;
        gbConstraints.fill = 1;
        gbConstraints.insets.bottom = 5;
        gbConstraints.insets.top = 10;
        gbConstraints.weightx = 1.0;
        this.add((Component)new Filler(), gbConstraints);
        gbConstraints.weightx = 0.0;
        this.apply = new JButton(APPLY_VALUE);
        this.apply.setActionCommand(ACTION_APPLY);
        this.apply.setToolTipText("Apply new values");
        this.apply.setMnemonic(APPLY_VALUE.charAt(0));
        gbConstraints.insets.right = 5;
        this.add((Component)this.apply, gbConstraints);
        this.reset = new JButton(RESET_VALUE);
        this.reset.setActionCommand(ACTION_RESET);
        this.reset.setToolTipText("Reset to previous");
        this.reset.setMnemonic(RESET_VALUE.charAt(0));
        this.add((Component)this.reset, gbConstraints);
        this.close = new JButton(CLOSE_VALUE);
        this.close.setActionCommand(ACTION_CLOSE);
        this.close.setToolTipText("Close Window");
        this.close.setMnemonic(CLOSE_VALUE.charAt(0));
        gbConstraints.insets.right = 0;
        this.add((Component)this.close, gbConstraints);
    }

    public void setApplyEnabled(boolean enable) {
        if (this.apply.isEnabled() && !enable) {
            this.close.grabFocus();
        }
        this.apply.setEnabled(enable);
    }

    public void setResetEnabled(boolean enable) {
        if (this.reset.isEnabled() && !enable) {
            this.close.grabFocus();
        }
        this.reset.setEnabled(enable);
    }

    public boolean isApplyEnabled() {
        return this.apply.isEnabled();
    }

    public boolean isResetEnabled() {
        return this.reset.isEnabled();
    }

    public void installDefaultButton() {
        RootPaneContainer root = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this));
        if (root != null) {
            root.getRootPane().setDefaultButton(this.close);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.apply.addActionListener(listener);
        this.reset.addActionListener(listener);
        this.close.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.apply.removeActionListener(listener);
        this.reset.removeActionListener(listener);
        this.close.removeActionListener(listener);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.setApplyEnabled(true);
        this.setResetEnabled(true);
    }
}

