/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.gui;

import com.softlabs.warlords4.data.Ability;
import com.softlabs.warlords4.event.ChangeTracker;
import com.softlabs.warlords4.gui.GenericListCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class AbilityPanel
extends JPanel
implements ActionListener {
    private JComboBox name;
    private JSpinner level;
    private SpinnerNumberModel levelModel;

    public AbilityPanel(String title) {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(title));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 0;
        gbConstraints.insets.bottom = 5;
        JLabel nameLabel = new JLabel("Name:");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        this.add((Component)nameLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.name = new JComboBox();
        this.name.setRenderer(new GenericListCellRenderer());
        for (int i = 0; i < Ability.ABILITY_LIST.size(); ++i) {
            Ability ability = Ability.ABILITY_LIST.get(i);
            if (!ability.isSkill()) continue;
            this.name.addItem(ability);
        }
        this.name.addActionListener(this);
        gbConstraints.insets.right = 5;
        this.add((Component)this.name, gbConstraints);
        gbConstraints.insets.right = 0;
        JLabel levelLabel = new JLabel("Level:");
        levelLabel.setToolTipText("Level: efficiency of this ability, max 5.");
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.insets.right = 11;
        gbConstraints.insets.left = 5;
        this.add((Component)levelLabel, gbConstraints);
        gbConstraints.insets.left = 0;
        gbConstraints.insets.right = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.levelModel = new SpinnerNumberModel(0, 0, 5, 1);
        this.level = new JSpinner(this.levelModel);
        gbConstraints.insets.right = 5;
        this.add((Component)this.level, gbConstraints);
        gbConstraints.insets.right = 0;
    }

    public Ability getAbility() {
        return (Ability)this.name.getSelectedItem();
    }

    public int getLevel() {
        return ((Number)this.level.getValue()).intValue();
    }

    public void setAbility(Ability ability) {
        this.name.setSelectedItem(ability);
    }

    public void setLevel(int level) {
        this.level.setValue(new Integer(level));
    }

    public void addChangeTracker(ChangeTracker tracker) {
        this.name.addActionListener(tracker);
        this.level.addChangeListener(tracker);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Ability ability = (Ability)this.name.getSelectedItem();
        int max = ability.getID() == 41 ? 255 : 5;
        this.levelModel.setMaximum(new Integer(max));
        this.levelModel.setValue(new Integer(Math.min(max, this.getLevel())));
    }
}

