/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.event;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;

public abstract class AbstractEventHandler
implements EventListener {
    protected List<EventListener> listeners = new ArrayList<EventListener>(2);
    private boolean direct;

    public AbstractEventHandler() {
        this(false);
    }

    public AbstractEventHandler(boolean direct) {
        this.setDirect(direct);
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    public void insertElementAt(EventListener listener, int at) {
        if (listener == null) {
            throw new NullPointerException("Null listener");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(Math.min(at, this.listeners.size()), listener);
        }
    }

    public void add(EventListener listener) {
        if (listener == null) {
            throw new NullPointerException("Null listener");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void remove(EventListener listener) {
        if (listener == null) {
            throw new NullPointerException("Null listener");
        }
        int idx = this.listeners.indexOf(listener);
        if (idx != -1) {
            this.listeners.remove(idx);
        }
    }

    public boolean isDirect() {
        return this.direct;
    }

    public int getListenersCount() {
        return this.listeners.size();
    }

    public String getName() {
        return this.getClass().getName();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getListenersCount() * 32 + 32);
        buffer.append(this.getName());
        buffer.append("\nRegistered listeners:");
        for (int i = 0; i < this.listeners.size(); ++i) {
            buffer.append("  ");
            buffer.append(this.listeners.get(i).getClass().getName());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected abstract void fire(EventObject var1);

    class EventBroadcaster
    implements Runnable {
        private EventObject event = null;

        public EventBroadcaster(EventObject event) {
            this.event = event;
        }

        @Override
        public void run() {
            AbstractEventHandler.this.fire(this.event);
        }
    }
}

