/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.data;

import com.softlabs.warlords4.data.Unit;
import com.softlabs.warlords4.gui.WarlordEditionPanel;
import com.softlabs.warlords4.gui.filechooser.StandardFileFilter;

public class Warlord {
    public static final int SKILL_FAME = 0;
    public static final int SKILL_GATE = 1;
    public static final int SKILL_GLORY = 2;
    public static final int SKILL_MERCHAND = 3;
    public static final int SKILL_DEFENDER = 4;
    public static final int SKILL_ANTI_MAGIC = 5;
    public static final int SKILL_CHAOS = 6;
    public static final int SKILL_CRUSADER = 7;
    public static final int SKILL_WEAPONMASTER = 8;
    public static final int SKILL_MORALE = 9;
    public static final int SKILL_ENGINEER = 10;
    public static final int SKILL_ARCHIMAGE = 11;
    public static final int SKILL_DIVINE_MAGIC = 12;
    public static final int SKILL_RUNE_MAGIC = 13;
    public static final int SKILL_NATURE_MAGIC = 14;
    public static final int SKILL_SUMMONING = 15;
    public static final int SKILL_NECROMANCY = 16;
    public static final int MAXIMUM_SKILLS = 17;
    public static final int BUILDING_WALL_1 = 0;
    public static final int BUILDING_WALL_2 = 1;
    public static final int BUILDING_WALL_3 = 2;
    public static final int BUILDING_WALL_4 = 3;
    public static final int BUILDING_TOWNHALL_1 = 4;
    public static final int BUILDING_TOWNHALL_2 = 5;
    public static final int BUILDING_TOWNHALL_3 = 6;
    public static final int BUILDING_TOWNHALL_4 = 7;
    public static final int BUILDING_MAGE_TOWER_1 = 13;
    public static final int BUILDING_MAGE_TOWER_2 = 14;
    public static final int BUILDING_MAGE_TOWER_3 = 15;
    public static final int BUILDING_MARKETPACE_1 = 19;
    public static final int BUILDING_MARKETPACE_2 = 20;
    public static final int BUILDING_MARKETPACE_3 = 21;
    public static final int MAXIMUM_CITY_UPGRADES = 23;
    public static final int MAXIMUM_RETINUES = 3;
    public static final int CLASS_WARRIOR = 0;
    public static final int CLASS_TEMPLAR = 1;
    public static final int CLASS_BARBARIAN = 2;
    public static final int CLASS_RANGER = 3;
    public static final int CLASS_FLAMEKNIGHT = 4;
    public static final int CLASS_BLACKGUARD = 5;
    public static final int CLASS_PALADIN = 6;
    public static final int CLASS_PRIEST = 7;
    public static final int CLASS_CLERIC = 8;
    public static final int CLASS_MONK = 9;
    public static final int CLASS_HERETIC = 10;
    public static final int CLASS_DEATHPRIEST = 11;
    public static final int CLASS_RUNELORD = 12;
    public static final int CLASS_RUNEPRIEST = 13;
    public static final int CLASS_RUNEMASTER = 14;
    public static final int CLASS_RUNESMITH = 15;
    public static final int CLASS_SEER = 16;
    public static final int CLASS_GORGON = 17;
    public static final int CLASS_BEASTMATER = 18;
    public static final int CLASS_HEIROPHANT = 19;
    public static final int CLASS_ALCHEMIST = 20;
    public static final int CLASS_DRUID = 21;
    public static final int CLASS_SHAMAN = 22;
    public static final int CLASS_BLACK_DRUID = 23;
    public static final int CLASS_BATTLEMAGE = 24;
    public static final int CLASS_MYSTIC = 25;
    public static final int CLASS_CONJUROR = 26;
    public static final int CLASS_ELEMENRALIST = 27;
    public static final int CLASS_SUMMONER = 28;
    public static final int CLASS_SORCEROR = 29;
    public static final int CLASS_DEATH_KNIGHT = 30;
    public static final int CLASS_PLAGUE_PRIEST = 31;
    public static final int CLASS_CABALIST = 32;
    public static final int CLASS_WARLOCK = 33;
    public static final int CLASS_GHOUL = 34;
    public static final int CLASS_NECROMANCER = 35;
    public static final int MAXIMUM_CLASS_TYPES = 36;
    public static final int ABILITY_COMBAT = 0;
    public static final int ABILITY_DIVINE_MAGIC = 1;
    public static final int ABILITY_RUNE_MAGIC = 2;
    public static final int ABILITY_NATURE_MAGIC = 3;
    public static final int ABILITY_SUMMONING = 4;
    public static final int ABILITY_NECROMANCY = 5;
    public static final int MAXIMUM_ABILITIES = 6;
    public static final String DEFAULT_EXTENSION = "war";
    public static final String DEFAULT_TYPE_DESCRIPTION = "Warlords IV - Warlord File";
    public static final int MAX_STRING_SIZE = 31;
    public static final StandardFileFilter DEFAULT_FILTER = new StandardFileFilter(new String[]{"war"}, "Warlords IV - Warlord File");
    public static final int MAXIMUM_PROVINCES = 32;
    public static final int DUMMY_BUFFER1_SIZE = 72;
    public static final int DUMMY_BUFFER2_SIZE = 36;
    private String name;
    private String capital;
    private int avatar = 6;
    private int major = 0;
    private int minor = 0;
    private int race = 0;
    private int battles;
    private int victories;
    private int level = 1;
    private int provincesMask = 17;
    private int classType = 0;
    private int experience;
    private int[] skills = new int[17];
    private boolean[] cityUpgrades = new boolean[23];
    private Unit[] retinues = new Unit[3];
    private boolean[] provinceWon = new boolean[32];

    public Warlord() {
        this.cityUpgrades[0] = true;
        this.cityUpgrades[4] = true;
    }

    public int getSkillLevel(int target) {
        return this.skills[target];
    }

    public boolean isCityUpgraded(int target) {
        return this.cityUpgrades[target];
    }

    public boolean isProvinceWon(int target) {
        return this.provinceWon[target];
    }

    public Unit getRetinue(int target) {
        return this.retinues[target];
    }

    public String getName() {
        return this.name;
    }

    public String getCapital() {
        return this.capital;
    }

    public int getAvatar() {
        return this.avatar;
    }

    public int getMajorAbility() {
        return this.major;
    }

    public int getMinorAbility() {
        return this.minor;
    }

    public int getRace() {
        return this.race;
    }

    public int getBattles() {
        return this.battles;
    }

    public int getVictories() {
        return this.victories;
    }

    public int getExperience() {
        return this.experience;
    }

    public int getLevel() {
        return this.level;
    }

    public int getClassType() {
        return this.classType;
    }

    public int getProvincesMask() {
        return this.provincesMask;
    }

    public void setSkillLevel(int target, int level) {
        this.skills[target] = level;
    }

    public void setCityUpgraded(int target, boolean upgraded) {
        this.cityUpgrades[target] = upgraded;
    }

    public void setProvinceWon(int target, boolean won) {
        this.provinceWon[target] = won;
    }

    public void setRetinue(int target, Unit retinue) {
        this.retinues[target] = retinue;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (name != null && name.length() > 31) {
            throw new IllegalArgumentException("The name must be less then 31 characters (" + name.length() + ").");
        }
        if (name != null && !name.equals(this.name) || name == null && this.name != null) {
            this.name = name;
        }
    }

    public void setCapital(String capital) {
        if (capital != null && capital.length() > 31) {
            throw new IllegalArgumentException("The capital name must be less then 31 characters (" + capital.length() + ").");
        }
        this.capital = capital;
    }

    public void setRace(int race) {
        if (race < 0 || race >= 10) {
            throw new IllegalArgumentException("The race is invalid (" + race + "). Must be in range [0.." + 9 + "]");
        }
        this.race = race;
    }

    public void setExperience(int experience) {
        if (experience < 0) {
            throw new IllegalArgumentException("The experience is invalid (" + experience + "). Must be a positive number");
        }
        this.experience = experience;
    }

    public void setLevel(int level) {
        if (level < 1 || level > 32768) {
            throw new IllegalArgumentException("The level is invalid (" + level + "). Must be a positive number");
        }
        this.level = level;
    }

    public void setAvatar(int avatar) {
        if (avatar < 0 || avatar > 255) {
            throw new IllegalArgumentException("The avatar is invalid (" + avatar + "). Must be a in range [0..255]");
        }
        this.avatar = avatar;
    }

    public void setMajorAbility(int major) {
        if (major < 0 || major >= 6) {
            throw new IllegalArgumentException("The ability is invalid (" + major + "). Must be in range [0.." + 5 + "]");
        }
        this.major = major;
    }

    public void setMinorAbility(int minor) {
        if (minor < 0 || minor >= 6) {
            throw new IllegalArgumentException("The ability is invalid (" + minor + "). Must be in range [0.." + 5 + "]");
        }
        this.minor = minor;
    }

    public void setBattles(int battles) {
        if (battles < 0) {
            throw new IllegalArgumentException("The battles is invalid (" + battles + "). Must be a positive number");
        }
        this.battles = battles;
    }

    public void setVictories(int victories) {
        if (victories < 0) {
            throw new IllegalArgumentException("The victories is invalid (" + victories + "). Must be a positive number");
        }
        this.victories = victories;
    }

    public void setClassType(int classType) {
        if (classType < 0 || classType > 36) {
            throw new IllegalArgumentException("The class type is invalid (" + classType + "). Must be a in range [0.." + 35 + "].");
        }
        this.classType = classType;
    }

    public void setProvincesMask(int mask) {
        this.provincesMask = mask;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append('\'').append(this.getName()).append("' the '").append(WarlordEditionPanel.CLASS_NAMES.get(this.getClassType()).getLabel()).append('\'');
        return buffer.toString();
    }
}

