/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.data;

import com.softlabs.warlords4.data.Ability;
import com.softlabs.warlords4.data.Item;
import com.softlabs.warlords4.data.LabeledIcon;
import com.softlabs.warlords4.gui.UnitEditionPanel;
import com.softlabs.warlords4.gui.filechooser.StandardFileFilter;
import java.util.Random;

public class Unit {
    public static final int RACE_KNIGHTS = 0;
    public static final int RACE_EMPIRE = 1;
    public static final int RACE_DWARVES = 2;
    public static final int RACE_OGRES = 3;
    public static final int RACE_OCRS = 4;
    public static final int RACE_UNDEAD = 5;
    public static final int RACE_DARK_ELVES = 6;
    public static final int RACE_DEAMONS = 7;
    public static final int RACE_DRAGONS = 8;
    public static final int RACE_ELVES = 9;
    public static final int MAXIMUM_RACE = 10;
    public static final int MINIMUM_TYPE = 0;
    public static final int MAXIMUM_TYPE = 5;
    public static final int TYPE_HERO = 5;
    public static final int MAX_STRING_SIZE = 31;
    public static final String DEFAULT_EXTENSION = "rit";
    public static final String DEFAULT_TYPE_DESCRIPTION = "Warlords IV - Retinue File";
    public static final StandardFileFilter DEFAULT_FILTER = new StandardFileFilter(new String[]{"rit"}, "Warlords IV - Retinue File");
    private static final Random random = new Random();
    private static int gemID = random.nextInt();
    private String name = null;
    private int race = 0;
    private int type = 0;
    private int life = 10;
    private int combat = 5;
    private int upkeep = 0;
    private int experience = 0;
    private int level = 1;
    private Item head = Item.NULL_ITEM;
    private Item weapon = Item.NULL_ITEM;
    private Item armor = Item.NULL_ITEM;
    private Item accessory = Item.NULL_ITEM;
    private Ability major = Ability.NULL_ABILITY;
    private int majorLevel = 0;
    private Ability minor = Ability.NULL_ABILITY;
    private int minorLevel = 0;
    private int id = Unit.generateRandomID();
    private int upgrade = 0;

    public String getName() {
        return this.name;
    }

    public int getRace() {
        return this.race;
    }

    public int getType() {
        return this.type;
    }

    public int getLife() {
        return this.life;
    }

    public int getCombat() {
        return this.combat;
    }

    public int getUpkeep() {
        return this.upkeep;
    }

    public int getExperience() {
        return this.experience;
    }

    public int getLevel() {
        return this.level;
    }

    public Item getHeadItem() {
        return this.head;
    }

    public Item getWeaponItem() {
        return this.weapon;
    }

    public Item getArmorItem() {
        return this.armor;
    }

    public Item getAccessoryItem() {
        return this.accessory;
    }

    public Ability getMajorAbility() {
        return this.major;
    }

    public int getMajorLevel() {
        return this.majorLevel;
    }

    public Ability getMinorAbility() {
        return this.minor;
    }

    public int getMinorLevel() {
        return this.minorLevel;
    }

    public int getID() {
        return this.id;
    }

    public int getUpgrade() {
        return this.upgrade;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (name != null && name.length() > 31) {
            throw new IllegalArgumentException("The name must be less then 32 characters (" + name.length() + ").");
        }
        this.name = name;
    }

    public void setRace(int race) {
        if (race < 0 || race >= 10) {
            throw new IllegalArgumentException("The race is inavlide (" + race + "). Must be in range [0.." + 9 + "]");
        }
        this.race = race;
    }

    public void setType(int type) {
        if (type < 0 || type > 5) {
            throw new IllegalArgumentException("The type is inavlide (" + type + "). Must be in range [" + 0 + ".." + 5 + "]");
        }
        this.type = type;
    }

    public void setLife(int life) {
        if (life < 1 || life > 255) {
            throw new IllegalArgumentException("The life is inavlide (" + life + "). Must be in range [1..255]");
        }
        this.life = life;
    }

    public void setCombat(int combat) {
        if (combat < 1 || combat > 255) {
            throw new IllegalArgumentException("The combat is inavlide (" + combat + "). Must be in range [1..255]");
        }
        this.combat = combat;
    }

    public void setUpkeep(int upkeep) {
        if (upkeep < 0 || upkeep > 255) {
            throw new IllegalArgumentException("The upkeep is inavlide (" + upkeep + "). Must be in range [0..255]");
        }
        this.upkeep = upkeep;
    }

    public void setExperience(int experience) {
        if (experience < 0 || experience > 9999) {
            throw new IllegalArgumentException("The experience is inavlide (" + experience + "). Must be in range [0..32768]");
        }
        this.experience = experience;
    }

    public void setLevel(int level) {
        if (level < 1 || level > 999) {
            throw new IllegalArgumentException("The level is inavlide (" + level + "). Must be in range [1..32768]");
        }
        this.level = level;
    }

    public void setHeadItem(Item head) {
        if (head == null) {
            head = Item.NULL_ITEM;
        }
        this.head = head;
    }

    public void setWeaponItem(Item weapon) {
        if (weapon == null) {
            weapon = Item.NULL_ITEM;
        }
        this.weapon = weapon;
    }

    public void setArmorItem(Item armor) {
        if (armor == null) {
            armor = Item.NULL_ITEM;
        }
        this.armor = armor;
    }

    public void setAccessoryItem(Item accessory) {
        if (accessory == null) {
            accessory = Item.NULL_ITEM;
        }
        this.accessory = accessory;
    }

    public void setMajorAbility(Ability major) {
        if (major == null) {
            major = Ability.NULL_ABILITY;
        }
        this.major = major;
    }

    public void setMajorLevel(int majorLevel) {
        int abilityID = this.major.getID();
        if (majorLevel < 0 || majorLevel > (abilityID == 41 ? 255 : 5)) {
            throw new IllegalArgumentException("The major level is inavlide (" + majorLevel + "). Must be in range [0.." + (abilityID == 41 ? 255 : 5) + "]");
        }
        this.majorLevel = majorLevel;
    }

    public void setMinorAbility(Ability minor) {
        if (minor == null) {
            minor = Ability.NULL_ABILITY;
        }
        this.minor = minor;
    }

    public void setMinorLevel(int minorLevel) {
        int abilityID = this.minor.getID();
        if (minorLevel < 0 || minorLevel > (abilityID == 41 ? 255 : 5)) {
            throw new IllegalArgumentException("The minor level is inavlide (" + minorLevel + "). Must be in range [0.." + (abilityID == 41 ? 255 : 5) + "]");
        }
        this.minorLevel = minorLevel;
    }

    public void setID(int id) {
        this.id = id;
    }

    public void setUpgrade(int upgrade) {
        if (upgrade < 0 || upgrade > 2) {
            throw new IllegalArgumentException("The upgrade is inavlide (" + upgrade + "). Must be in range [0..2]");
        }
        this.upgrade = upgrade;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(32);
        LabeledIcon unitRace = UnitEditionPanel.RACE_NAMES.get(this.getRace());
        LabeledIcon unitType = UnitEditionPanel.getUnitName(this.getRace(), this.getType());
        String name = this.getName();
        if (name == null) {
            name = unitType.getLabel();
            name = name.substring(0, name.indexOf(40)).trim();
        }
        buffer.append(name);
        buffer.append(" (");
        buffer.append(unitRace.getLabel());
        buffer.append(": ");
        buffer.append(unitType.getLabel());
        buffer.append(')');
        return buffer.toString();
    }

    public static final int generateRandomID() {
        return gemID++;
    }
}

