/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.data;

import java.util.ArrayList;
import java.util.List;

public class NameRule {
    private int threshold = 100;
    private List<String> compoundName = new ArrayList<String>(8);

    public int getThreshold() {
        return this.threshold;
    }

    public int getCompoundNameCount() {
        return this.compoundName.size();
    }

    public String getCompoundName(int compoundNumber) {
        return this.compoundName.get(compoundNumber);
    }

    public void setThreshold(int threshold) {
        if (threshold < 1 || threshold > 100) {
            throw new IllegalArgumentException("Illegal threshold, value must be bewteen 1..100, now " + threshold);
        }
        this.threshold = threshold;
    }

    public void addCompoundName(String compoundName) {
        if (compoundName != null && compoundName.length() > 0) {
            this.compoundName.add(compoundName);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getThreshold());
        int count = 0;
        while (count < this.getCompoundNameCount()) {
            builder.append(" [");
            builder.append(this.getCompoundName(count++));
            builder.append(']');
        }
        return builder.toString();
    }

    public void parse(String rule) {
        rule = rule.replace('[', ' ').replace(']', ' ');
        String[] chunks = rule.split(" ");
        this.setThreshold(Integer.parseInt(chunks[0]));
        for (int i = 1; i < chunks.length; ++i) {
            this.addCompoundName(chunks[i]);
        }
    }
}

