/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.data;

import com.softlabs.warlords4.data.NameCompound;
import com.softlabs.warlords4.data.NameRule;
import com.softlabs.warlords4.data.NameRules;
import com.softlabs.warlords4.util.ReaderTokenizer;
import com.softlabs.warlords4.util.StreamUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NameGenerator {
    private NameRules rules;
    private Map<String, NameCompound> compounds = new HashMap<String, NameCompound>(8);

    public NameRules getRules() {
        return this.rules;
    }

    public void setRules(NameRules rules) {
        this.rules = rules;
    }

    public void addCompound(NameCompound compound) {
        this.compounds.put(compound.getName(), compound);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.rules != null) {
            builder.append(this.rules);
            builder.append('\n');
        }
        Iterator<String> keys = this.compounds.keySet().iterator();
        while (keys.hasNext()) {
            builder.append(this.compounds.get(keys.next())).append('\n');
        }
        return builder.toString();
    }

    public void load(String path) {
        try {
            InputStream stream = StreamUtil.getInputStream(path);
            InputStreamReader reader = new InputStreamReader(stream);
            ReaderTokenizer tokenizer = new ReaderTokenizer(reader);
            tokenizer.resetSyntax();
            tokenizer.wordChars(0, 255);
            tokenizer.whitespaceChars(0, 15);
            boolean rulesDone = false;
            NameCompound compound = null;
            NameRules rules = new NameRules();
            this.setRules(rules);
            while (tokenizer.nextToken() != -1) {
                if (tokenizer.ttype != -3) continue;
                String chunk = tokenizer.sval;
                if (chunk.charAt(0) == '[') {
                    String section = chunk.substring(1, chunk.length() - 1);
                    if (rulesDone) {
                        compound = new NameCompound();
                        compound.setName(section);
                        this.addCompound(compound);
                        continue;
                    }
                    if (rules.getRuleCount() <= 0) continue;
                    rulesDone = true;
                    tokenizer.pushBack();
                    continue;
                }
                if (rulesDone) {
                    compound.add(chunk);
                    continue;
                }
                NameRule rule = new NameRule();
                rule.parse(chunk);
                rules.addRule(rule);
            }
            stream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String generate() {
        StringBuilder builder = new StringBuilder(32);
        NameRule rule = this.rules.randomRule();
        for (int i = 0; i < rule.getCompoundNameCount(); ++i) {
            NameCompound compound = this.compounds.get(rule.getCompoundName(i));
            builder.append(compound.randomCompound());
        }
        return builder.toString();
    }
}

