/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.data;

import java.awt.Toolkit;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedPlainDocument
extends PlainDocument {
    public static final int DEFAULT_DOCUMENT_SIZE = 100;
    private int maxCharacters = 100;
    private boolean upperCase;
    private char[] charSet;

    public LimitedPlainDocument() {
        this(100, false);
    }

    public LimitedPlainDocument(int maxChars, boolean upperCase) {
        this(maxChars, upperCase, null);
    }

    public LimitedPlainDocument(int maxChars, char[] charSet) {
        this(maxChars, false, charSet);
    }

    public LimitedPlainDocument(int maxChars, boolean upperCase, char[] charSet) {
        if (maxChars < 0) {
            maxChars = 1;
        }
        this.maxCharacters = maxChars;
        this.upperCase = upperCase;
        if (charSet != null) {
            this.charSet = new char[charSet.length];
            System.arraycopy(charSet, 0, this.charSet, 0, this.charSet.length);
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String sub = str.substring(0, Math.min(str.length(), this.maxCharacters - this.getLength()));
        if (this.upperCase) {
            sub = sub.toUpperCase(Locale.getDefault());
        }
        if (this.charSet != null) {
            int size = sub.length();
            StringBuffer newSub = new StringBuffer(size);
            for (int i = 0; i < size; ++i) {
                char cur = sub.charAt(i);
                boolean ok = false;
                int cnt = 0;
                while (cnt < this.charSet.length && !ok) {
                    ok = this.charSet[cnt++] == cur;
                }
                if (ok) {
                    newSub.append(cur);
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            sub = newSub.toString();
        }
        if (sub.length() == 0) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            super.insertString(offs, sub, a);
        }
    }
}

