/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.data;

import com.softlabs.warlords4.data.Ability;
import com.softlabs.warlords4.data.LabelIconProvider;
import com.softlabs.warlords4.image.IconMap;
import com.softlabs.warlords4.image.ImageFactory;
import com.softlabs.warlords4.image.ResourceIcon;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;

public class Item
implements Comparable<Object>,
LabelIconProvider {
    public static final int TYPE_NONE = -1;
    public static final int TYPE_HEAD = 0;
    public static final int TYPE_WEAPON = 1;
    public static final int TYPE_ARMOR = 2;
    public static final int TYPE_ACCESSORY = 3;
    public static final int MAXIMUM_TYPE = 4;
    public static final int LEVEL_MINOR = 0;
    public static final int LEVEL_MAJOR = 1;
    public static final int LEVEL_ARTIFACT = 2;
    public static final int MINIMUM_POWER = 1;
    public static final int MAXIMUM_POWER = 5;
    private static final IconMap ICONS = new IconMap(ImageFactory.getImage("com/softlabs/warlords4/rsc/Items.png"), new Dimension(32, 32));
    public static final Item NULL_ITEM = new Item("<None>", -1, Ability.NULL_ABILITY, 1, 0, new ResourceIcon("com/softlabs/warlords4/rsc/item-none.png"), 0, 0);
    public static final List<Item> ITEMS_HEAD = new ArrayList<Item>(20);
    public static final List<Item> ITEMS_WEAPON = new ArrayList<Item>(20);
    public static final List<Item> ITEMS_ARMOR = new ArrayList<Item>(20);
    public static final List<Item> ITEMS_ACCESSORY = new ArrayList<Item>(20);
    private String name;
    private int type = -1;
    private Ability ability;
    private int power;
    private int id;
    private Icon icon;
    private int level;
    private int cost;

    public Item(String name, int type, Ability ability, int power, int id, Icon icon, int level, int cost) {
        this.setName(name);
        this.setType(type);
        this.setAbility(ability);
        this.setPower(power);
        this.setID(id);
        this.setIcon(icon);
        this.setLevel(level);
        this.setCost(cost);
    }

    public String getName() {
        return this.name;
    }

    public int getPower() {
        return this.power;
    }

    public int getType() {
        return this.type;
    }

    public Ability getAbility() {
        return this.ability;
    }

    public int getID() {
        return this.id;
    }

    public int getLevel() {
        return this.level;
    }

    public int getCost() {
        return this.cost;
    }

    private void setName(String name) {
        if (name == null) {
            throw new NullPointerException("The item name cannot be null.");
        }
        this.name = name;
    }

    private void setPower(int power) {
        if (power < 1 || power > 5) {
            throw new IllegalArgumentException("The power is inavlide (" + power + "). Must be in range [" + 1 + ".." + 5 + "]");
        }
        this.power = power;
    }

    private void setType(int type) {
        if (type < -1 || type >= 4) {
            throw new IllegalArgumentException("The type is inavlide (" + type + "). Must be in range [" + -1 + ".." + 3 + "]");
        }
        this.type = type;
    }

    private void setAbility(Ability ability) {
        if (ability == null) {
            throw new NullPointerException("The ability cannot be null.");
        }
        this.ability = ability;
    }

    private void setID(int id) {
        this.id = id;
    }

    private void setIcon(Icon icon) {
        this.icon = icon;
    }

    private void setLevel(int level) {
        this.level = level;
    }

    public void setCost(int cost) {
        if (cost < 0) {
            cost = 0;
        }
        this.cost = cost;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        if (this.getType() != -1) {
            buffer.append(" (");
            Ability ability = this.getAbility();
            buffer.append(ability.getName());
            buffer.append(": +");
            buffer.append(this.getPower());
            buffer.append(", Price: ");
            buffer.append(this.getCost());
            buffer.append(" gp");
            buffer.append(") [");
            switch (this.getLevel()) {
                default: {
                    buffer.append("Minor");
                    break;
                }
                case 1: {
                    buffer.append("Major");
                    break;
                }
                case 2: {
                    buffer.append("Artifact");
                }
            }
            buffer.append(']');
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj == this) {
            equals = true;
        } else if (obj instanceof Item) {
            Item item = (Item)obj;
            equals = this.getID() == item.getID() && this.getType() == item.getType() && this.getPower() == item.getPower() && this.getAbility().equals(item.getAbility());
        }
        return equals;
    }

    public int hashCode() {
        return this.getID() << 24 | this.getType() << 16 | this.getPower() << 8 | this.getAbility().getID();
    }

    public static Item createItem(int id) {
        Item temp;
        Item item = null;
        int cnt = 0;
        while (item == null && cnt < ITEMS_HEAD.size()) {
            if ((temp = ITEMS_HEAD.get(cnt++)).getID() != id) continue;
            item = temp;
        }
        cnt = 0;
        while (item == null && cnt < ITEMS_WEAPON.size()) {
            if ((temp = ITEMS_WEAPON.get(cnt++)).getID() != id) continue;
            item = temp;
        }
        cnt = 0;
        while (item == null && cnt < ITEMS_ARMOR.size()) {
            if ((temp = ITEMS_ARMOR.get(cnt++)).getID() != id) continue;
            item = temp;
        }
        cnt = 0;
        while (item == null && cnt < ITEMS_ACCESSORY.size()) {
            if ((temp = ITEMS_ACCESSORY.get(cnt++)).getID() != id) continue;
            item = temp;
        }
        return item;
    }

    @Override
    public int compareTo(Object object) {
        int compare = 0;
        if (object == null) {
            compare = 1;
        } else if (object instanceof Item) {
            Item item = (Item)object;
            compare = this.getName().compareTo(item.getName());
            if (compare == 0) {
                compare = this.hashCode() - object.hashCode();
            }
        } else {
            compare = this.hashCode() - object.hashCode();
        }
        return compare;
    }

    @Override
    public String getLabel() {
        return this.toString();
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public Icon getIcon(int size) {
        return this.icon;
    }

    static {
        TreeSet<Item> set = new TreeSet<Item>();
        set.add(new Item("Grotesque Helm", 0, Ability.createAbility(36), 1, 1, ICONS.getIcon(0), 0, 500));
        set.add(new Item("Helm of Sight", 0, Ability.createAbility(30), 2, 2, ICONS.getIcon(1), 0, 300));
        set.add(new Item("Ruby Helm", 0, Ability.createAbility(16), 1, 3, ICONS.getIcon(2), 0, 500));
        set.add(new Item("Helm of Speed", 0, Ability.createAbility(34), 1, 4, ICONS.getIcon(3), 0, 350));
        set.add(new Item("Gladiator's Helm", 0, Ability.createAbility(39), 2, 5, ICONS.getIcon(4), 0, 450));
        set.add(new Item("Warrior's Helm", 0, Ability.createAbility(39), 1, 6, ICONS.getIcon(5), 0, 300));
        set.add(new Item("Archer's Helm", 0, Ability.createAbility(1), 2, 7, ICONS.getIcon(6), 0, 750));
        set.add(new Item("Helm of Night", 0, Ability.createAbility(15), 1, 8, ICONS.getIcon(7), 0, 750));
        set.add(new Item("Elven Crown", 0, Ability.createAbility(22), 1, 9, ICONS.getIcon(8), 0, 750));
        set.add(new Item("Helm of Seeking", 0, Ability.createAbility(29), 2, 10, ICONS.getIcon(9), 0, 250));
        set.add(new Item("Helm of Truth", 0, Ability.createAbility(30), 2, 11, ICONS.getIcon(10), 0, 300));
        set.add(new Item("Helm of Life", 0, Ability.createAbility(40), 2, 12, ICONS.getIcon(11), 0, 250));
        set.add(new Item("Knight's Helm", 0, Ability.createAbility(39), 2, 13, ICONS.getIcon(12), 0, 450));
        set.add(new Item("Lysean Crown", 0, Ability.createAbility(20), 4, 14, ICONS.getIcon(13), 1, 500));
        set.add(new Item("Kinslayer Helm", 0, Ability.createAbility(21), 3, 15, ICONS.getIcon(14), 1, 700));
        set.add(new Item("Medusa Helm", 0, Ability.createAbility(9), 3, 16, ICONS.getIcon(15), 1, 1000));
        set.add(new Item("Witch's Crown", 0, Ability.createAbility(8), 3, 17, ICONS.getIcon(16), 1, 1300));
        set.add(new Item("Scorpion Helm", 0, Ability.createAbility(27), 4, 18, ICONS.getIcon(17), 1, 1200));
        set.add(new Item("Helm of War", 0, Ability.createAbility(39), 3, 19, ICONS.getIcon(18), 1, 600));
        set.add(new Item("Crown of Etheria", 0, Ability.createAbility(19), 5, 20, ICONS.getIcon(19), 2, 5000));
        set.add(new Item("Helm of Sartek", 0, Ability.createAbility(8), 5, 21, ICONS.getIcon(20), 2, 5000));
        set.add(new Item("Crown of KGB", 0, Ability.createAbility(56), 2, 103, ICONS.getIcon(21), 1, 1800));
        set.add(new Item("Mask of Vulcan", 0, Ability.createAbility(62), 2, 114, ICONS.getIcon(22), 1, 1000));
        ITEMS_HEAD.add(NULL_ITEM);
        ITEMS_HEAD.addAll(set);
        set.clear();
        set.add(new Item("Vampiric Blade", 1, Ability.createAbility(37), 1, 22, ICONS.getIcon(24), 0, 500));
        set.add(new Item("Oaken Staff", 1, Ability.createAbility(39), 2, 23, ICONS.getIcon(25), 0, 450));
        set.add(new Item("Bloodkrys", 1, Ability.createAbility(40), 3, 24, ICONS.getIcon(26), 0, 300));
        set.add(new Item("Sword of the Golem", 1, Ability.createAbility(7), 3, 25, ICONS.getIcon(27), 0, 1000));
        set.add(new Item("Assassin's Blade", 1, Ability.createAbility(3), 2, 26, ICONS.getIcon(28), 0, 600));
        set.add(new Item("Axe of Malice", 1, Ability.createAbility(5), 2, 27, ICONS.getIcon(29), 0, 750));
        set.add(new Item("Rod of Building", 1, Ability.createAbility(6), 2, 28, ICONS.getIcon(30), 0, 300));
        set.add(new Item("Mace of Crushing", 1, Ability.createAbility(7), 1, 29, ICONS.getIcon(31), 0, 500));
        set.add(new Item("Paladin's Blade", 1, Ability.createAbility(10), 2, 30, ICONS.getIcon(32), 0, 500));
        set.add(new Item("Giantblade", 1, Ability.createAbility(18), 2, 31, ICONS.getIcon(33), 0, 500));
        set.add(new Item("Wand of Healing", 1, Ability.createAbility(19), 2, 32, ICONS.getIcon(34), 0, 1000));
        set.add(new Item("Doubleblade", 1, Ability.createAbility(24), 1, 33, ICONS.getIcon(35), 0, 750));
        set.add(new Item("Orcslayer", 1, Ability.createAbility(26), 2, 34, ICONS.getIcon(36), 0, 500));
        set.add(new Item("Dagger of Venom", 1, Ability.createAbility(27), 2, 35, ICONS.getIcon(37), 0, 600));
        set.add(new Item("Vampiric Blade", 1, Ability.createAbility(37), 1, 36, ICONS.getIcon(38), 0, 500));
        set.add(new Item("Darksword", 1, Ability.createAbility(39), 1, 37, ICONS.getIcon(39), 0, 300));
        set.add(new Item("Bow of Accuracy", 1, Ability.createAbility(1), 1, 38, ICONS.getIcon(40), 0, 500));
        set.add(new Item("Redblade", 1, Ability.createAbility(39), 1, 39, ICONS.getIcon(41), 0, 300));
        set.add(new Item("Sword of Ankh", 1, Ability.createAbility(39), 1, 40, ICONS.getIcon(42), 0, 300));
        set.add(new Item("Bow of Eldros", 1, Ability.createAbility(1), 3, 41, ICONS.getIcon(43), 1, 1200));
        set.add(new Item("Axe of Slaying", 1, Ability.createAbility(3), 3, 42, ICONS.getIcon(44), 1, 750));
        set.add(new Item("Staff of Ruling", 1, Ability.createAbility(22), 3, 43, ICONS.getIcon(45), 1, 1500));
        set.add(new Item("Staff of Striking", 1, Ability.createAbility(17), 3, 44, ICONS.getIcon(46), 1, 1000));
        set.add(new Item("Mace of Disruption", 1, Ability.createAbility(10), 5, 45, ICONS.getIcon(47), 1, 750));
        set.add(new Item("Dragonblade", 1, Ability.createAbility(12), 5, 46, ICONS.getIcon(48), 1, 750));
        set.add(new Item("Staff of Striking", 1, Ability.createAbility(17), 3, 47, ICONS.getIcon(49), 1, 1000));
        set.add(new Item("Stormblade", 1, Ability.createAbility(18), 5, 48, ICONS.getIcon(50), 1, 750));
        set.add(new Item("Flail of Madness", 1, Ability.createAbility(24), 3, 49, ICONS.getIcon(51), 1, 1200));
        set.add(new Item("Wand of Negation", 1, Ability.createAbility(25), 3, 50, ICONS.getIcon(52), 1, 1100));
        set.add(new Item("Lightblade", 1, Ability.createAbility(39), 3, 51, ICONS.getIcon(53), 1, 600));
        set.add(new Item("Bow of Brianna", 1, Ability.createAbility(1), 5, 52, ICONS.getIcon(54), 2, 5000));
        set.add(new Item("Sword of Sirian", 1, Ability.createAbility(32), 5, 53, ICONS.getIcon(55), 2, 5000));
        set.add(new Item("Titan's Maul", 1, Ability.createAbility(7), 5, 54, ICONS.getIcon(56), 2, 5000));
        set.add(new Item("Sword of Etheria", 1, Ability.createAbility(4), 5, 55, ICONS.getIcon(57), 2, 5000));
        set.add(new Item("Melkor's Staff", 1, Ability.createAbility(16), 5, 56, ICONS.getIcon(58), 2, 5000));
        set.add(new Item("Greenblade's Sword", 1, Ability.createAbility(12), 5, 102, ICONS.getIcon(59), 1, 750));
        set.add(new Item("Heathen's Hammer", 1, Ability.createAbility(31), 1, 105, ICONS.getIcon(60), 0, 750));
        set.add(new Item("Cross of Power", 1, Ability.createAbility(61), 2, 112, ICONS.getIcon(61), 1, 1000));
        set.add(new Item("Sheppard's Staff", 1, Ability.createAbility(63), 1, 115, ICONS.getIcon(62), 0, 500));
        set.add(new Item("Daemonic CrossBow", 1, Ability.createAbility(59), 2, 121, ICONS.getIcon(63), 0, 500));
        set.add(new Item("Hero's Torch", 1, Ability.createAbility(66), 5, 122, ICONS.getIcon(64), 1, 750));
        ITEMS_WEAPON.add(NULL_ITEM);
        ITEMS_WEAPON.addAll(set);
        set.clear();
        set.add(new Item("Armor of Brilliance", 2, Ability.createAbility(23), 1, 57, ICONS.getIcon(72), 0, 350));
        set.add(new Item("Dwarven Mail", 2, Ability.createAbility(14), 2, 58, ICONS.getIcon(73), 0, 500));
        set.add(new Item("Elven Mail", 2, Ability.createAbility(13), 2, 59, ICONS.getIcon(74), 0, 500));
        set.add(new Item("Blessed Armor", 2, Ability.createAbility(4), 1, 60, ICONS.getIcon(75), 0, 750));
        set.add(new Item("Aelfwine's Armor", 2, Ability.createAbility(10), 2, 61, ICONS.getIcon(76), 0, 500));
        set.add(new Item("Midnight Armor", 2, Ability.createAbility(15), 2, 62, ICONS.getIcon(77), 0, 1000));
        set.add(new Item("Shining Armor", 2, Ability.createAbility(17), 1, 63, ICONS.getIcon(78), 0, 600));
        set.add(new Item("Armor of Warding", 2, Ability.createAbility(38), 1, 64, ICONS.getIcon(79), 0, 600));
        set.add(new Item("Druid's Necklace", 2, Ability.createAbility(28), 1, 65, ICONS.getIcon(80), 0, 500));
        set.add(new Item("Azrak's Armor", 2, Ability.createAbility(40), 2, 66, ICONS.getIcon(81), 0, 250));
        set.add(new Item("Necklace of Missiles", 2, Ability.createAbility(1), 2, 67, ICONS.getIcon(82), 0, 750));
        set.add(new Item("Merchant's Jewels", 2, Ability.createAbility(20), 4, 68, ICONS.getIcon(83), 1, 500));
        set.add(new Item("Healer's Torc", 2, Ability.createAbility(19), 3, 69, ICONS.getIcon(84), 1, 1250));
        set.add(new Item("Dragonscale Armor", 2, Ability.createAbility(2), 3, 70, ICONS.getIcon(85), 1, 1200));
        set.add(new Item("Holy Mail", 2, Ability.createAbility(4), 2, 71, ICONS.getIcon(86), 1, 1000));
        set.add(new Item("Daemongold Armor", 2, Ability.createAbility(40), 5, 72, ICONS.getIcon(87), 1, 750));
        set.add(new Item("Antharg's Armor", 2, Ability.createAbility(11), 5, 73, ICONS.getIcon(88), 2, 5000));
        set.add(new Item("Mithril Mail", 2, Ability.createAbility(2), 5, 74, ICONS.getIcon(89), 2, 5000));
        set.add(new Item("Armor of Etheria", 2, Ability.createAbility(38), 5, 75, ICONS.getIcon(90), 2, 5000));
        set.add(new Item("WizIce's Robe", 2, Ability.createAbility(23), 5, 106, ICONS.getIcon(91), 1, 800));
        set.add(new Item("Medal of Valor", 2, Ability.createAbility(60), 5, 107, ICONS.getIcon(92), 1, 1250));
        set.add(new Item("Paladin's Armor", 2, Ability.createAbility(61), 1, 111, ICONS.getIcon(93), 0, 500));
        set.add(new Item("Ranger's Cloak", 2, Ability.createAbility(49), 1, 123, ICONS.getIcon(94), 0, 400));
        ITEMS_ARMOR.add(NULL_ITEM);
        ITEMS_ARMOR.addAll(set);
        set.clear();
        set.add(new Item("Ring of Regeneration", 3, Ability.createAbility(28), 1, 76, ICONS.getIcon(96), 0, 500));
        set.add(new Item("Elspeth's Ring", 3, Ability.createAbility(19), 1, 77, ICONS.getIcon(97), 0, 750));
        set.add(new Item("Cursed Shield", 3, Ability.createAbility(8), 1, 78, ICONS.getIcon(98), 0, 700));
        set.add(new Item("Basilisk Shield", 3, Ability.createAbility(9), 1, 79, ICONS.getIcon(99), 0, 500));
        set.add(new Item("Banner of Plague", 3, Ability.createAbility(11), 2, 80, ICONS.getIcon(100), 0, 600));
        set.add(new Item("Dragon Banner", 3, Ability.createAbility(12), 2, 81, ICONS.getIcon(101), 0, 500));
        set.add(new Item("Ruby Ring", 3, Ability.createAbility(16), 1, 82, ICONS.getIcon(102), 0, 500));
        set.add(new Item("Golden Ring", 3, Ability.createAbility(20), 2, 83, ICONS.getIcon(103), 0, 200));
        set.add(new Item("Banner of Might", 3, Ability.createAbility(22), 1, 84, ICONS.getIcon(104), 0, 750));
        set.add(new Item("Warder's Shield", 3, Ability.createAbility(38), 1, 85, ICONS.getIcon(105), 0, 600));
        set.add(new Item("Shield of Negation", 3, Ability.createAbility(25), 1, 86, ICONS.getIcon(106), 0, 600));
        set.add(new Item("Ring of Darkness", 3, Ability.createAbility(36), 1, 87, ICONS.getIcon(107), 0, 500));
        set.add(new Item("Ring of Sight", 3, Ability.createAbility(30), 2, 88, ICONS.getIcon(108), 0, 300));
        set.add(new Item("Ring of Taunting", 3, Ability.createAbility(35), 2, 89, ICONS.getIcon(109), 0, 500));
        set.add(new Item("Ring of Health", 3, Ability.createAbility(40), 2, 90, ICONS.getIcon(110), 0, 250));
        set.add(new Item("Boots of Agility", 3, Ability.createAbility(39), 1, 91, ICONS.getIcon(111), 0, 300));
        set.add(new Item("Ring of Trolls", 3, Ability.createAbility(28), 2, 92, ICONS.getIcon(112), 1, 600));
        set.add(new Item("Ring of Building", 3, Ability.createAbility(6), 4, 93, ICONS.getIcon(113), 1, 750));
        set.add(new Item("Banner of Rage", 3, Ability.createAbility(5), 3, 94, ICONS.getIcon(114), 1, 1000));
        set.add(new Item("Orb of Fire", 3, Ability.createAbility(16), 3, 95, ICONS.getIcon(115), 1, 1000));
        set.add(new Item("Albion's Shield", 3, Ability.createAbility(38), 3, 96, ICONS.getIcon(116), 1, 1200));
        set.add(new Item("Boots of Speed", 3, Ability.createAbility(34), 3, 97, ICONS.getIcon(117), 1, 1000));
        set.add(new Item("Boots of Dancing", 3, Ability.createAbility(35), 4, 98, ICONS.getIcon(118), 1, 1000));
        set.add(new Item("Orb of Etheria", 3, Ability.createAbility(30), 5, 99, ICONS.getIcon(119), 2, 5000));
        set.add(new Item("Ring of Doom", 3, Ability.createAbility(36), 5, 100, ICONS.getIcon(120), 2, 5000));
        set.add(new Item("Dragonwizard's Orb", 3, Ability.createAbility(8), 3, 101, ICONS.getIcon(121), 1, 1300));
        set.add(new Item("Moonwine Cup", 3, Ability.createAbility(57), 3, 104, ICONS.getIcon(122), 0, 750));
        set.add(new Item("Golden Chest", 3, Ability.createAbility(50), 2, 110, ICONS.getIcon(123), 0, 400));
        set.add(new Item("Gloves of Skill", 3, Ability.createAbility(62), 1, 113, ICONS.getIcon(124), 0, 500));
        set.add(new Item("Summoning Orb", 3, Ability.createAbility(64), 1, 117, ICONS.getIcon(125), 0, 500));
        set.add(new Item("Tome of Necromancy", 3, Ability.createAbility(65), 1, 119, ICONS.getIcon(126), 0, 500));
        set.add(new Item("Beedub's Horn", 3, Ability.createAbility(52), 1, 108, ICONS.getIcon(127), 1, 1500));
        set.add(new Item("Figurine of Kor", 3, Ability.createAbility(58), 1, 109, ICONS.getIcon(23), 1, 1500));
        set.add(new Item("Four Leaf Clover", 3, Ability.createAbility(63), 2, 116, ICONS.getIcon(95), 1, 1000));
        set.add(new Item("Daemon's Heart", 3, Ability.createAbility(64), 2, 118, ICONS.getIcon(65), 1, 1000));
        set.add(new Item("Talking Skull", 3, Ability.createAbility(65), 2, 120, ICONS.getIcon(66), 1, 1000));
        set.add(new Item("A Kings Ransom", 3, Ability.createAbility(67), 1, 125, ICONS.getIcon(67), 1, 2500));
        set.add(new Item("Ring of Escape", 3, Ability.createAbility(68), 1, 124, ICONS.getIcon(68), 2, 5000));
        set.add(new Item("Dwarven Ale", 3, Ability.createAbility(73), 1, 126, ICONS.getIcon(70), 1, 1000));
        ITEMS_ACCESSORY.add(NULL_ITEM);
        ITEMS_ACCESSORY.addAll(set);
    }
}

