/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.data;

import com.softlabs.warlords4.gui.MessageDialog;
import com.softlabs.warlords4.gui.WarlordEditionFrame;
import com.softlabs.warlords4.util.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public class ApplicationPreferences
extends Preferences {
    public static final String DEFAULT_EXTENSION = "ini";
    public static final String DEFAULT_DESCRIPTION = "Application Settings File";
    private static final String DEFAULT_PREFERENCES_NAME = "Warlords4Editor";
    public static final String DEFAULT_PREFERENCES_FILENAME = "Warlords4Editor.ini";
    public static final String PROPERTY_BACKUP = "backup";
    public static final String PROPERTY_AUTO_LOAD = "autoLoad";
    public static final String PROPERTY_GAMEROOT = "gameRoot";
    public static final String PROPERTY_HISTORY = "history";
    public static final String PROPERTY_ENTRY = "entry";
    public static final String PROPERTY_LOCAL_HELP = "localHelp";
    public static final String PROPERTY_AUTO_UPDATE = "autoUpdate";
    public static final String PROPERTY_EXTENDED = "extended";
    public static final String PROPERTY_PROXY_USED = "proxyUsed";
    public static final String PROPERTY_PROXY_HOST = "proxyHost";
    public static final String PROPERTY_PROXY_PORT = "proxyPort";
    public static final String PROPERTY_LOOK_AND_FEEL = "plaf";
    public static final int DEFAULT_HISTORY = 4;
    public static final String DEFAULT_GAME_ROOT = null;
    public static final boolean DEFAULT_BACKUP = false;
    public static final boolean DEFAULT_AUTO_LOAD = false;
    public static final boolean DEFAULT_LOCAL_HELP = true;
    public static final boolean DEFAULT_AUTO_UPDATE = true;
    public static final String DEFAULT_EXTENDED = "looser!";
    public static final boolean DEFAULT_PROXY_USED = false;
    public static final String DEFAULT_PROXY_HOST = System.getProperty("http.proxyHost");
    public static final int DEFAULT_PROXY_PORT = System.getProperty("http.proxyPort") == null ? 8080 : Integer.parseInt(System.getProperty("http.proxyPort"));
    public static final String DEFAULT_LOOK_AND_FEEL = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
    public static final int EXTENDED_HASH = 146731693;
    private Map<Object, Object> preferences = new HashMap<Object, Object>();
    private String path;
    private static ApplicationPreferences defaultPrefs = null;
    private static boolean loaded;

    public String getPath() {
        return this.path;
    }

    public static final synchronized ApplicationPreferences getDefaultPreferences() {
        if (defaultPrefs == null) {
            ApplicationPreferences prefs = new ApplicationPreferences();
            if (!prefs.load(DEFAULT_PREFERENCES_FILENAME)) {
                File file;
                if (!loaded && (file = new File(DEFAULT_PREFERENCES_FILENAME)).exists()) {
                    MessageDialog messageDialog = new MessageDialog((JFrame)null, "Load Error", true, 4, 8);
                    messageDialog.setIcon(WarlordEditionFrame.WARLORD_ICON_BIG);
                    messageDialog.setMessage("<div style=\"font-size: 18;text-align: center;font-weight: bold;\">Warlords IV - Warlord & Retinues Editor 2.54</div><br>Impossible to load configuration file:<br />Warlords4Editor.ini");
                    messageDialog.pack();
                    messageDialog.setLocationRelativeTo(null);
                    messageDialog.showDialog();
                    messageDialog.dispose();
                }
                loaded = true;
            }
            defaultPrefs = prefs;
        }
        return defaultPrefs;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        try {
            String[] keys = this.keys();
            for (int i = 0; i < keys.length; ++i) {
                buffer.append(keys[i]);
                buffer.append('=');
                buffer.append(this.get(keys[i], null));
                buffer.append('\n');
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return buffer.toString();
    }

    @Override
    public void clear() {
        this.preferences.clear();
    }

    public void checkIntegrity() {
    }

    public void putAll(Map<Object, Object> map) {
        this.preferences.putAll(map);
    }

    public void putAll(ApplicationPreferences preferences) {
        this.putAll(preferences.preferences);
    }

    public boolean load() {
        boolean ok = false;
        if (this.getPath() != null) {
            ok = this.load(this.getPath());
        }
        return ok;
    }

    public boolean load(URL url) {
        boolean ok = false;
        try {
            InputStream input = null;
            try {
                URLConnection connection = url.openConnection();
                connection.setDefaultUseCaches(false);
                connection.setUseCaches(false);
                connection.connect();
                input = connection.getInputStream();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (input == null) {
                input = StreamUtil.getInputStream(url.toExternalForm());
            }
            if (input != null) {
                ok = this.load(input);
                input.close();
                ok = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setPath(url.toExternalForm());
        return ok;
    }

    public boolean load(String path) {
        boolean ok = false;
        try {
            InputStream input = null;
            try {
                input = new FileInputStream(path);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (input == null) {
                input = StreamUtil.getInputStream(path);
            }
            if (input != null) {
                ok = this.load(input);
                input.close();
                ok = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setPath(path);
        return ok;
    }

    public boolean load(InputStream stream) {
        boolean ok = false;
        if (stream != null) {
            try {
                Properties properties = new Properties();
                properties.load(stream);
                this.clear();
                this.putAll(properties);
                this.checkIntegrity();
                ok = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ok;
    }

    public boolean save() {
        boolean ok = false;
        if (this.getPath() != null) {
            ok = this.save(this.getPath());
        }
        return ok;
    }

    public boolean save(String target) {
        return this.save(target, null);
    }

    public boolean save(String target, String header) {
        boolean ok = false;
        try {
            OutputStream out = StreamUtil.getOutputStream(target, false);
            Properties properties = new Properties();
            properties.putAll(this.preferences);
            properties.store(out, header);
            out.close();
            ok = true;
        }
        catch (Throwable exception) {
            // empty catch block
        }
        this.setPath(target);
        return ok;
    }

    @Override
    public String absolutePath() {
        return null;
    }

    @Override
    public void addNodeChangeListener(NodeChangeListener listener) {
    }

    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener listener) {
    }

    @Override
    public String[] childrenNames() throws BackingStoreException {
        return new String[0];
    }

    @Override
    public void exportNode(OutputStream stream) throws IOException, BackingStoreException {
    }

    @Override
    public void exportSubtree(OutputStream os) throws IOException, BackingStoreException {
    }

    @Override
    public void flush() throws BackingStoreException {
        this.save();
    }

    @Override
    public String get(String key, String def) {
        String value = (String)this.preferences.get(key);
        return value == null ? def : value;
    }

    public String get(String key) {
        return (String)this.preferences.get(key);
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        String value = this.get(key);
        return value != null ? Boolean.valueOf(value) : def;
    }

    @Override
    public byte[] getByteArray(String key, byte[] def) {
        byte[] result = def;
        String value = this.get(key);
        if (value != null) {
            result = value.getBytes();
        }
        return result;
    }

    @Override
    public double getDouble(String key, double def) {
        String value = this.get(key);
        return value != null ? Double.valueOf(value) : def;
    }

    @Override
    public float getFloat(String key, float def) {
        String value = this.get(key);
        return value != null ? Float.valueOf(value).floatValue() : def;
    }

    @Override
    public int getInt(String key, int def) {
        String value = this.get(key);
        return value != null ? Integer.valueOf(value) : def;
    }

    @Override
    public long getLong(String key, long def) {
        String value = this.get(key);
        return value != null ? Long.valueOf(value) : def;
    }

    @Override
    public boolean isUserNode() {
        return true;
    }

    @Override
    public String[] keys() throws BackingStoreException {
        Set<Object> keySet = this.preferences.keySet();
        String[] keys = new String[this.preferences.size()];
        keySet.toArray(keys);
        return keys;
    }

    @Override
    public String name() {
        return null;
    }

    @Override
    public Preferences node(String pathName) {
        return null;
    }

    @Override
    public boolean nodeExists(String pathName) throws BackingStoreException {
        return false;
    }

    @Override
    public Preferences parent() {
        return null;
    }

    @Override
    public void put(String key, String value) {
        this.preferences.put(key, value);
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    @Override
    public void putByteArray(String key, byte[] value) {
        this.put(key, new String(value));
    }

    @Override
    public void putDouble(String key, double value) {
        this.put(key, Double.toString(value));
    }

    @Override
    public void putFloat(String key, float value) {
        this.put(key, Float.toString(value));
    }

    @Override
    public void putInt(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    @Override
    public void putLong(String key, long value) {
        this.put(key, Long.toString(value));
    }

    @Override
    public void remove(String key) {
        this.preferences.remove(key);
    }

    @Override
    public void removeNode() throws BackingStoreException {
    }

    @Override
    public void removeNodeChangeListener(NodeChangeListener listener) {
    }

    @Override
    public void removePreferenceChangeListener(PreferenceChangeListener listener) {
    }

    @Override
    public void sync() throws BackingStoreException {
        this.save();
    }
}

