/*
 * Decompiled with CFR 0.152.
 */
package com.softlabs.warlords4.data;

import com.softlabs.warlords4.data.LabelIconProvider;
import com.softlabs.warlords4.image.ResourceIcon;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;

public class Ability
implements Comparable<Object>,
LabelIconProvider {
    public static final int ABILITY_NONE = 0;
    public static final int ABILITY_ARCHERY = 1;
    public static final int ABILITY_ARMOR = 2;
    public static final int ABILITY_ASSASSIN = 3;
    public static final int ABILITY_BLESS = 4;
    public static final int ABILITY_BLOODLUST = 5;
    public static final int ABILITY_BUILD = 6;
    public static final int ABILITY_CRUSHING_BLOW = 7;
    public static final int ABILITY_CURSE = 8;
    public static final int ABILITY_DEATH_GAZE = 9;
    public static final int ABILITY_DEATHSLAYER = 10;
    public static final int ABILITY_DISEASE = 11;
    public static final int ABILITY_DRAGONSLAYER = 12;
    public static final int ABILITY_DWARFSALYER = 13;
    public static final int ABILITY_ELFSLAYER = 14;
    public static final int ABILITY_FEAR = 15;
    public static final int ABILITY_FIRE = 16;
    public static final int ABILITY_FIRST_STRIKE = 17;
    public static final int ABILITY_GIANTSLAYER = 18;
    public static final int ABILITY_HEAL = 19;
    public static final int ABILITY_INCOME = 20;
    public static final int ABILITY_MANSLAYER = 21;
    public static final int ABILITY_LEADERSHIP = 22;
    public static final int ABILITY_MAGIC_IMMUNITY = 23;
    public static final int ABILITY_MULTI_ATTACK = 24;
    public static final int ABILITY_NEGATE = 25;
    public static final int ABILITY_ORCSLAYER = 26;
    public static final int ABILITY_POSION = 27;
    public static final int ABILITY_REGENERATION = 28;
    public static final int ABILITY_SCAVENGING = 29;
    public static final int ABILITY_SCOUTING = 30;
    public static final int ABILITY_SIEGE = 31;
    public static final int ABILITY_SMITE_EVIL = 32;
    public static final int ABILITY_SMITE_GOOD = 33;
    public static final int ABILITY_SPEED = 34;
    public static final int ABILITY_TAUNT = 35;
    public static final int ABILITY_TERROR = 36;
    public static final int ABILITY_VAMPIRISM = 37;
    public static final int ABILITY_WARDING = 38;
    public static final int ABILITY_COMBAT = 39;
    public static final int ABILITY_LIFE = 40;
    public static final int ABILITY_EXTRA_TOUGH = 41;
    public static final int ABILITY_LIFE_ON_PRODUCTION = 42;
    public static final int ABILITY_SEE_IN_CITIES = 43;
    public static final int ABILITY_ENEMY_COMBAT = 44;
    public static final int ABILITY_TOWER_LIFE = 45;
    public static final int ABILITY_SIDE_MOVEMENT = 46;
    public static final int ABILITY_DOUBLE_EXPERIENCE = 47;
    public static final int ABILITY_NO_UPKEEP = 48;
    public static final int ABILITY_MOVE_BONUS = 49;
    public static final int ABILITY_CITY_GOLD = 50;
    public static final int ABILITY_ENEMY_MOVEMENT = 51;
    public static final int ABILITY_MORALE = 52;
    public static final int ABILITY_XP_ON_PRODUCTION = 53;
    public static final int ABILITY_FLIER_SIDE_MOVEMENT = 54;
    public static final int ABILITY_BONUS_INCOME = 55;
    public static final int ABILITY_MANA_REGENERATION = 56;
    public static final int ABILITY_MAXIMUM_MANA = 57;
    public static final int ABILITY_CHAOS = 58;
    public static final int ABILITY_DAEMONSLAYER = 59;
    public static final int ABILITY_COMBAT_XP_BONUS = 60;
    public static final int ABILITY_DIVINE_MAGIC = 61;
    public static final int ABILITY_RUNE_MAGIC = 62;
    public static final int ABILITY_NATURE_MAGIC = 63;
    public static final int ABILITY_SUMMONING_MAGIC = 64;
    public static final int ABILITY_NECROMANCY = 65;
    public static final int ABILITY_MONSTERSLAYER = 66;
    public static final int ABILITY_FEALTY = 67;
    public static final int ABILITY_ESCAPE = 68;
    public static final int ABILITY_DAMAGE = 69;
    public static final int ABILITY_CRITICAL_HIT = 70;
    public static final int ABILITY_LIFE_BONUS = 71;
    public static final int ABILITY_ANTI_MAGIC = 72;
    public static final int ABILITY_RECRUIT_ALLIES = 73;
    public static final int MAXIMUM_ABILITIES = 74;
    public static final Ability NULL_ABILITY = new Ability("<None>", 0);
    private static final int[] ABILITY_ID = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73};
    private static final String[] ABILITY_NAMES = new String[]{"Archery", "Armor", "Assassin", "Bless", "Bloodlust", "Build", "Crushing Blow", "Curse", "Death Gaze", "Deathslayer", "Disease", "Dragonslayer", "Dwarfslayer", "Elfslayer", "Fear", "Fire", "First Strike", "Giantslayer", "Heal", "Income", "Manslayer", "Leadership", "Magic Immunity", "Multi-Attack", "Negate", "Orcslayer", "Poison", "Regeneration", "Scavenging", "Scouting", "Siege", "Smite Evil", "Smite Good", "Speed", "Taunt", "Terror", "Vampirism", "Warding", "Combat", "Life", "Extra Tough", "Life on Production", "See in Cities", "Enemy Combat", "Tower Life", "Side Movement", "Double Experience", "No Upkeep", "Move Bonus", "City Gold", "Enemy Movement", "Morale", "XP on Production", "Flier Side Movement", "Bonus Income", "Mana Regeneration", "Maximum Mana", "Chaos", "Deamonslayer", "Combat XP Bonus", "Divine Magic", "Rune Magic", "Nature Magic", "Summoning Magic", "Necromancy", "Monsterslayer", "Fealty", "Escape", "Damage", "Critical Hit", "Life Bonus", "Anti Magic", "Recruit Allies"};
    private static final String[] ABILITY_DESCRIPTIONS = new String[]{"Chance of shooting the current enemy unit, every time a creature enters combat.", "Reduces damage a unit takes in combat from melee or missile attacks.", "Outright chance of killing a Hero in combat everytime he strikes it.", "Chance to Bless each friendly unit entering combat.", "When struck in melee combat, a unit may go into a blind rage. Increases its Combat skill", "Inside or adjacent to a city, helps to get a discount for city rebuilt or fortification", "A crushing halves the victim's remaining Life and then applies normal damage.", "Chance to Curse each enemy unit entering combat. ", "Chance to kill a unit outright before the fighting begins.", "Bonus to Damage and Combat scores vs. enemy Undead units.", "Diseased units cannot be healed and do half damage.", "Bonus to Damage and Combat scores vs. enemy Dragon units.", "Bonus to Damage and Combat scores vs. enemy Dwarven units.", "Bonus to Damage and Combat scores vs. enemy Elven units.", "Fear subtracts from the Combat skill of all enemy units in battle.", "Fire adds extra damage to each hit in combat. Fire ignores enemy Armor.", "First Strike always hits first when a new enemy enters combat.", "Bonus to Damage and Combat scores vs. enemy Giant units.", "Every time an enemy is defeated, heal the current friendly fighting unit.", "Contributes Gold towards your Income. It may also affect its group's upkeep.", "Bonus to Damage and Combat scores vs. enemy Human units.", "Adds Combat Skill and movement to the group.", "Protect the group against enemy spells.", "Hits all opponents in the enemy group who have not yet entered combat.", "Weakens most enemy special abilities.", "Bonus to Damage and Combat scores vs. enemy Orkish units.", "Poisoned units cannot be healed and their combat is reduced to two thirds.", "Regain some of its Life points every time a foe is killed in combat.", "Helps pillage, sack or raze a city, it adds to the gold found.", "Can see into ruins and enemy cities as well as increasing view range.", "Can attack enemy towers when in combat against a city.", "Adds extra damage every time it hits an evil unit.", "Adds extra damage every time it hits a good unit.", "Adds to the movement point allowance of its current group.", "Taunts the next weakest enemy unit into combat, and droppings this Combat by 3.", "Scare an enemy from combat as they begin fighting. A Terrorized unit has its combat and life reduced to 1.", "Leech back each point of damage it does in combat.", "Avoids the effects of Archery, Assassination and Death Gaze.", "Determines how well it performs in combat.", "The higher its Life score, the longer a unit can survive in combat.", "Only to Orcs. Increasing both Combat and Life at the same time.", "Boost the life on produced units.", "See in city ability.", "Enemy's combat modifier", "Tower life boost.", "Movement boost for side.", "Double experience in combat.", "Upkeep cost.", "Movement bonus.", "Gold income for a city.", "Movment of the enemy.", "Adds additonal morale points to the Warlord.", "Add XP when unit is produced.", "Boost in movment for fliers.", "Additonal income bonus.", "Regenerate mana each turn.", "Increases maximum mana.", "Chaos subtracts from the Morale of all enemy Warlords.", "Bonus to Damage and Combat scores vs. enemy deamon units.", "Get extra experience during combat.", "Bonus to Divine Magic skill of the Warlord.", "Bonus to Rune Magic skill of the Warlord.", "Bonus to Nature Magic skill of the Warlord.", "Bonus to Summoning Magic skill of the Warlord.", "Bonus to Necromancy Magic skill of the Warlord.", "Bonus to Damage and Combat scores vs. enemy monster units.", "Increase the Fealty to corrupt cities.", "Escape during combat", "Gives an extra damage bonus applied on top of the damage inflicted.", "Increase the chance of a critical hit.", "Additional life bonus.", "Increases the resistance of all your groups to enemy magic. Cumulative with the Magic Immunity skill.", "Adds to your percentage chance to get allies each turn"};
    public static final List<Ability> ABILITY_LIST = new ArrayList<Ability>(ABILITY_NAMES.length + 1);
    private String name;
    private int id;
    private Icon icon;
    private String description;
    private boolean skill;

    public Ability(String name, int id) {
        this.setName(name);
        this.setID(id);
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSkill() {
        return this.skill;
    }

    public void setSkill(boolean skill) {
        this.skill = skill;
    }

    private void setName(String name) {
        if (name == null) {
            throw new NullPointerException("The ability name cannot be null.");
        }
        this.name = name;
    }

    private void setID(int id) {
        if (id < 0 || id >= 74) {
            throw new IllegalArgumentException("The Id is inavlide (" + id + "). Must be in range [0.." + 73 + "]");
        }
        this.id = id;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof Ability) {
            Ability ability = (Ability)obj;
            equals = this.getID() == ability.getID();
        }
        return equals;
    }

    public int hashCode() {
        return this.getID();
    }

    public static Ability createAbility(int id) {
        Ability ability = null;
        for (int cnt = 0; ability == null && cnt < ABILITY_LIST.size(); ++cnt) {
            Ability ab = ABILITY_LIST.get(cnt);
            if (ab.getID() != id) continue;
            ability = ab;
        }
        return ability;
    }

    @Override
    public int compareTo(Object object) {
        int compare = 0;
        if (object == null) {
            compare = 1;
        } else if (object instanceof Ability) {
            Ability ability = (Ability)object;
            compare = this.getName().compareTo(ability.getName());
            if (compare == 0) {
                compare = this.hashCode() - object.hashCode();
            }
        } else {
            compare = this.hashCode() - object.hashCode();
        }
        return compare;
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public Icon getIcon(int size) {
        return this.icon;
    }

    static {
        ABILITY_LIST.add(NULL_ABILITY);
        NULL_ABILITY.setIcon(new ResourceIcon("com/softlabs/warlords4/rsc/ability00.png"));
        NULL_ABILITY.setDescription("No ability selected.");
        NULL_ABILITY.setSkill(true);
        StringBuffer name = new StringBuffer();
        TreeSet<Ability> temp = new TreeSet<Ability>();
        for (int i = ABILITY_NAMES.length; i > 0; --i) {
            Ability ability = new Ability(ABILITY_NAMES[i - 1], ABILITY_ID[i - 1]);
            name.setLength(0);
            name.append("com/softlabs/warlords4/rsc/ability");
            if (ABILITY_ID[i - 1] < 10) {
                name.append('0');
                name.append(ABILITY_ID[i - 1]);
            } else {
                name.append(ABILITY_ID[i - 1]);
            }
            name.append(".png");
            ability.setIcon(new ResourceIcon(name.toString()));
            ability.setDescription(ABILITY_DESCRIPTIONS[i - 1]);
            if (ABILITY_ID[i - 1] <= 38 || ABILITY_ID[i - 1] == 41 || ABILITY_ID[i - 1] == 59 || ABILITY_ID[i - 1] == 66) {
                ability.setSkill(true);
            }
            temp.add(ability);
        }
        ABILITY_LIST.addAll(temp);
    }
}

